/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token.format;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.crypto.KeyPair;
import com.clevercloud.biscuit.crypto.PublicKey;
import com.clevercloud.biscuit.error.Error;
import com.clevercloud.biscuit.token.Block;
import com.clevercloud.biscuit.token.format.Proof;
import com.clevercloud.biscuit.token.format.SignedBlock;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.vavr.API;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import net.i2p.crypto.eddsa.EdDSAEngine;

public class SerializedBiscuit {
    public SignedBlock authority;
    public List<SignedBlock> blocks;
    public Proof proof;
    public static int MIN_SCHEMA_VERSION = 3;
    public static int MAX_SCHEMA_VERSION = 3;

    public static SerializedBiscuit from_bytes(byte[] slice, PublicKey root) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        try {
            Schema.Biscuit data = Schema.Biscuit.parseFrom(slice);
            SignedBlock authority = new SignedBlock(data.getAuthority().getBlock().toByteArray(), new PublicKey(data.getAuthority().getNextKey().getAlgorithm(), data.getAuthority().getNextKey().getKey().toByteArray()), data.getAuthority().getSignature().toByteArray());
            ArrayList<SignedBlock> blocks = new ArrayList<SignedBlock>();
            for (Schema.SignedBlock block : data.getBlocksList()) {
                blocks.add(new SignedBlock(block.getBlock().toByteArray(), new PublicKey(block.getNextKey().getAlgorithm(), block.getNextKey().getKey().toByteArray()), block.getSignature().toByteArray()));
            }
            Option secretKey = Option.none();
            if (data.getProof().hasNextSecret()) {
                secretKey = Option.some((Object)new KeyPair(data.getProof().getNextSecret().toByteArray()));
            }
            Option signature = Option.none();
            if (data.getProof().hasFinalSignature()) {
                signature = Option.some((Object)data.getProof().getFinalSignature().toByteArray());
            }
            if (secretKey.isEmpty() && signature.isEmpty()) {
                throw new Error.FormatError.DeserializationError("empty proof");
            }
            Proof proof = new Proof((Option<KeyPair>)secretKey, (Option<byte[]>)signature);
            SerializedBiscuit b = new SerializedBiscuit(authority, blocks, proof);
            Either<Error, Void> res = b.verify(root);
            if (res.isLeft()) {
                Error e = (Error)res.getLeft();
                throw e;
            }
            return b;
        }
        catch (InvalidProtocolBufferException e) {
            throw new Error.FormatError.DeserializationError(e.toString());
        }
    }

    public static SerializedBiscuit unsafe_deserialize(byte[] slice) throws Error.FormatError.DeserializationError {
        try {
            Schema.Biscuit data = Schema.Biscuit.parseFrom(slice);
            SignedBlock authority = new SignedBlock(data.getAuthority().getBlock().toByteArray(), new PublicKey(data.getAuthority().getNextKey().getAlgorithm(), data.getAuthority().getNextKey().getKey().toByteArray()), data.getAuthority().getSignature().toByteArray());
            ArrayList<SignedBlock> blocks = new ArrayList<SignedBlock>();
            for (Schema.SignedBlock block : data.getBlocksList()) {
                blocks.add(new SignedBlock(block.getBlock().toByteArray(), new PublicKey(block.getNextKey().getAlgorithm(), block.getNextKey().getKey().toByteArray()), block.getSignature().toByteArray()));
            }
            Option secretKey = Option.none();
            if (data.getProof().hasNextSecret()) {
                secretKey = Option.some((Object)new KeyPair(data.getProof().getNextSecret().toByteArray()));
            }
            Option signature = Option.none();
            if (data.getProof().hasFinalSignature()) {
                signature = Option.some((Object)data.getProof().getFinalSignature().toByteArray());
            }
            if (secretKey.isEmpty() && signature.isEmpty()) {
                throw new Error.FormatError.DeserializationError("empty proof");
            }
            Proof proof = new Proof((Option<KeyPair>)secretKey, (Option<byte[]>)signature);
            SerializedBiscuit b = new SerializedBiscuit(authority, blocks, proof);
            return b;
        }
        catch (InvalidProtocolBufferException e) {
            throw new Error.FormatError.DeserializationError(e.toString());
        }
    }

    public byte[] serialize() throws Error.FormatError.SerializationError {
        Schema.Biscuit.Builder biscuitBuilder = Schema.Biscuit.newBuilder();
        Schema.SignedBlock.Builder authorityBuilder = Schema.SignedBlock.newBuilder();
        SignedBlock block = this.authority;
        Schema.PublicKey.Builder publicKey = Schema.PublicKey.newBuilder();
        publicKey.setKey(ByteString.copyFrom((byte[])block.key.toBytes()));
        publicKey.setAlgorithm(block.key.algorithm);
        authorityBuilder.setBlock(ByteString.copyFrom((byte[])block.block));
        authorityBuilder.setNextKey(publicKey.build());
        authorityBuilder.setSignature(ByteString.copyFrom((byte[])block.signature));
        biscuitBuilder.setAuthority(authorityBuilder.build());
        for (SignedBlock block2 : this.blocks) {
            Schema.SignedBlock.Builder blockBuilder = Schema.SignedBlock.newBuilder();
            Schema.PublicKey.Builder publicKey2 = Schema.PublicKey.newBuilder();
            publicKey2.setKey(ByteString.copyFrom((byte[])block2.key.toBytes()));
            publicKey2.setAlgorithm(block2.key.algorithm);
            blockBuilder.setBlock(ByteString.copyFrom((byte[])block2.block));
            blockBuilder.setNextKey(publicKey2.build());
            blockBuilder.setSignature(ByteString.copyFrom((byte[])block2.signature));
            biscuitBuilder.addBlocks(blockBuilder.build());
        }
        Schema.Proof.Builder proofBuilder = Schema.Proof.newBuilder();
        if (!this.proof.secretKey.isEmpty()) {
            proofBuilder.setNextSecret(ByteString.copyFrom((byte[])((KeyPair)this.proof.secretKey.get()).toBytes()));
        } else {
            proofBuilder.setFinalSignature(ByteString.copyFrom((byte[])((byte[])this.proof.signature.get())));
        }
        biscuitBuilder.setProof(proofBuilder.build());
        Schema.Biscuit biscuit = biscuitBuilder.build();
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            biscuit.writeTo(stream);
            byte[] data = stream.toByteArray();
            return data;
        }
        catch (IOException e) {
            throw new Error.FormatError.SerializationError(e.toString());
        }
    }

    public static Either<Error.FormatError, SerializedBiscuit> make(KeyPair root, Block authority, KeyPair next) {
        Schema.Block b = authority.serialize();
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            b.writeTo(stream);
            byte[] block = stream.toByteArray();
            PublicKey next_key = next.public_key();
            ByteBuffer algo_buf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            algo_buf.putInt(next_key.algorithm.getNumber());
            algo_buf.flip();
            EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance(KeyPair.ed25519.getHashAlgorithm()));
            sgr.initSign((PrivateKey)root.private_key);
            sgr.update(block);
            sgr.update(algo_buf);
            sgr.update(next_key.toBytes());
            byte[] signature = sgr.sign();
            SignedBlock signedBlock = new SignedBlock(block, next_key, signature);
            Proof proof = new Proof(next);
            return API.Right((Object)new SerializedBiscuit(signedBlock, new ArrayList<SignedBlock>(), proof));
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            return API.Left((Object)new Error.FormatError.SerializationError(e.toString()));
        }
    }

    public Either<Error.FormatError, SerializedBiscuit> append(KeyPair next, Block newBlock) {
        if (this.proof.secretKey.isEmpty()) {
            return API.Left((Object)new Error.FormatError.SerializationError("the token is sealed"));
        }
        Schema.Block b = newBlock.serialize();
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            b.writeTo(stream);
            byte[] block = stream.toByteArray();
            PublicKey next_key = next.public_key();
            ByteBuffer algo_buf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            algo_buf.putInt(next_key.algorithm.getNumber());
            algo_buf.flip();
            EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance(KeyPair.ed25519.getHashAlgorithm()));
            sgr.initSign((PrivateKey)((KeyPair)this.proof.secretKey.get()).private_key);
            sgr.update(block);
            sgr.update(algo_buf);
            sgr.update(next_key.toBytes());
            byte[] signature = sgr.sign();
            SignedBlock signedBlock = new SignedBlock(block, next_key, signature);
            ArrayList<SignedBlock> blocks = new ArrayList<SignedBlock>();
            for (SignedBlock bl : this.blocks) {
                blocks.add(bl);
            }
            blocks.add(signedBlock);
            Proof proof = new Proof(next);
            return API.Right((Object)new SerializedBiscuit(this.authority, blocks, proof));
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            return API.Left((Object)new Error.FormatError.SerializationError(e.toString()));
        }
    }

    public Either<Error, Void> verify(PublicKey root) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        EdDSAEngine sgr;
        byte[] signature;
        PublicKey next_key;
        byte[] block;
        SignedBlock b;
        PublicKey current_key = root;
        ByteBuffer algo_buf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        Object block2 = this.authority.block;
        PublicKey next_key2 = this.authority.key;
        byte[] signature2 = this.authority.signature;
        if (signature2.length != 64) {
            return Either.left((Object)new Error.FormatError.InvalidSignatureSize(signature2.length));
        }
        algo_buf.putInt(next_key2.algorithm.getNumber());
        algo_buf.flip();
        EdDSAEngine sgr2 = new EdDSAEngine(MessageDigest.getInstance(KeyPair.ed25519.getHashAlgorithm()));
        sgr2.initVerify((java.security.PublicKey)current_key.key);
        sgr2.update((byte[])block2);
        sgr2.update(algo_buf);
        sgr2.update(next_key2.toBytes());
        if (!sgr2.verify(signature2)) {
            return API.Left((Object)new Error.FormatError.Signature.InvalidSignature("signature error: Verification equation was not satisfied"));
        }
        current_key = next_key2;
        block2 = this.blocks.iterator();
        while (block2.hasNext()) {
            b = (SignedBlock)block2.next();
            block = b.block;
            next_key = b.key;
            signature = b.signature;
            if (signature.length != 64) {
                return Either.left((Object)new Error.FormatError.InvalidSignatureSize(signature.length));
            }
            algo_buf.clear();
            algo_buf.putInt(next_key.algorithm.getNumber());
            algo_buf.flip();
            sgr = new EdDSAEngine(MessageDigest.getInstance(KeyPair.ed25519.getHashAlgorithm()));
            sgr.initVerify((java.security.PublicKey)current_key.key);
            sgr.update(block);
            sgr.update(algo_buf);
            sgr.update(next_key.toBytes());
            if (sgr.verify(signature)) {
                current_key = next_key;
                continue;
            }
            return API.Left((Object)new Error.FormatError.Signature.InvalidSignature("signature error: Verification equation was not satisfied"));
        }
        if (!this.proof.secretKey.isEmpty()) {
            if (((KeyPair)this.proof.secretKey.get()).public_key().equals(current_key)) {
                return API.Right(null);
            }
            return API.Left((Object)new Error.FormatError.Signature.InvalidSignature("signature error: Verification equation was not satisfied"));
        }
        byte[] finalSignature = (byte[])this.proof.signature.get();
        b = this.blocks.isEmpty() ? this.authority : this.blocks.get(this.blocks.size() - 1);
        block = b.block;
        next_key = b.key;
        signature = b.signature;
        algo_buf.clear();
        algo_buf.putInt(next_key.algorithm.getNumber());
        algo_buf.flip();
        sgr = new EdDSAEngine(MessageDigest.getInstance(KeyPair.ed25519.getHashAlgorithm()));
        sgr.initVerify((java.security.PublicKey)current_key.key);
        sgr.update(block);
        sgr.update(algo_buf);
        sgr.update(next_key.toBytes());
        sgr.update(signature);
        if (sgr.verify(finalSignature)) {
            return API.Right(null);
        }
        return API.Left((Object)new Error.FormatError.SealedSignature());
    }

    public Either<Error, Void> seal() throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        if (this.proof.secretKey.isEmpty()) {
            return API.Left((Object)new Error.Sealed());
        }
        SignedBlock block = this.blocks.isEmpty() ? this.authority : this.blocks.get(this.blocks.size() - 1);
        EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance(KeyPair.ed25519.getHashAlgorithm()));
        ByteBuffer algo_buf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        algo_buf.putInt(block.key.algorithm.getNumber());
        algo_buf.flip();
        sgr.initSign((PrivateKey)((KeyPair)this.proof.secretKey.get()).private_key);
        sgr.update(block.block);
        sgr.update(algo_buf);
        sgr.update(block.key.toBytes());
        sgr.update(block.signature);
        byte[] signature = sgr.sign();
        this.proof.secretKey = Option.none();
        this.proof.signature = Option.some((Object)signature);
        return API.Right(null);
    }

    public List<byte[]> revocation_identifiers() {
        ArrayList<byte[]> l = new ArrayList<byte[]>();
        l.add(this.authority.signature);
        for (SignedBlock block : this.blocks) {
            l.add(block.signature);
        }
        return l;
    }

    SerializedBiscuit(SignedBlock authority, List<SignedBlock> blocks, Proof proof) {
        this.authority = authority;
        this.blocks = blocks;
        this.proof = proof;
    }
}

