/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token;

import com.clevercloud.biscuit.crypto.KeyPair;
import com.clevercloud.biscuit.crypto.PublicKey;
import com.clevercloud.biscuit.datalog.Check;
import com.clevercloud.biscuit.datalog.Fact;
import com.clevercloud.biscuit.datalog.Rule;
import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.datalog.World;
import com.clevercloud.biscuit.error.Error;
import com.clevercloud.biscuit.error.FailedCheck;
import com.clevercloud.biscuit.error.LogicError;
import com.clevercloud.biscuit.token.Biscuit;
import com.clevercloud.biscuit.token.RevocationIdentifier;
import com.clevercloud.biscuit.token.builder.Block;
import com.clevercloud.biscuit.token.format.SerializedBiscuit;
import com.clevercloud.biscuit.token.format.SignedBlock;
import io.vavr.API;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class UnverifiedBiscuit {
    final com.clevercloud.biscuit.token.Block authority;
    final List<com.clevercloud.biscuit.token.Block> blocks;
    final SymbolTable symbols;
    final SerializedBiscuit serializedBiscuit;
    final List<byte[]> revocation_ids;

    UnverifiedBiscuit(com.clevercloud.biscuit.token.Block authority, List<com.clevercloud.biscuit.token.Block> blocks, SymbolTable symbols, SerializedBiscuit serializedBiscuit, List<byte[]> revocation_ids) {
        this.authority = authority;
        this.blocks = blocks;
        this.symbols = symbols;
        this.serializedBiscuit = serializedBiscuit;
        this.revocation_ids = revocation_ids;
    }

    public static UnverifiedBiscuit from_b64url(String data) throws Error {
        return UnverifiedBiscuit.from_bytes(Base64.getUrlDecoder().decode(data));
    }

    public static UnverifiedBiscuit from_bytes(byte[] data) throws Error {
        return UnverifiedBiscuit.from_bytes_with_symbols(data, UnverifiedBiscuit.default_symbol_table());
    }

    public static UnverifiedBiscuit from_bytes_with_symbols(byte[] data, SymbolTable symbols) throws Error {
        SerializedBiscuit ser = SerializedBiscuit.unsafe_deserialize(data);
        return UnverifiedBiscuit.from_serialized_biscuit(ser, symbols);
    }

    private static UnverifiedBiscuit from_serialized_biscuit(SerializedBiscuit ser, SymbolTable symbols) throws Error {
        Either<Error.FormatError, com.clevercloud.biscuit.token.Block> authRes = com.clevercloud.biscuit.token.Block.from_bytes(ser.authority.block);
        if (authRes.isLeft()) {
            Error e = (Error)authRes.getLeft();
            throw e;
        }
        com.clevercloud.biscuit.token.Block authority = (com.clevercloud.biscuit.token.Block)authRes.get();
        ArrayList<com.clevercloud.biscuit.token.Block> blocks = new ArrayList<com.clevercloud.biscuit.token.Block>();
        for (SignedBlock bdata : ser.blocks) {
            Either<Error.FormatError, com.clevercloud.biscuit.token.Block> blockRes = com.clevercloud.biscuit.token.Block.from_bytes(bdata.block);
            if (blockRes.isLeft()) {
                Error e = (Error)blockRes.getLeft();
                throw e;
            }
            blocks.add((com.clevercloud.biscuit.token.Block)blockRes.get());
        }
        for (String s : authority.symbols.symbols) {
            symbols.add(s);
        }
        for (com.clevercloud.biscuit.token.Block b : blocks) {
            for (String s : b.symbols.symbols) {
                symbols.add(s);
            }
        }
        List<byte[]> revocation_ids = ser.revocation_identifiers();
        return new UnverifiedBiscuit(authority, blocks, symbols, ser, revocation_ids);
    }

    public byte[] serialize() throws Error.FormatError.SerializationError {
        return this.serializedBiscuit.serialize();
    }

    public String serialize_b64url() throws Error.FormatError.SerializationError {
        return Base64.getUrlEncoder().encodeToString(this.serialize());
    }

    public Block create_block() {
        return new Block(1 + this.blocks.size(), new SymbolTable(this.symbols));
    }

    public UnverifiedBiscuit attenuate(Block block) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        SecureRandom rng = new SecureRandom();
        KeyPair keypair = new KeyPair(rng);
        return this.attenuate(rng, keypair, block.build());
    }

    public UnverifiedBiscuit attenuate(SecureRandom rng, KeyPair keypair, com.clevercloud.biscuit.token.Block block) throws Error {
        UnverifiedBiscuit copiedBiscuit = this.copy();
        if (!Collections.disjoint(copiedBiscuit.symbols.symbols, block.symbols.symbols)) {
            throw new Error.SymbolTableOverlap();
        }
        Either<Error.FormatError, SerializedBiscuit> containerRes = copiedBiscuit.serializedBiscuit.append(keypair, block);
        if (containerRes.isLeft()) {
            Error.FormatError error = (Error.FormatError)containerRes.getLeft();
            throw error;
        }
        SerializedBiscuit container = (SerializedBiscuit)containerRes.get();
        SymbolTable symbols = new SymbolTable(copiedBiscuit.symbols);
        for (String string : block.symbols.symbols) {
            symbols.add(string);
        }
        ArrayList<com.clevercloud.biscuit.token.Block> blocks = new ArrayList<com.clevercloud.biscuit.token.Block>();
        for (com.clevercloud.biscuit.token.Block b : copiedBiscuit.blocks) {
            blocks.add(b);
        }
        blocks.add(block);
        List<byte[]> list = container.revocation_identifiers();
        return new UnverifiedBiscuit(copiedBiscuit.authority, blocks, symbols, container, list);
    }

    public List<RevocationIdentifier> revocation_identifiers() {
        return this.revocation_ids.stream().map(RevocationIdentifier::from_bytes).collect(Collectors.toList());
    }

    public List<List<Check>> checks() {
        ArrayList<List<Check>> l = new ArrayList<List<Check>>();
        l.add(new ArrayList<Check>(this.authority.checks));
        for (com.clevercloud.biscuit.token.Block b : this.blocks) {
            l.add(new ArrayList<Check>(b.checks));
        }
        return l;
    }

    Either<Error, World> generate_world() {
        World world = new World();
        for (Fact fact : this.authority.facts) {
            world.add_fact(fact);
        }
        for (Rule rule : this.authority.rules) {
            world.add_rule(rule);
        }
        for (com.clevercloud.biscuit.token.Block b : this.blocks) {
            for (Fact fact : b.facts) {
                world.add_fact(fact);
            }
            for (Rule rule : b.rules) {
                world.add_rule(rule);
            }
        }
        return API.Right((Object)world);
    }

    public List<Option<String>> context() {
        ArrayList<Option<String>> res = new ArrayList<Option<String>>();
        if (this.authority.context.isEmpty()) {
            res.add(Option.none());
        } else {
            res.add(Option.some((Object)this.authority.context));
        }
        for (com.clevercloud.biscuit.token.Block b : this.blocks) {
            if (b.context.isEmpty()) {
                res.add((Option<String>)Option.none());
                continue;
            }
            res.add((Option<String>)Option.some((Object)b.context));
        }
        return res;
    }

    HashMap<String, Set<Fact>> check(SymbolTable symbols, List<Fact> ambient_facts, List<Rule> ambient_rules, List<Check> authorizer_checks, HashMap<String, Rule> queries) throws Error {
        Set<Fact> res;
        int k;
        Check c;
        boolean successful;
        int j;
        Either<Error, World> wres = this.generate_world();
        if (wres.isLeft()) {
            Error e = (Error)wres.getLeft();
            throw e;
        }
        World world = (World)wres.get();
        for (Fact fact : ambient_facts) {
            world.add_fact(fact);
        }
        for (Rule rule : ambient_rules) {
            world.add_rule(rule);
        }
        world.run(symbols);
        ArrayList<FailedCheck> errors = new ArrayList<FailedCheck>();
        for (j = 0; j < this.authority.checks.size(); ++j) {
            successful = false;
            c = this.authority.checks.get(j);
            for (k = 0; k < c.queries().size(); ++k) {
                res = world.query_rule(c.queries().get(k), symbols);
                if (res.isEmpty()) continue;
                successful = true;
                break;
            }
            if (successful) continue;
            errors.add(new FailedCheck.FailedBlock(0L, j, symbols.print_check(this.authority.checks.get(j))));
        }
        for (j = 0; j < authorizer_checks.size(); ++j) {
            successful = false;
            c = authorizer_checks.get(j);
            for (k = 0; k < c.queries().size(); ++k) {
                res = world.query_rule(c.queries().get(k), symbols);
                if (res.isEmpty()) continue;
                successful = true;
                break;
            }
            if (successful) continue;
            errors.add(new FailedCheck.FailedAuthorizer(j + 1, symbols.print_check(authorizer_checks.get(j))));
        }
        for (int i = 0; i < this.blocks.size(); ++i) {
            com.clevercloud.biscuit.token.Block b = this.blocks.get(i);
            for (int j2 = 0; j2 < b.checks.size(); ++j2) {
                boolean successful2 = false;
                Check c2 = b.checks.get(j2);
                for (int k2 = 0; k2 < c2.queries().size(); ++k2) {
                    Set<Fact> res2 = world.query_rule(c2.queries().get(k2), symbols);
                    if (res2.isEmpty()) continue;
                    successful2 = true;
                    break;
                }
                if (successful2) continue;
                errors.add(new FailedCheck.FailedBlock(i + 1, j2, symbols.print_check(b.checks.get(j2))));
            }
        }
        HashMap<String, Set<Fact>> query_results = new HashMap<String, Set<Fact>>();
        for (String name : queries.keySet()) {
            Set<Fact> res3 = world.query_rule(queries.get(name), symbols);
            query_results.put(name, res3);
        }
        if (errors.isEmpty()) {
            return query_results;
        }
        throw new Error.FailedLogic(new LogicError.Unauthorized(new LogicError.MatchedPolicy.Allow(0L), errors));
    }

    public String print() {
        StringBuilder s = new StringBuilder();
        s.append("UnverifiedBiscuit {\n\tsymbols: ");
        s.append(this.symbols.getAllSymbols());
        s.append("\n\tauthority: ");
        s.append(this.authority.print(this.symbols));
        s.append("\n\tblocks: [\n");
        for (com.clevercloud.biscuit.token.Block b : this.blocks) {
            s.append("\t\t");
            s.append(b.print(this.symbols));
            s.append("\n");
        }
        s.append("\t]\n}");
        return s.toString();
    }

    public static SymbolTable default_symbol_table() {
        return new SymbolTable();
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public UnverifiedBiscuit copy() throws Error {
        return UnverifiedBiscuit.from_bytes(this.serialize());
    }

    public Biscuit verify(PublicKey publicKey) throws Error, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        SerializedBiscuit serializedBiscuit = this.serializedBiscuit;
        serializedBiscuit.verify(publicKey);
        return Biscuit.from_serialized_biscuit(serializedBiscuit, this.symbols);
    }
}

