/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseDataProcessor;
import com.clickhouse.client.ClickHouseDeserializer;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseOutputStream;
import com.clickhouse.client.ClickHouseSerializer;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.client.data.ClickHousePipedStream;
import com.clickhouse.client.data.ClickHouseRowBinaryProcessor;
import com.clickhouse.client.data.ClickHouseTabSeparatedProcessor;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class ClickHouseDataStreamFactory {
    private static final ClickHouseDataStreamFactory instance = ClickHouseUtils.getService(ClickHouseDataStreamFactory.class, new ClickHouseDataStreamFactory());
    protected static final String ERROR_NO_DESERIALIZER = "No deserializer available because format %s does not support input";
    protected static final String ERROR_NO_SERIALIZER = "No serializer available because format %s does not support output";
    protected static final String ERROR_UNSUPPORTED_FORMAT = "Unsupported format: ";

    public static ClickHouseDataStreamFactory getInstance() {
        return instance;
    }

    public ClickHouseDataProcessor getProcessor(ClickHouseConfig config, ClickHouseInputStream input, ClickHouseOutputStream output, Map<String, Object> settings, List<ClickHouseColumn> columns) throws IOException {
        ClickHouseDataProcessor processor;
        ClickHouseFormat format = ClickHouseChecker.nonNull(config, "config").getFormat();
        if (ClickHouseFormat.RowBinary == format || ClickHouseFormat.RowBinaryWithNamesAndTypes == format) {
            processor = new ClickHouseRowBinaryProcessor(config, input, output, columns, settings);
        } else if (ClickHouseFormat.TSVWithNames == format || ClickHouseFormat.TSVWithNamesAndTypes == format || ClickHouseFormat.TabSeparatedWithNames == format || ClickHouseFormat.TabSeparatedWithNamesAndTypes == format) {
            processor = new ClickHouseTabSeparatedProcessor(config, input, output, columns, settings);
        } else if (format != null && format.isText()) {
            processor = new ClickHouseTabSeparatedProcessor(config, input, output, ClickHouseDataProcessor.DEFAULT_COLUMNS, settings);
        } else {
            throw new IllegalArgumentException(ERROR_UNSUPPORTED_FORMAT + (Object)((Object)format));
        }
        return processor;
    }

    public ClickHouseDeserializer<ClickHouseValue> getDeserializer(ClickHouseFormat format) {
        ClickHouseDeserializer<ClickHouseValue> deserializer;
        if (format == null) {
            format = (ClickHouseFormat)((Object)ClickHouseDefaults.FORMAT.getEffectiveDefaultValue());
        }
        if (!format.supportsInput()) {
            throw new IllegalArgumentException(ClickHouseUtils.format(ERROR_NO_DESERIALIZER, format.name()));
        }
        if (format.isText()) {
            deserializer = ClickHouseTabSeparatedProcessor.getMappedFunctions(format);
        } else if (format == ClickHouseFormat.RowBinary || format == ClickHouseFormat.RowBinaryWithNamesAndTypes) {
            deserializer = ClickHouseRowBinaryProcessor.getMappedFunctions();
        } else {
            throw new IllegalArgumentException(ERROR_UNSUPPORTED_FORMAT + (Object)((Object)format));
        }
        return deserializer;
    }

    public ClickHouseSerializer<ClickHouseValue> getSerializer(ClickHouseFormat format) {
        ClickHouseDeserializer<ClickHouseValue> serializer;
        if (format == null) {
            format = (ClickHouseFormat)((Object)ClickHouseDefaults.FORMAT.getEffectiveDefaultValue());
        }
        if (!format.supportsOutput()) {
            throw new IllegalArgumentException(ClickHouseUtils.format(ERROR_NO_SERIALIZER, format.name()));
        }
        if (format.isText()) {
            serializer = ClickHouseTabSeparatedProcessor.getMappedFunctions(format);
        } else if (format == ClickHouseFormat.RowBinary || format == ClickHouseFormat.RowBinaryWithNamesAndTypes) {
            serializer = ClickHouseRowBinaryProcessor.getMappedFunctions();
        } else {
            throw new IllegalArgumentException(ERROR_UNSUPPORTED_FORMAT + (Object)((Object)format));
        }
        return serializer;
    }

    public ClickHousePipedStream createPipedStream(ClickHouseConfig config) {
        ClickHouseChecker.nonNull(config, "config");
        return new ClickHousePipedStream(config.getWriteBufferSize(), config.getMaxQueuedBuffers(), config.getSocketTimeout());
    }
}

