/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.client.config.ClickHouseOption;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;

public class ClickHouseClientBuilder {
    static final ExecutorService defaultExecutor;
    protected ClickHouseConfig config;
    protected ClickHouseCredentials credentials;
    protected Object metricRegistry;
    protected ClickHouseNodeSelector nodeSelector;
    protected final Map<ClickHouseOption, Serializable> options = new HashMap<ClickHouseOption, Serializable>();

    protected ClickHouseClientBuilder() {
    }

    protected void resetConfig() {
        if (this.config != null) {
            this.config = null;
        }
    }

    public ClickHouseConfig getConfig() {
        if (this.config == null) {
            this.config = new ClickHouseConfig(this.options, this.credentials, this.nodeSelector, this.metricRegistry);
        }
        return this.config;
    }

    public ClickHouseClient build() {
        ClickHouseClient client = null;
        boolean noSelector = this.nodeSelector == null || this.nodeSelector == ClickHouseNodeSelector.EMPTY;
        int counter = 0;
        for (ClickHouseClient c : ServiceLoader.load(ClickHouseClient.class, this.getClass().getClassLoader())) {
            ++counter;
            if (!noSelector && !this.nodeSelector.match(c)) continue;
            client = c;
            break;
        }
        if (client == null) {
            throw new IllegalStateException(ClickHouseUtils.format("No suitable ClickHouse client(out of %d) found in classpath.", counter));
        }
        client.init(this.getConfig());
        return client;
    }

    public ClickHouseClientBuilder config(ClickHouseConfig config) {
        this.config = config;
        this.credentials = config.getDefaultCredentials();
        this.metricRegistry = config.getMetricRegistry().orElse(null);
        this.nodeSelector = config.getNodeSelector();
        this.options.putAll(config.getAllOptions());
        return this;
    }

    public ClickHouseClientBuilder option(ClickHouseOption option, Serializable value) {
        if (option == null || value == null) {
            throw new IllegalArgumentException("Non-null option and value are required");
        }
        Serializable oldValue = this.options.put(option, value);
        if (oldValue == null || !value.equals(oldValue)) {
            this.resetConfig();
        }
        return this;
    }

    public ClickHouseClientBuilder removeOption(ClickHouseOption option) {
        Serializable value = this.options.remove(ClickHouseChecker.nonNull(option, "option"));
        if (value != null) {
            this.resetConfig();
        }
        return this;
    }

    public ClickHouseClientBuilder options(Map<ClickHouseOption, Serializable> options) {
        if (options != null && !options.isEmpty()) {
            this.options.putAll(options);
            this.resetConfig();
        }
        return this;
    }

    public ClickHouseClientBuilder defaultCredentials(ClickHouseCredentials credentials) {
        if (!ClickHouseChecker.nonNull(credentials, "credentials").equals(this.credentials)) {
            this.credentials = credentials;
            this.resetConfig();
        }
        return this;
    }

    public ClickHouseClientBuilder nodeSelector(ClickHouseNodeSelector nodeSelector) {
        if (!ClickHouseChecker.nonNull(nodeSelector, "nodeSelector").equals(this.nodeSelector)) {
            this.nodeSelector = nodeSelector;
            this.resetConfig();
        }
        return this;
    }

    public ClickHouseClientBuilder metricRegistry(Object metricRegistry) {
        if (!Objects.equals(this.metricRegistry, metricRegistry)) {
            this.metricRegistry = metricRegistry;
            this.resetConfig();
        }
        return this;
    }

    static {
        int maxThreads = (Integer)ClickHouseDefaults.MAX_THREADS.getEffectiveDefaultValue();
        int maxRequests = (Integer)ClickHouseDefaults.MAX_REQUESTS.getEffectiveDefaultValue();
        if (maxThreads <= 0 && maxRequests <= 0) {
            defaultExecutor = ForkJoinPool.commonPool();
        } else {
            if (maxThreads <= 0) {
                maxThreads = Runtime.getRuntime().availableProcessors();
            }
            if (maxRequests <= 0) {
                maxRequests = 0;
            }
            defaultExecutor = ClickHouseUtils.newThreadPool(ClickHouseClient.class.getSimpleName(), maxThreads, maxRequests);
        }
    }
}

