/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseCompression;
import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseVersion;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.client.config.ClickHouseOption;
import com.clickhouse.client.config.ClickHouseSslMode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;

public class ClickHouseConfig
implements Serializable {
    private static final long serialVersionUID = 7794222888859182491L;
    private final boolean async;
    private final String clientName;
    private final boolean compressServerResponse;
    private final ClickHouseCompression compressAlgorithm;
    private final int compressLevel;
    private final boolean decompressClientRequest;
    private final ClickHouseCompression decompressAlgorithm;
    private final int decompressLevel;
    private final int connectionTimeout;
    private final String database;
    private final ClickHouseFormat format;
    private final int maxBufferSize;
    private final int maxExecutionTime;
    private final int maxQueuedBuffers;
    private final int maxQueuedRequests;
    private final int maxResultRows;
    private final int maxThreads;
    private final boolean retry;
    private final boolean reuseValueWrapper;
    private final boolean serverInfo;
    private final TimeZone serverTimeZone;
    private final ClickHouseVersion serverVersion;
    private final int sessionTimeout;
    private final boolean sessionCheck;
    private final int socketTimeout;
    private final boolean ssl;
    private final ClickHouseSslMode sslMode;
    private final String sslRootCert;
    private final String sslCert;
    private final String sslKey;
    private final boolean useObjectsInArray;
    private final boolean useServerTimeZone;
    private final String useTimeZone;
    private final boolean useServerTimeZoneForDate;
    private final Map<ClickHouseOption, Serializable> options = new HashMap<ClickHouseOption, Serializable>();
    private final ClickHouseCredentials credentials;
    private final transient Optional<Object> metricRegistry;
    private final ClickHouseNodeSelector nodeSelector;

    protected static final Map<ClickHouseOption, Serializable> mergeOptions(List<ClickHouseConfig> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<ClickHouseOption, Serializable> options = new HashMap<ClickHouseOption, Serializable>();
        ArrayList<ClickHouseConfig> cl = new ArrayList<ClickHouseConfig>(list.size());
        for (ClickHouseConfig c : list) {
            if (c == null) continue;
            boolean duplicated = false;
            for (ClickHouseConfig conf : cl) {
                if (conf != c) continue;
                duplicated = true;
                break;
            }
            if (duplicated) continue;
            options.putAll(c.options);
            cl.add(c);
        }
        return options;
    }

    protected static final ClickHouseCredentials mergeCredentials(List<ClickHouseConfig> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ClickHouseCredentials credentials = null;
        for (ClickHouseConfig c : list) {
            if (c == null || c.credentials == null) continue;
            credentials = c.credentials;
            break;
        }
        return credentials;
    }

    protected static final ClickHouseNodeSelector mergeNodeSelector(List<ClickHouseConfig> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ClickHouseNodeSelector nodeSelector = null;
        for (ClickHouseConfig c : list) {
            if (c == null || c.nodeSelector == null) continue;
            nodeSelector = c.nodeSelector;
            break;
        }
        return nodeSelector;
    }

    protected static final Object mergeMetricRegistry(List<ClickHouseConfig> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Object metricRegistry = null;
        for (ClickHouseConfig c : list) {
            if (c == null || !c.metricRegistry.isPresent()) continue;
            metricRegistry = c.metricRegistry.get();
            break;
        }
        return metricRegistry;
    }

    public ClickHouseConfig(ClickHouseConfig ... configs) {
        this(configs == null || configs.length == 0 ? Collections.emptyList() : Arrays.asList(configs));
    }

    public ClickHouseConfig(List<ClickHouseConfig> configs) {
        this(ClickHouseConfig.mergeOptions(configs), ClickHouseConfig.mergeCredentials(configs), ClickHouseConfig.mergeNodeSelector(configs), ClickHouseConfig.mergeMetricRegistry(configs));
    }

    public ClickHouseConfig(Map<ClickHouseOption, Serializable> options, ClickHouseCredentials credentials, ClickHouseNodeSelector nodeSelector, Object metricRegistry) {
        if (options != null) {
            this.options.putAll(options);
        }
        this.async = (Boolean)this.getOption(ClickHouseClientOption.ASYNC, ClickHouseDefaults.ASYNC);
        this.clientName = (String)((Object)this.getOption(ClickHouseClientOption.CLIENT_NAME));
        this.compressServerResponse = (Boolean)this.getOption(ClickHouseClientOption.COMPRESS);
        this.compressAlgorithm = (ClickHouseCompression)((Object)this.getOption(ClickHouseClientOption.COMPRESS_ALGORITHM));
        this.compressLevel = (Integer)this.getOption(ClickHouseClientOption.COMPRESS_LEVEL);
        this.decompressClientRequest = (Boolean)this.getOption(ClickHouseClientOption.DECOMPRESS);
        this.decompressAlgorithm = (ClickHouseCompression)((Object)this.getOption(ClickHouseClientOption.DECOMPRESS_ALGORITHM));
        this.decompressLevel = (Integer)this.getOption(ClickHouseClientOption.DECOMPRESS_LEVEL);
        this.connectionTimeout = (Integer)this.getOption(ClickHouseClientOption.CONNECTION_TIMEOUT);
        this.database = (String)((Object)this.getOption(ClickHouseClientOption.DATABASE, ClickHouseDefaults.DATABASE));
        this.format = (ClickHouseFormat)((Object)this.getOption(ClickHouseClientOption.FORMAT, ClickHouseDefaults.FORMAT));
        this.maxBufferSize = (Integer)this.getOption(ClickHouseClientOption.MAX_BUFFER_SIZE);
        this.maxExecutionTime = (Integer)this.getOption(ClickHouseClientOption.MAX_EXECUTION_TIME);
        this.maxQueuedBuffers = (Integer)this.getOption(ClickHouseClientOption.MAX_QUEUED_BUFFERS);
        this.maxQueuedRequests = (Integer)this.getOption(ClickHouseClientOption.MAX_QUEUED_REQUESTS);
        this.maxResultRows = (Integer)this.getOption(ClickHouseClientOption.MAX_RESULT_ROWS);
        this.maxThreads = (Integer)this.getOption(ClickHouseClientOption.MAX_THREADS_PER_CLIENT);
        this.retry = (Boolean)this.getOption(ClickHouseClientOption.RETRY);
        this.reuseValueWrapper = (Boolean)this.getOption(ClickHouseClientOption.REUSE_VALUE_WRAPPER);
        this.serverInfo = !ClickHouseChecker.isNullOrBlank((String)((Object)this.getOption(ClickHouseClientOption.SERVER_TIME_ZONE))) && !ClickHouseChecker.isNullOrBlank((String)((Object)this.getOption(ClickHouseClientOption.SERVER_VERSION)));
        this.serverTimeZone = TimeZone.getTimeZone((String)((Object)this.getOption(ClickHouseClientOption.SERVER_TIME_ZONE, ClickHouseDefaults.SERVER_TIME_ZONE)));
        this.serverVersion = ClickHouseVersion.of((String)((Object)this.getOption(ClickHouseClientOption.SERVER_VERSION, ClickHouseDefaults.SERVER_VERSION)));
        this.sessionTimeout = (Integer)this.getOption(ClickHouseClientOption.SESSION_TIMEOUT);
        this.sessionCheck = (Boolean)this.getOption(ClickHouseClientOption.SESSION_CHECK);
        this.socketTimeout = (Integer)this.getOption(ClickHouseClientOption.SOCKET_TIMEOUT);
        this.ssl = (Boolean)this.getOption(ClickHouseClientOption.SSL);
        this.sslMode = (ClickHouseSslMode)((Object)this.getOption(ClickHouseClientOption.SSL_MODE));
        this.sslRootCert = (String)((Object)this.getOption(ClickHouseClientOption.SSL_ROOT_CERTIFICATE));
        this.sslCert = (String)((Object)this.getOption(ClickHouseClientOption.SSL_CERTIFICATE));
        this.sslKey = (String)((Object)this.getOption(ClickHouseClientOption.SSL_KEY));
        this.useObjectsInArray = (Boolean)this.getOption(ClickHouseClientOption.USE_OBJECTS_IN_ARRAYS);
        this.useServerTimeZone = (Boolean)this.getOption(ClickHouseClientOption.USE_SERVER_TIME_ZONE);
        this.useServerTimeZoneForDate = (Boolean)this.getOption(ClickHouseClientOption.USE_SERVER_TIME_ZONE_FOR_DATES);
        this.useTimeZone = (String)((Object)this.getOption(ClickHouseClientOption.USE_TIME_ZONE));
        this.credentials = credentials == null ? ClickHouseCredentials.fromUserAndPassword((String)((Object)this.getOption(ClickHouseDefaults.USER)), (String)((Object)this.getOption(ClickHouseDefaults.PASSWORD))) : credentials;
        this.metricRegistry = Optional.ofNullable(metricRegistry);
        this.nodeSelector = nodeSelector == null ? ClickHouseNodeSelector.EMPTY : nodeSelector;
    }

    public boolean isAsync() {
        return this.async;
    }

    public String getClientName() {
        return this.clientName;
    }

    public boolean isCompressServerResponse() {
        return this.compressServerResponse;
    }

    public ClickHouseCompression getCompressAlgorithmForServerResponse() {
        return this.compressAlgorithm;
    }

    public int getCompressLevelForServerResponse() {
        return this.compressLevel;
    }

    public boolean isDecompressClientRequet() {
        return this.decompressClientRequest;
    }

    public ClickHouseCompression getDecompressAlgorithmForClientRequest() {
        return this.decompressAlgorithm;
    }

    public int getDecompressLevelForClientRequest() {
        return this.decompressLevel;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public String getDatabase() {
        return this.database;
    }

    public ClickHouseFormat getFormat() {
        return this.format;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public int getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    public int getMaxQueuedBuffers() {
        return this.maxQueuedBuffers;
    }

    public int getMaxQueuedRequests() {
        return this.maxQueuedRequests;
    }

    public int getMaxResultRows() {
        return this.maxResultRows;
    }

    public int getMaxThreadsPerClient() {
        return this.maxThreads;
    }

    public boolean isRetry() {
        return this.retry;
    }

    public boolean isReuseValueWrapper() {
        return this.reuseValueWrapper;
    }

    public boolean hasServerInfo() {
        return this.serverInfo;
    }

    public TimeZone getServerTimeZone() {
        return this.serverTimeZone;
    }

    public ClickHouseVersion getServerVersion() {
        return this.serverVersion;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public boolean isSessionCheck() {
        return this.sessionCheck;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public ClickHouseSslMode getSslMode() {
        return this.sslMode;
    }

    public String getSslRootCert() {
        return this.sslRootCert;
    }

    public String getSslCert() {
        return this.sslCert;
    }

    public String getSslKey() {
        return this.sslKey;
    }

    public boolean isUseObjectsInArray() {
        return this.useObjectsInArray;
    }

    public boolean isUseServerTimeZone() {
        return this.useServerTimeZone;
    }

    public String getUseTimeZone() {
        return this.useTimeZone;
    }

    public boolean isUseServerTimeZoneForDate() {
        return this.useServerTimeZoneForDate;
    }

    public ClickHouseCredentials getDefaultCredentials() {
        return this.credentials;
    }

    public Optional<Object> getMetricRegistry() {
        return this.metricRegistry;
    }

    public ClickHouseNodeSelector getNodeSelector() {
        return this.nodeSelector;
    }

    public List<ClickHouseProtocol> getPreferredProtocols() {
        return this.nodeSelector.getPreferredProtocols();
    }

    public Set<String> getPreferredTags() {
        return this.nodeSelector.getPreferredTags();
    }

    public Map<ClickHouseOption, Serializable> getAllOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    public Serializable getOption(ClickHouseOption option) {
        return this.getOption(option, null);
    }

    public Serializable getOption(ClickHouseOption option, ClickHouseDefaults defaultValue) {
        return this.options.getOrDefault(ClickHouseChecker.nonNull(option, "option"), defaultValue == null ? option.getEffectiveDefaultValue() : defaultValue.getEffectiveDefaultValue());
    }

    public boolean hasOption(ClickHouseOption option) {
        return option != null && this.options.containsKey(option);
    }
}

