/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.config;

import java.io.Serializable;
import java.util.Optional;

public interface ClickHouseOption
extends Serializable {
    public static <T extends Serializable> T fromString(String value, Class<T> clazz) {
        Object result;
        if (value == null || clazz == null) {
            throw new IllegalArgumentException("Non-null value and class are required");
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            Boolean boolValue = "1".equals(value) || "0".equals(value) ? Boolean.valueOf("1".equals(value)) : Boolean.valueOf(value);
            result = (Serializable)clazz.cast(boolValue);
        } else {
            result = Byte.TYPE == clazz || Byte.class == clazz ? (Serializable)clazz.cast(value.isEmpty() ? Byte.valueOf((byte)0) : Byte.valueOf(value)) : (Short.TYPE == clazz || Short.class == clazz ? (Serializable)clazz.cast(value.isEmpty() ? Short.valueOf((short)0) : Short.valueOf(value)) : (Integer.TYPE == clazz || Integer.class == clazz ? (Serializable)clazz.cast(value.isEmpty() ? Integer.valueOf(0) : Integer.valueOf(value)) : (Long.TYPE == clazz || Long.class == clazz ? (Serializable)clazz.cast(value.isEmpty() ? Long.valueOf(0L) : Long.valueOf(value)) : (Float.TYPE == clazz || Float.class == clazz ? (Serializable)clazz.cast(value.isEmpty() ? Float.valueOf(0.0f) : Float.valueOf(value)) : (Double.TYPE == clazz || Double.class == clazz ? (Serializable)clazz.cast(value.isEmpty() ? Double.valueOf(0.0) : Double.valueOf(value)) : (Enum.class.isAssignableFrom(clazz) ? Enum.valueOf(clazz, value) : (Serializable)clazz.cast(value)))))));
        }
        return (T)result;
    }

    public Serializable getDefaultValue();

    default public Optional<String> getDefaultValueFromEnvVar() {
        String prefix = this.getPrefix().toUpperCase();
        String optionName = this.name();
        int length = optionName.length();
        String value = System.getenv(new StringBuilder(length + prefix.length() + 1).append(prefix).append('_').append(optionName.toUpperCase()).toString());
        if (value != null) {
            value = value.trim();
        }
        return Optional.ofNullable(value);
    }

    default public Optional<String> getDefaultValueFromSysProp() {
        String prefix = this.getPrefix().toLowerCase();
        String optionName = this.name();
        int length = optionName.length();
        String value = System.getProperty(new StringBuilder(length + prefix.length() + 1).append(prefix).append('_').append(optionName.toLowerCase()).toString());
        if (value != null) {
            value = value.trim();
        }
        return Optional.ofNullable(value);
    }

    public String getDescription();

    default public Serializable getEffectiveDefaultValue() {
        Optional<String> value = this.getDefaultValueFromEnvVar();
        if (!value.isPresent() || value.get().isEmpty()) {
            value = this.getDefaultValueFromSysProp();
        }
        if (!value.isPresent() || value.get().isEmpty()) {
            return this.getDefaultValue();
        }
        return ClickHouseOption.fromString(value.get(), this.getValueType());
    }

    default public <T> T getEffectiveValue(T value) {
        Object result = value == null ? this.getEffectiveDefaultValue() : value;
        return result;
    }

    public String getKey();

    default public String getPrefix() {
        return "CHC";
    }

    public Class<? extends Serializable> getValueType();

    public String name();
}

