/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseParameterizedQuery;
import com.clickhouse.client.ClickHouseRequestManager;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseTransaction;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.config.ClickHouseConfigChangeListener;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseCompression;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseDeferredValue;
import com.clickhouse.data.ClickHouseExternalTable;
import com.clickhouse.data.ClickHouseFile;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHousePassThruStream;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.ClickHouseValues;
import com.clickhouse.data.ClickHouseWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class ClickHouseRequest<SelfT extends ClickHouseRequest<SelfT>>
implements Serializable {
    private static final Set<String> SPECIAL_SETTINGS;
    static final String PARAM_SETTING = "setting";
    private static final long serialVersionUID = 4990313525960702287L;
    static final String PROP_DATA = "data";
    static final String PROP_MANAGER = "manager";
    static final String PROP_OUTPUT = "output";
    static final String PROP_PREPARED_QUERY = "preparedQuery";
    static final String PROP_QUERY = "query";
    static final String PROP_QUERY_ID = "queryId";
    static final String PROP_TRANSACTION = "transaction";
    static final String PROP_WRITER = "writer";
    private final boolean sealed;
    private final ClickHouseClient client;
    protected final AtomicReference<ClickHouseRequestManager> managerRef;
    protected final Function<ClickHouseNodeSelector, ClickHouseNode> server;
    protected final AtomicReference<ClickHouseNode> serverRef;
    protected final AtomicReference<ClickHouseTransaction> txRef;
    protected final List<ClickHouseExternalTable> externalTables;
    protected final Map<ClickHouseOption, Serializable> options;
    protected final Map<String, Serializable> settings;
    protected final Map<String, String> namedParameters;
    protected transient ClickHouseWriter writer;
    protected transient ClickHouseDeferredValue<ClickHouseInputStream> input;
    protected transient ClickHouseDeferredValue<ClickHouseOutputStream> output;
    protected String queryId;
    protected String sql;
    protected ClickHouseParameterizedQuery preparedQuery;
    protected transient ClickHouseConfigChangeListener<ClickHouseRequest<?>> changeListener;
    protected transient BiConsumer<ClickHouseNode, ClickHouseNode> serverListener;
    protected transient ClickHouseConfig config;
    protected transient List<String> statements;

    protected ClickHouseRequest(ClickHouseClient client, Function<ClickHouseNodeSelector, ClickHouseNode> server, AtomicReference<ClickHouseNode> ref, Map<ClickHouseOption, Serializable> options, boolean sealed) {
        if (client == null || server == null) {
            throw new IllegalArgumentException("Non-null client and server are required");
        }
        this.client = client;
        this.managerRef = new AtomicReference<Object>(null);
        this.server = (Function)((Object)((Serializable)((Object)server)));
        this.serverRef = ref == null ? new AtomicReference<Object>(null) : ref;
        this.txRef = new AtomicReference<Object>(null);
        this.externalTables = new LinkedList<ClickHouseExternalTable>();
        this.options = new HashMap<ClickHouseOption, Serializable>();
        this.settings = new LinkedHashMap<String, String>(client.getConfig().getCustomSettings());
        this.options(options);
        this.namedParameters = new HashMap<String, String>();
        this.sealed = sealed;
    }

    protected <T> T changeProperty(String property, T oldValue, T newValue) {
        if (this.changeListener != null && !Objects.equals(oldValue, newValue)) {
            this.changeListener.propertyChanged((Object)this, property, oldValue, newValue);
        }
        return newValue;
    }

    protected ClickHouseNode changeServer(ClickHouseNode currentServer, ClickHouseNode newServer) {
        if (!this.serverRef.compareAndSet(currentServer, newServer)) {
            newServer = this.getServer();
        } else if (this.serverListener != null) {
            this.serverListener.accept(currentServer, newServer);
        }
        return newServer;
    }

    protected void checkSealed() {
        if (this.sealed) {
            throw new IllegalStateException("Sealed request is immutable");
        }
    }

    protected ClickHouseClient getClient() {
        return this.client != null ? this.client : ClickHouseClient.newInstance(this.getServer().getProtocol());
    }

    protected String getQuery() {
        return this.sql;
    }

    protected void resetCache() {
        if (this.config != null) {
            this.config = null;
        }
        if (this.statements != null) {
            this.statements = null;
        }
    }

    public ClickHouseRequest<SelfT> copy() {
        ClickHouseRequest<SelfT> req = new ClickHouseRequest<SelfT>(this.getClient(), this.server, this.serverRef, this.options, false);
        req.externalTables.addAll(this.externalTables);
        req.settings.putAll(this.settings);
        req.namedParameters.putAll(this.namedParameters);
        req.input = this.input;
        req.writer = this.writer;
        req.output = this.output;
        req.queryId = this.queryId;
        req.sql = this.sql;
        req.preparedQuery = this.preparedQuery;
        req.managerRef.set(this.managerRef.get());
        req.txRef.set(this.txRef.get());
        req.changeListener = this.changeListener;
        req.serverListener = this.serverListener;
        return req;
    }

    public ClickHouseRequestManager getManager() {
        ClickHouseRequestManager m = this.managerRef.get();
        if (m == null && !this.managerRef.compareAndSet(null, m = ClickHouseRequestManager.getInstance())) {
            m = this.managerRef.get();
        }
        return m;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public boolean isTransactional() {
        return this.txRef.get() != null;
    }

    public boolean hasInputStream() {
        return this.input != null || this.writer != null || !this.externalTables.isEmpty();
    }

    public boolean hasOutputStream() {
        return this.output != null;
    }

    public final ClickHouseNode getServer() {
        ClickHouseNode node = this.serverRef.get();
        if (node == null && !this.serverRef.compareAndSet(null, node = this.server.apply(this.getConfig().getNodeSelector()))) {
            node = this.serverRef.get();
        }
        return node;
    }

    public ClickHouseConfig getConfig() {
        if (this.config == null) {
            ClickHouseConfig clientConfig = this.getClient().getConfig();
            if (this.options.isEmpty()) {
                this.config = clientConfig;
            } else {
                HashMap<ClickHouseOption, Serializable> merged = new HashMap<ClickHouseOption, Serializable>();
                merged.putAll(clientConfig.getAllOptions());
                merged.putAll(this.options);
                this.config = new ClickHouseConfig(merged, clientConfig.getDefaultCredentials(), clientConfig.getNodeSelector(), clientConfig.getMetricRegistry().orElse(null));
            }
        }
        return this.config;
    }

    public ClickHouseTransaction getTransaction() {
        return this.txRef.get();
    }

    public final ClickHouseConfigChangeListener<ClickHouseRequest<?>> getChangeListener() {
        return this.changeListener;
    }

    public final BiConsumer<ClickHouseNode, ClickHouseNode> getServerListener() {
        return this.serverListener;
    }

    public Optional<ClickHouseInputStream> getInputStream() {
        if (this.input == null && this.writer != null) {
            ClickHouseConfig c = this.getConfig();
            ClickHouseWriter w = this.writer;
            this.input = this.changeProperty(PROP_DATA, this.input, ClickHouseDeferredValue.of(() -> ClickHouseInputStream.of((ClickHouseDataConfig)c, (ClickHouseWriter)w)));
        }
        return this.input != null ? this.input.getOptional() : Optional.empty();
    }

    public Optional<ClickHouseWriter> getWriter() {
        if (this.writer == null && this.input != null) {
            this.writer = this.changeProperty(PROP_WRITER, this.writer, new PipedWriter(this.input));
        }
        return Optional.ofNullable(this.writer);
    }

    public Optional<ClickHouseOutputStream> getOutputStream() {
        return this.output != null ? this.output.getOptional() : Optional.empty();
    }

    public List<ClickHouseExternalTable> getExternalTables() {
        return Collections.unmodifiableList(this.externalTables);
    }

    public ClickHouseFormat getFormat() {
        return this.getConfig().getFormat();
    }

    public Optional<String> getQueryId() {
        return ClickHouseChecker.isNullOrEmpty((CharSequence)this.queryId) ? Optional.empty() : Optional.of(this.queryId);
    }

    public ClickHouseParameterizedQuery getPreparedQuery() {
        if (this.preparedQuery == null) {
            this.preparedQuery = this.changeProperty(PROP_PREPARED_QUERY, this.preparedQuery, ClickHouseParameterizedQuery.of(this.getConfig(), this.getQuery()));
        }
        return this.preparedQuery;
    }

    public <T extends Serializable> T getSetting(String setting, Class<T> valueType) {
        Serializable value = this.settings.get(ClickHouseChecker.nonBlank((String)setting, (String)PARAM_SETTING));
        return (T)ClickHouseOption.fromString((String)(value == null ? "" : value.toString()), valueType);
    }

    public <T extends Serializable> T getSetting(String setting, T defaultValue) {
        Serializable value = this.settings.get(ClickHouseChecker.nonBlank((String)setting, (String)PARAM_SETTING));
        ClickHouseChecker.nonNull(defaultValue, (String)"defaultValue");
        if (value == null) {
            return defaultValue;
        }
        return (T)ClickHouseOption.fromString((String)value.toString(), defaultValue.getClass());
    }

    public boolean hasSetting(String setting) {
        return this.settings.containsKey(setting);
    }

    public Map<String, Serializable> getSettings() {
        return Collections.unmodifiableMap(this.settings);
    }

    public Optional<String> getSessionId() {
        String sessionId = this.getConfig().getStrOption(ClickHouseClientOption.SESSION_ID);
        return ClickHouseChecker.isNullOrEmpty((CharSequence)sessionId) ? Optional.empty() : Optional.of(sessionId);
    }

    public List<String> getStatements() {
        return this.getStatements(true);
    }

    public List<String> getStatements(boolean withSettings) {
        if (this.statements == null) {
            String stmt;
            this.statements = new ArrayList<String>();
            if (withSettings) {
                for (Map.Entry<String, Serializable> entry : this.settings.entrySet()) {
                    Serializable value = entry.getValue();
                    StringBuilder sb = new StringBuilder().append("SET ").append(entry.getKey()).append('=');
                    if (value instanceof String) {
                        sb.append('\'').append(value).append('\'');
                    } else if (value instanceof Boolean) {
                        sb.append((Boolean)value != false ? 1 : 0);
                    } else {
                        sb.append(value);
                    }
                    this.statements.add(sb.toString());
                }
            }
            if (!ClickHouseChecker.isNullOrEmpty((CharSequence)(stmt = this.getQuery()))) {
                StringBuilder builder = new StringBuilder();
                if (this.preparedQuery == null) {
                    ClickHouseParameterizedQuery.apply(builder, stmt, this.namedParameters);
                } else {
                    this.preparedQuery.apply(builder, this.namedParameters);
                }
                this.statements.add(builder.toString());
            }
        }
        return Collections.unmodifiableList(this.statements);
    }

    public SelfT compressServerResponse(boolean enable) {
        return this.compressServerResponse(enable, null, (Integer)ClickHouseClientOption.COMPRESS_LEVEL.getEffectiveDefaultValue());
    }

    public SelfT compressServerResponse(ClickHouseCompression compressAlgorithm) {
        return this.compressServerResponse(compressAlgorithm != null && compressAlgorithm != ClickHouseCompression.NONE, compressAlgorithm, (Integer)ClickHouseClientOption.COMPRESS_LEVEL.getEffectiveDefaultValue());
    }

    public SelfT compressServerResponse(boolean enable, ClickHouseCompression compressAlgorithm) {
        return this.compressServerResponse(enable, compressAlgorithm, (Integer)ClickHouseClientOption.COMPRESS_LEVEL.getEffectiveDefaultValue());
    }

    public SelfT compressServerResponse(boolean enable, ClickHouseCompression compressAlgorithm, int compressLevel) {
        this.checkSealed();
        if (compressAlgorithm == null) {
            compressAlgorithm = enable ? (ClickHouseCompression)ClickHouseClientOption.COMPRESS_ALGORITHM.getEffectiveDefaultValue() : ClickHouseCompression.NONE;
        }
        return ((ClickHouseRequest)((ClickHouseRequest)this.option(ClickHouseClientOption.COMPRESS, Boolean.valueOf(enable))).option(ClickHouseClientOption.COMPRESS_ALGORITHM, (Serializable)compressAlgorithm)).option(ClickHouseClientOption.COMPRESS_LEVEL, Integer.valueOf(compressLevel));
    }

    public SelfT decompressClientRequest(boolean enable) {
        return this.decompressClientRequest(enable, null, (Integer)ClickHouseClientOption.DECOMPRESS_LEVEL.getEffectiveDefaultValue());
    }

    public SelfT decompressClientRequest(ClickHouseCompression compressAlgorithm) {
        return this.decompressClientRequest(compressAlgorithm != null && compressAlgorithm != ClickHouseCompression.NONE, compressAlgorithm, (Integer)ClickHouseClientOption.DECOMPRESS_LEVEL.getEffectiveDefaultValue());
    }

    public SelfT decompressClientRequest(boolean enable, ClickHouseCompression compressAlgorithm) {
        return this.decompressClientRequest(enable, compressAlgorithm, (Integer)ClickHouseClientOption.DECOMPRESS_LEVEL.getEffectiveDefaultValue());
    }

    public SelfT decompressClientRequest(boolean enable, ClickHouseCompression compressAlgorithm, int compressLevel) {
        this.checkSealed();
        if (compressAlgorithm == null) {
            compressAlgorithm = enable ? (ClickHouseCompression)ClickHouseClientOption.DECOMPRESS_ALGORITHM.getEffectiveDefaultValue() : ClickHouseCompression.NONE;
        }
        return ((ClickHouseRequest)((ClickHouseRequest)this.option(ClickHouseClientOption.DECOMPRESS, Boolean.valueOf(enable))).option(ClickHouseClientOption.DECOMPRESS_ALGORITHM, (Serializable)compressAlgorithm)).option(ClickHouseClientOption.DECOMPRESS_LEVEL, Integer.valueOf(compressLevel));
    }

    public SelfT addExternal(ClickHouseExternalTable table) {
        this.checkSealed();
        if (this.externalTables.add((ClickHouseExternalTable)ClickHouseChecker.nonNull((Object)table, (String)"ExternalTable"))) {
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT external(ClickHouseExternalTable table, ClickHouseExternalTable ... more) {
        this.checkSealed();
        this.externalTables.clear();
        this.externalTables.add((ClickHouseExternalTable)ClickHouseChecker.nonNull((Object)table, (String)"ExternalTable"));
        if (more != null) {
            for (ClickHouseExternalTable e : more) {
                this.externalTables.add((ClickHouseExternalTable)ClickHouseChecker.nonNull((Object)e, (String)"ExternalTable"));
            }
        }
        return (SelfT)this;
    }

    public SelfT external(Collection<ClickHouseExternalTable> tables) {
        this.checkSealed();
        this.externalTables.clear();
        if (tables != null) {
            for (ClickHouseExternalTable e : tables) {
                this.externalTables.add((ClickHouseExternalTable)ClickHouseChecker.nonNull((Object)e, (String)"ExternalTable"));
            }
        }
        return (SelfT)this;
    }

    public SelfT format(ClickHouseFormat format) {
        this.checkSealed();
        return this.option(ClickHouseClientOption.FORMAT, (Serializable)format);
    }

    public SelfT manager(ClickHouseRequestManager manager) {
        this.checkSealed();
        ClickHouseRequestManager current = this.managerRef.get();
        if (!Objects.equals(current, manager) && this.managerRef.compareAndSet(current, manager)) {
            this.changeProperty(PROP_MANAGER, current, manager);
        }
        return (SelfT)this;
    }

    public SelfT option(ClickHouseOption option, Serializable value) {
        Serializable oldValue;
        this.checkSealed();
        if (value == null) {
            return this.removeOption(option);
        }
        if (option != null && option.getValueType() != value.getClass()) {
            value = ClickHouseOption.fromString((String)value.toString(), (Class)option.getValueType());
        }
        if ((oldValue = this.options.put((ClickHouseOption)ClickHouseChecker.nonNull((Object)option, (String)"option"), value)) == null || !oldValue.equals(value)) {
            if (this.changeListener != null) {
                this.changeListener.optionChanged((Object)this, option, oldValue, value);
            }
            if (option == ClickHouseClientOption.CUSTOM_SETTINGS) {
                for (Map.Entry entry : ClickHouseOption.toKeyValuePairs((String)value.toString()).entrySet()) {
                    this.set((String)entry.getKey(), (String)entry.getValue());
                }
            }
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT options(Map<ClickHouseOption, Serializable> options) {
        this.checkSealed();
        if (this.changeListener == null) {
            this.options.clear();
            if (options != null) {
                for (Map.Entry<ClickHouseOption, Serializable> e : options.entrySet()) {
                    this.option(e.getKey(), e.getValue());
                }
            }
            this.resetCache();
        } else {
            HashMap<ClickHouseOption, Serializable> m = new HashMap<ClickHouseOption, Serializable>();
            m.putAll(this.options);
            if (options != null) {
                for (Map.Entry<Object, Serializable> entry : options.entrySet()) {
                    this.option((ClickHouseOption)entry.getKey(), entry.getValue());
                    m.remove(entry.getKey());
                }
            }
            for (ClickHouseOption clickHouseOption : m.keySet()) {
                this.removeOption(clickHouseOption);
            }
        }
        return (SelfT)this;
    }

    public SelfT options(Properties options) {
        this.checkSealed();
        HashMap<ClickHouseOption, Serializable> m = new HashMap<ClickHouseOption, Serializable>();
        m.putAll(this.options);
        if (options != null) {
            for (Map.Entry<Object, Object> e : options.entrySet()) {
                ClickHouseClientOption o;
                Object key = e.getKey();
                Object value = e.getValue();
                if (key == null || value == null || (o = ClickHouseClientOption.fromKey(key.toString())) == null) continue;
                this.option(o, ClickHouseOption.fromString((String)value.toString(), o.getValueType()));
                m.remove((Object)o);
            }
        }
        for (ClickHouseOption o : m.keySet()) {
            this.removeOption(o);
        }
        return (SelfT)this;
    }

    public boolean hasOption(ClickHouseOption option) {
        return this.options.containsKey(option);
    }

    public boolean hasOption(String key) {
        return this.options.containsKey((Object)ClickHouseClientOption.fromKey(key));
    }

    public SelfT output(ClickHousePassThruStream stream) {
        this.checkSealed();
        if (!((ClickHousePassThruStream)ClickHouseChecker.nonNull((Object)stream, (String)"Pass-thru Stream")).hasOutput()) {
            throw new IllegalArgumentException("Pass-thru stream does not have output");
        }
        ClickHouseConfig c = this.getConfig();
        if (stream.hasCompression()) {
            this.compressServerResponse(stream.isCompressed(), stream.getCompressionAlgorithm(), stream.getCompressionLevel());
        } else if (c.isResponseCompressed()) {
            this.compressServerResponse(false);
        }
        if (stream.hasFormat()) {
            this.format(stream.getFormat());
        }
        int bufferSize = c.getWriteBufferSize();
        this.output = this.changeProperty(PROP_OUTPUT, this.output, ClickHouseDeferredValue.of(() -> ClickHouseOutputStream.of((ClickHousePassThruStream)stream, (int)bufferSize, null)));
        return (SelfT)this;
    }

    public SelfT output(String file) {
        return this.output((ClickHousePassThruStream)ClickHouseFile.of((String)file));
    }

    public SelfT output(String file, ClickHouseCompression compression) {
        return this.output((ClickHousePassThruStream)ClickHouseFile.of((String)file, (ClickHouseCompression)compression, (int)((Integer)ClickHouseClientOption.COMPRESS_LEVEL.getDefaultValue()), null));
    }

    public SelfT output(String file, ClickHouseCompression compression, int compressionLevel) {
        return this.output((ClickHousePassThruStream)ClickHouseFile.of((String)file, (ClickHouseCompression)compression, (int)compressionLevel, null));
    }

    public SelfT output(OutputStream output) {
        return this.output(ClickHouseOutputStream.of((OutputStream)output));
    }

    public SelfT output(ClickHouseOutputStream output) {
        ClickHousePassThruStream stream = ((ClickHouseOutputStream)ClickHouseChecker.nonNull((Object)output, (String)"OutputStream")).getUnderlyingStream();
        if (stream.hasOutput()) {
            return this.output(stream);
        }
        this.checkSealed();
        this.output = this.changeProperty(PROP_OUTPUT, this.output, ClickHouseDeferredValue.of((Object)output, ClickHouseOutputStream.class));
        return (SelfT)this;
    }

    public SelfT output(ClickHouseDeferredValue<ClickHouseOutputStream> output) {
        this.checkSealed();
        this.output = this.changeProperty(PROP_OUTPUT, this.output, output);
        return (SelfT)this;
    }

    public SelfT params(Collection<String> values) {
        this.checkSealed();
        this.namedParameters.clear();
        if (values != null && !values.isEmpty()) {
            List<String> names = this.getPreparedQuery().getParameters();
            int size = names.size();
            int index = 0;
            for (String v : values) {
                this.namedParameters.put(names.get(index), v);
                if (++index < size) continue;
                break;
            }
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT params(ClickHouseValue value, ClickHouseValue ... more) {
        this.checkSealed();
        this.namedParameters.clear();
        if (value != null) {
            List<String> names = this.getPreparedQuery().getParameters();
            int size = names.size();
            int index = 0;
            this.namedParameters.put(names.get(index++), value.toSqlExpression());
            if (more != null && more.length > 0) {
                for (ClickHouseValue v : more) {
                    if (index >= size) break;
                    this.namedParameters.put(names.get(index++), v != null ? v.toSqlExpression() : "NULL");
                }
            }
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT params(ClickHouseValue[] values) {
        this.checkSealed();
        this.namedParameters.clear();
        if (values != null && values.length > 0) {
            List<String> names = this.getPreparedQuery().getParameters();
            int size = names.size();
            int index = 0;
            for (ClickHouseValue v : values) {
                this.namedParameters.put(names.get(index), v != null ? v.toSqlExpression() : "NULL");
                if (++index >= size) break;
            }
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT params(String value, String ... more) {
        this.checkSealed();
        this.namedParameters.clear();
        List<String> names = this.getPreparedQuery().getParameters();
        int size = names.size();
        if (size > 0) {
            int index = 0;
            this.namedParameters.put(names.get(index++), value);
            if (more != null && more.length > 0) {
                for (String v : more) {
                    if (index >= size) break;
                    this.namedParameters.put(names.get(index++), v);
                }
            }
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT params(String[] values) {
        this.checkSealed();
        this.namedParameters.clear();
        if (values != null && values.length > 0) {
            List<String> names = this.getPreparedQuery().getParameters();
            int size = names.size();
            int index = 0;
            for (String v : values) {
                this.namedParameters.put(names.get(index), v);
                if (++index >= size) break;
            }
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT params(Object value, Object ... more) {
        this.checkSealed();
        this.namedParameters.clear();
        List<String> names = this.getPreparedQuery().getParameters();
        int size = names.size();
        int index = 0;
        this.namedParameters.put(names.get(index++), ClickHouseValues.convertToSqlExpression((Object)value));
        if (more != null && more.length > 0) {
            for (Object v : more) {
                if (index >= size) break;
                this.namedParameters.put(names.get(index++), ClickHouseValues.convertToSqlExpression((Object)v));
            }
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT params(Object[] values) {
        this.checkSealed();
        this.namedParameters.clear();
        if (values != null && values.length > 0) {
            List<String> names = this.getPreparedQuery().getParameters();
            int size = names.size();
            int index = 0;
            for (Object v : values) {
                this.namedParameters.put(names.get(index), ClickHouseValues.convertToSqlExpression((Object)v));
                if (++index >= size) break;
            }
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT params(Map<String, String> namedParams) {
        this.checkSealed();
        this.namedParameters.clear();
        if (namedParams != null) {
            this.namedParameters.putAll(namedParams);
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT query(ClickHouseParameterizedQuery query) {
        return this.query(query, null);
    }

    public SelfT query(String sql) {
        return this.query(sql, null);
    }

    public SelfT query(ClickHouseParameterizedQuery query, String queryId) {
        this.checkSealed();
        if (!((ClickHouseParameterizedQuery)ClickHouseChecker.nonNull((Object)query, (String)PROP_QUERY)).equals(this.preparedQuery)) {
            this.preparedQuery = this.changeProperty(PROP_PREPARED_QUERY, this.preparedQuery, query);
            this.sql = this.changeProperty(PROP_QUERY, this.sql, query.getOriginalQuery());
            this.resetCache();
        }
        this.queryId = this.changeProperty(PROP_QUERY_ID, this.queryId, queryId);
        return (SelfT)this;
    }

    public SelfT query(String query, String queryId) {
        this.checkSealed();
        if (!ClickHouseChecker.nonBlank((String)query, (String)PROP_QUERY).equals(this.sql)) {
            this.sql = this.changeProperty(PROP_QUERY, this.sql, query);
            this.preparedQuery = this.changeProperty(PROP_PREPARED_QUERY, this.preparedQuery, null);
            this.resetCache();
        }
        this.queryId = this.changeProperty(PROP_QUERY_ID, this.queryId, queryId);
        return (SelfT)this;
    }

    public SelfT settings(Map<String, Serializable> settings) {
        this.checkSealed();
        if (this.changeListener == null) {
            this.settings.clear();
            if (settings != null) {
                for (Map.Entry<String, Serializable> e : settings.entrySet()) {
                    this.set(e.getKey(), e.getValue());
                }
            }
            this.resetCache();
        } else {
            HashMap<String, Serializable> m = new HashMap<String, Serializable>();
            m.putAll(this.settings);
            if (settings != null) {
                for (Map.Entry<String, Serializable> e : settings.entrySet()) {
                    this.set(e.getKey(), e.getValue());
                    m.remove(e.getKey());
                }
            }
            for (String s : m.keySet()) {
                this.removeSetting(s);
            }
        }
        return (SelfT)this;
    }

    public SelfT clearSettings() {
        this.checkSealed();
        if (!this.settings.isEmpty()) {
            if (this.changeListener == null) {
                this.settings.clear();
                this.resetCache();
            } else {
                Iterator<String> it = this.settings.keySet().iterator();
                while (it.hasNext()) {
                    this.removeSetting(it.next());
                }
            }
        }
        return (SelfT)this;
    }

    public SelfT clearSession() {
        this.checkSealed();
        this.removeOption(ClickHouseClientOption.SESSION_ID);
        this.removeOption(ClickHouseClientOption.SESSION_CHECK);
        this.removeOption(ClickHouseClientOption.SESSION_TIMEOUT);
        ClickHouseTransaction tx = this.txRef.get();
        if (tx != null && this.txRef.compareAndSet(tx, null)) {
            this.changeProperty(PROP_TRANSACTION, tx, null);
        }
        return (SelfT)this;
    }

    public SelfT session(String sessionId) {
        return this.session(sessionId, null, null);
    }

    public SelfT session(String sessionId, Boolean check) {
        return this.session(sessionId, check, null);
    }

    public SelfT session(String sessionId, Integer timeout) {
        return this.session(sessionId, null, timeout);
    }

    public SelfT session(String sessionId, Boolean check, Integer timeout) {
        this.checkSealed();
        ClickHouseTransaction tx = this.txRef.get();
        if (tx != null) {
            throw new IllegalArgumentException(ClickHouseUtils.format((String)"Please complete %s (or clear session) before changing session to (id=%s, check=%s, timeout=%s)", (Object[])new Object[]{tx, sessionId, check, timeout}));
        }
        this.option(ClickHouseClientOption.SESSION_ID, (Serializable)((Object)sessionId));
        this.option(ClickHouseClientOption.SESSION_CHECK, check);
        this.option(ClickHouseClientOption.SESSION_TIMEOUT, timeout);
        return (SelfT)this;
    }

    public SelfT set(String setting, Serializable value) {
        this.checkSealed();
        if (SPECIAL_SETTINGS.contains(ClickHouseChecker.nonBlank((String)setting, (String)PARAM_SETTING))) {
            return this.option(ClickHouseClientOption.fromKey(setting), value);
        }
        if (value == null) {
            return this.removeSetting(setting);
        }
        Serializable oldValue = this.settings.put(setting, value);
        if (oldValue == null || !oldValue.equals(value)) {
            if (this.changeListener != null) {
                this.changeListener.settingChanged((Object)this, setting, oldValue, value);
            }
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT set(String setting, String value) {
        this.checkSealed();
        return this.set(setting, (Serializable)((Object)ClickHouseUtils.escape((String)value, (char)'\'')));
    }

    public final SelfT setChangeListener(ClickHouseConfigChangeListener<ClickHouseRequest<?>> listener) {
        this.changeListener = listener;
        return (SelfT)this;
    }

    public final SelfT setServerListener(BiConsumer<ClickHouseNode, ClickHouseNode> listener) {
        this.serverListener = listener;
        return (SelfT)this;
    }

    public SelfT table(String table) {
        return this.table(table, null);
    }

    public SelfT table(String table, String queryId) {
        return this.query("SELECT * FROM ".concat(ClickHouseChecker.nonBlank((String)table, (String)"table")), queryId);
    }

    public SelfT transaction() throws ClickHouseException {
        return this.transaction(0);
    }

    public SelfT transaction(int timeout) throws ClickHouseException {
        ClickHouseTransaction tx = this.txRef.get();
        if (tx != null && tx.getTimeout() == (timeout > 0 ? timeout : 0)) {
            return (SelfT)this;
        }
        return this.transaction(this.getManager().getOrStartTransaction(this, timeout));
    }

    public SelfT transaction(ClickHouseTransaction transaction) throws ClickHouseException {
        this.checkSealed();
        try {
            this.txRef.updateAndGet(x -> {
                if (this.changeProperty(PROP_TRANSACTION, x, transaction) != null) {
                    ClickHouseNode txServer;
                    ClickHouseNode currentServer = this.getServer();
                    if (!currentServer.isSameEndpoint(txServer = transaction.getServer()) && this.changeServer(currentServer, txServer) != txServer) {
                        throw new IllegalStateException(ClickHouseUtils.format((String)"Failed to change current server from %s to %s", (Object[])new Object[]{currentServer, txServer}));
                    }
                    this.option(ClickHouseClientOption.SESSION_ID, (Serializable)((Object)transaction.getSessionId()));
                    this.option(ClickHouseClientOption.SESSION_CHECK, Boolean.valueOf(true));
                    this.option(ClickHouseClientOption.SESSION_TIMEOUT, transaction.getTimeout() < 1 ? null : Integer.valueOf(transaction.getTimeout()));
                    this.removeSetting("implicit_transaction");
                } else if (x != null) {
                    this.clearSession();
                }
                return transaction;
            });
        }
        catch (IllegalStateException e) {
            throw ClickHouseException.of(e.getMessage(), this.getServer());
        }
        return (SelfT)this;
    }

    public SelfT use(String database) {
        this.checkSealed();
        this.option(ClickHouseClientOption.DATABASE, (Serializable)((Object)database));
        return (SelfT)this;
    }

    public SelfT removeExternal(ClickHouseExternalTable external) {
        this.checkSealed();
        if (this.externalTables.remove(ClickHouseChecker.nonNull((Object)external, (String)"ExternalTable"))) {
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT removeExternal(String name) {
        this.checkSealed();
        if (!ClickHouseChecker.isNullOrEmpty((CharSequence)name)) {
            boolean removed = false;
            Iterator<ClickHouseExternalTable> i = this.externalTables.iterator();
            while (i.hasNext()) {
                ClickHouseExternalTable e = i.next();
                if (!name.equals(e.getName())) continue;
                i.remove();
                removed = true;
            }
            if (removed) {
                this.resetCache();
            }
        }
        return (SelfT)this;
    }

    public SelfT removeOption(ClickHouseOption option) {
        this.checkSealed();
        Serializable oldValue = this.options.remove(ClickHouseChecker.nonNull((Object)option, (String)"option"));
        if (oldValue != null) {
            if (this.changeListener != null) {
                this.changeListener.optionChanged((Object)this, option, oldValue, null);
            }
            if (option == ClickHouseClientOption.CUSTOM_SETTINGS) {
                for (String key : ClickHouseOption.toKeyValuePairs((String)oldValue.toString()).keySet()) {
                    this.removeSetting(key);
                    if (!SPECIAL_SETTINGS.contains(key)) continue;
                    this.removeOption(ClickHouseClientOption.fromKey(key));
                }
            }
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT removeSetting(String setting) {
        this.checkSealed();
        Serializable oldValue = this.settings.remove(ClickHouseChecker.nonBlank((String)setting, (String)PARAM_SETTING));
        if (oldValue != null) {
            if (this.changeListener != null) {
                this.changeListener.settingChanged((Object)this, setting, oldValue, null);
            }
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT reset() {
        ClickHouseTransaction tx;
        this.checkSealed();
        this.externalTables.clear();
        this.namedParameters.clear();
        this.serverListener = null;
        if (this.changeListener == null) {
            this.options.clear();
            this.settings.clear();
        } else {
            Iterator<Object> it = this.options.keySet().iterator();
            while (it.hasNext()) {
                this.removeOption(it.next());
            }
            it = this.settings.keySet().iterator();
            while (it.hasNext()) {
                this.removeSetting((String)it.next());
            }
        }
        this.input = this.changeProperty(PROP_DATA, this.input, null);
        this.writer = this.changeProperty(PROP_WRITER, this.writer, null);
        this.output = this.changeProperty(PROP_OUTPUT, this.output, null);
        this.sql = this.changeProperty(PROP_QUERY, this.sql, null);
        this.preparedQuery = this.changeProperty(PROP_PREPARED_QUERY, this.preparedQuery, null);
        this.queryId = this.changeProperty(PROP_QUERY_ID, this.queryId, null);
        ClickHouseRequestManager current = this.managerRef.get();
        if (current != null && this.managerRef.compareAndSet(current, null)) {
            this.changeProperty(PROP_MANAGER, current, null);
        }
        if ((tx = this.txRef.get()) != null && this.txRef.compareAndSet(tx, null)) {
            this.changeProperty(PROP_TRANSACTION, tx, null);
        }
        this.changeListener = null;
        this.resetCache();
        return (SelfT)this;
    }

    public ClickHouseRequest<SelfT> seal() {
        ClickHouseRequest<SelfT> req = this;
        if (!this.isSealed()) {
            req = new ClickHouseRequest<SelfT>(this.client, this.getServer(), this.serverRef, this.options, true);
            req.externalTables.addAll(this.externalTables);
            req.settings.putAll(this.settings);
            req.namedParameters.putAll(this.namedParameters);
            req.input = this.input;
            req.writer = this.writer;
            req.output = this.output;
            req.queryId = this.queryId;
            req.sql = this.sql;
            req.preparedQuery = this.preparedQuery;
            req.managerRef.set(this.managerRef.get());
            req.txRef.set(this.txRef.get());
        }
        return req;
    }

    public Mutation write() {
        this.checkSealed();
        return new Mutation(this, false);
    }

    public CompletableFuture<ClickHouseResponse> execute() {
        return this.getClient().execute(this);
    }

    public ClickHouseResponse executeAndWait() throws ClickHouseException {
        return this.getClient().executeAndWait(this);
    }

    public ClickHouseResponse executeWithinTransaction() throws ClickHouseException {
        return this.executeWithinTransaction(false);
    }

    @Deprecated
    public ClickHouseResponse executeWithinTransaction(boolean useImplicitTransaction) throws ClickHouseException {
        if (useImplicitTransaction) {
            return ((ClickHouseRequest)((ClickHouseRequest)this.set("implicit_transaction", Integer.valueOf(1))).transaction(null)).executeAndWait();
        }
        ClickHouseTransaction tx = null;
        try {
            tx = this.getManager().createImplicitTransaction(this);
            ClickHouseResponse clickHouseResponse = this.getClient().executeAndWait((ClickHouseRequest<?>)this.transaction(tx));
            return clickHouseResponse;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw ClickHouseException.of(e, this.getServer());
        }
        finally {
            this.transaction(null);
        }
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("query_id");
        set.add(ClickHouseClientOption.SESSION_ID.getKey());
        set.add(ClickHouseClientOption.SESSION_CHECK.getKey());
        set.add(ClickHouseClientOption.SESSION_TIMEOUT.getKey());
        SPECIAL_SETTINGS = Collections.unmodifiableSet(set);
    }

    static class PipedWriter
    implements ClickHouseWriter {
        private final ClickHouseDeferredValue<ClickHouseInputStream> input;

        PipedWriter(ClickHouseDeferredValue<ClickHouseInputStream> input) {
            this.input = input;
        }

        public void write(ClickHouseOutputStream output) throws IOException {
            ClickHouseInputStream in = (ClickHouseInputStream)this.input.get();
            if (in != null) {
                in.pipe(output);
            }
        }
    }

    public static class Mutation
    extends ClickHouseRequest<Mutation> {
        protected Mutation(ClickHouseRequest<?> request, boolean sealed) {
            super(request.getClient(), request.server, request.serverRef, request.options, sealed);
            if (!sealed) {
                this.format(request.getFormat().defaultInputFormat());
            }
            this.settings.putAll(request.settings);
            this.txRef.set(request.txRef.get());
            this.changeListener = request.changeListener;
            this.serverListener = request.serverListener;
        }

        @Override
        protected String getQuery() {
            if (this.input != null && this.sql != null) {
                char ch;
                int len;
                int tmp = 0;
                int index = len = this.sql.length();
                while ((tmp = ClickHouseUtils.skipContentsUntil((String)this.sql, (int)tmp, (int)this.sql.length(), (String)"format", (boolean)false)) < len) {
                    index = tmp;
                }
                StringBuilder builder = new StringBuilder();
                boolean spaces = false;
                while (index < len && !ClickHouseUtils.isQuote((char)(ch = this.sql.charAt(index))) && !ClickHouseUtils.isOpenBracket((char)ch)) {
                    if (Character.isWhitespace(ch)) {
                        if (builder.length() > 0) {
                            spaces = true;
                        }
                    } else if (index + 1 < len) {
                        char nextCh = this.sql.charAt(index + 1);
                        if (ch == '-' && nextCh == '-') {
                            index = ClickHouseUtils.skipSingleLineComment((String)this.sql, (int)(index + 2), (int)len) - 1;
                        } else if (ch == '/' && nextCh == '*') {
                            index = ClickHouseUtils.skipMultiLineComment((String)this.sql, (int)(index + 2), (int)len) - 1;
                        } else if (ch == '\\') {
                            ++index;
                        } else {
                            if (spaces) break;
                            builder.append(ch);
                        }
                    } else {
                        if (spaces) break;
                        builder.append(ch);
                    }
                    ++index;
                }
                return builder.length() > 0 && index == len ? this.sql : this.sql + "\n FORMAT " + this.getFormat().name();
            }
            return super.getQuery();
        }

        @Override
        public Mutation format(ClickHouseFormat format) {
            if (!((ClickHouseFormat)ClickHouseChecker.nonNull((Object)format, (String)"format")).supportsInput()) {
                throw new IllegalArgumentException("Only input format is allowed for mutation.");
            }
            return (Mutation)super.format(format);
        }

        public Mutation data(ClickHouseWriter writer) {
            this.checkSealed();
            this.input = this.changeProperty(ClickHouseRequest.PROP_DATA, this.input, null);
            this.writer = this.changeProperty(ClickHouseRequest.PROP_WRITER, this.writer, writer);
            return this;
        }

        public Mutation data(ClickHousePassThruStream stream) {
            this.checkSealed();
            if (!((ClickHousePassThruStream)ClickHouseChecker.nonNull((Object)stream, (String)"Pass-thru Stream")).hasInput()) {
                throw new IllegalArgumentException("Pass-thru stream does not have input");
            }
            ClickHouseConfig c = this.getConfig();
            if (stream.hasCompression()) {
                this.decompressClientRequest(stream.isCompressed(), stream.getCompressionAlgorithm(), stream.getCompressionLevel());
            } else if (c.isRequestCompressed()) {
                this.decompressClientRequest(false);
            }
            if (stream.hasFormat()) {
                this.format(stream.getFormat());
            }
            int bufferSize = c.getReadBufferSize();
            this.input = this.changeProperty(ClickHouseRequest.PROP_DATA, this.input, ClickHouseDeferredValue.of(() -> ClickHouseInputStream.of((ClickHousePassThruStream)stream, (int)bufferSize, null)));
            this.writer = this.changeProperty(ClickHouseRequest.PROP_WRITER, this.writer, null);
            return this;
        }

        public Mutation data(String file) {
            return this.data((ClickHousePassThruStream)ClickHouseFile.of((String)file));
        }

        public Mutation data(String file, ClickHouseCompression compression) {
            return this.data((ClickHousePassThruStream)ClickHouseFile.of((String)file, (ClickHouseCompression)compression, (int)((Integer)ClickHouseClientOption.DECOMPRESS_LEVEL.getDefaultValue()), null));
        }

        public Mutation data(String file, ClickHouseCompression compression, int compressionLevel) {
            return this.data((ClickHousePassThruStream)ClickHouseFile.of((String)file, (ClickHouseCompression)compression, (int)compressionLevel, null));
        }

        public Mutation data(InputStream input) {
            return this.data(ClickHouseInputStream.of((InputStream)input));
        }

        public Mutation data(ClickHouseInputStream input) {
            ClickHousePassThruStream stream = ((ClickHouseInputStream)ClickHouseChecker.nonNull((Object)input, (String)"InputStream")).getUnderlyingStream();
            if (stream.hasInput()) {
                return this.data(stream);
            }
            this.checkSealed();
            this.input = this.changeProperty(ClickHouseRequest.PROP_DATA, this.input, ClickHouseDeferredValue.of((Object)input, ClickHouseInputStream.class));
            this.writer = this.changeProperty(ClickHouseRequest.PROP_WRITER, this.writer, null);
            return this;
        }

        public Mutation data(ClickHouseDeferredValue<ClickHouseInputStream> input) {
            this.checkSealed();
            this.input = this.changeProperty(ClickHouseRequest.PROP_DATA, this.input, input);
            this.writer = this.changeProperty(ClickHouseRequest.PROP_WRITER, this.writer, null);
            return this;
        }

        @Override
        public Mutation table(String table, String queryId) {
            this.checkSealed();
            return (Mutation)super.query("INSERT INTO " + ClickHouseChecker.nonBlank((String)table, (String)"table"), queryId);
        }

        public Mutation seal() {
            Mutation req = this;
            if (!this.isSealed()) {
                req = new Mutation(this, true);
                req.externalTables.addAll(this.externalTables);
                req.options.putAll(this.options);
                req.settings.putAll(this.settings);
                req.namedParameters.putAll(this.namedParameters);
                req.input = this.input;
                req.writer = this.writer;
                req.queryId = this.queryId;
                req.sql = this.sql;
                req.preparedQuery = this.preparedQuery;
                req.managerRef.set((ClickHouseRequestManager)this.managerRef.get());
                req.txRef.set((ClickHouseTransaction)this.txRef.get());
            }
            return req;
        }
    }
}

