/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseClientBuilder;
import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.client.config.ClickHouseSslMode;
import com.clickhouse.config.ClickHouseBufferingMode;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.config.ClickHouseRenameMethod;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseCompression;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.ClickHouseVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;

public class ClickHouseConfig
implements ClickHouseDataConfig {
    private static final long serialVersionUID = 7794222888859182491L;
    static final String PARAM_OPTION = "option";
    public static final String TYPE_NAME = "Config";
    private final boolean async;
    private final boolean autoDiscovery;
    private final Map<String, String> customSettings;
    private final String clientName;
    private final boolean compressRequest;
    private final ClickHouseCompression compressAlgorithm;
    private final int compressLevel;
    private final boolean decompressResponse;
    private final ClickHouseCompression decompressAlgorithm;
    private final int decompressLevel;
    private final int connectionTimeout;
    private final String database;
    private final ClickHouseFormat format;
    private final int maxBufferSize;
    private final int bufferSize;
    private final int bufferQueueVariation;
    private final int readBufferSize;
    private final int writeBufferSize;
    private final int requestChunkSize;
    private final ClickHouseBufferingMode requestBuffering;
    private final ClickHouseBufferingMode responseBuffering;
    private final int maxExecutionTime;
    private final int maxMapperCache;
    private final int maxQueuedBuffers;
    private final int maxQueuedRequests;
    private final long maxResultRows;
    private final int maxThreads;
    private final String productName;
    private final int nodeCheckInterval;
    private final int failover;
    private final int retry;
    private final boolean repeatOnSessionLock;
    private final boolean reuseValueWrapper;
    private final boolean serverInfo;
    private final TimeZone serverTimeZone;
    private final ClickHouseVersion serverVersion;
    private final int sessionTimeout;
    private final boolean sessionCheck;
    private final int socketTimeout;
    private final boolean ssl;
    private final ClickHouseSslMode sslMode;
    private final String sslRootCert;
    private final String sslCert;
    private final String sslKey;
    private final int transactionTimeout;
    private final boolean widenUnsignedTypes;
    private final boolean useBinaryString;
    private final boolean useBlockingQueue;
    private final boolean useCompilation;
    private final boolean useObjectsInArray;
    private final boolean useNoProxy;
    private final boolean useServerTimeZone;
    private final boolean useServerTimeZoneForDates;
    private final TimeZone timeZoneForDate;
    private final TimeZone useTimeZone;
    private final Map<ClickHouseOption, Serializable> options = new HashMap<ClickHouseOption, Serializable>();
    private final ClickHouseCredentials credentials;
    private final transient Optional<Object> metricRegistry;
    private final ClickHouseNodeSelector nodeSelector;

    protected static final Map<ClickHouseOption, Serializable> mergeOptions(List<ClickHouseConfig> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<ClickHouseOption, Serializable> options = new HashMap<ClickHouseOption, Serializable>();
        ArrayList<ClickHouseConfig> cl = new ArrayList<ClickHouseConfig>(list.size());
        for (ClickHouseConfig c : list) {
            if (c == null) continue;
            boolean duplicated = false;
            for (ClickHouseConfig conf : cl) {
                if (conf != c) continue;
                duplicated = true;
                break;
            }
            if (duplicated) continue;
            options.putAll(c.options);
            cl.add(c);
        }
        return options;
    }

    protected static final ClickHouseCredentials mergeCredentials(List<ClickHouseConfig> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ClickHouseCredentials credentials = null;
        for (ClickHouseConfig c : list) {
            if (c == null || c.credentials == null) continue;
            credentials = c.credentials;
            break;
        }
        return credentials;
    }

    protected static final ClickHouseNodeSelector mergeNodeSelector(List<ClickHouseConfig> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ClickHouseNodeSelector nodeSelector = null;
        for (ClickHouseConfig c : list) {
            if (c == null || c.nodeSelector == null) continue;
            nodeSelector = c.nodeSelector;
            break;
        }
        return nodeSelector;
    }

    protected static final Object mergeMetricRegistry(List<ClickHouseConfig> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Object metricRegistry = null;
        for (ClickHouseConfig c : list) {
            if (c == null || !c.metricRegistry.isPresent()) continue;
            metricRegistry = c.metricRegistry.get();
            break;
        }
        return metricRegistry;
    }

    public static Map<ClickHouseOption, Serializable> toClientOptions(Map<?, ?> props) {
        HashMap<ClickHouseOption, Serializable> options = new HashMap<ClickHouseOption, Serializable>();
        if (props != null && !props.isEmpty()) {
            Map<String, ClickHouseOption> customOptions = ClientOptions.INSTANCE.customOptions;
            for (Map.Entry<?, ?> e : props.entrySet()) {
                if (e.getKey() == null || e.getValue() == null) continue;
                String key = e.getKey().toString();
                ClickHouseClientOption o = ClickHouseClientOption.fromKey(key);
                if (o == null) {
                    o = customOptions.get(key);
                }
                if (o == null) continue;
                options.put(o, ClickHouseOption.fromString((String)e.getValue().toString(), (Class)o.getValueType()));
            }
        }
        return options;
    }

    public ClickHouseConfig(ClickHouseConfig ... configs) {
        this(configs == null || configs.length == 0 ? Collections.emptyList() : Arrays.asList(configs));
    }

    public ClickHouseConfig(List<ClickHouseConfig> configs) {
        this(ClickHouseConfig.mergeOptions(configs), ClickHouseConfig.mergeCredentials(configs), ClickHouseConfig.mergeNodeSelector(configs), ClickHouseConfig.mergeMetricRegistry(configs));
    }

    public ClickHouseConfig(Map<ClickHouseOption, Serializable> options) {
        this(options, null, null, null);
    }

    public ClickHouseConfig(Map<ClickHouseOption, Serializable> options, ClickHouseCredentials credentials, ClickHouseNodeSelector nodeSelector, Object metricRegistry) {
        if (options != null) {
            this.options.putAll(options);
        }
        this.async = (Boolean)this.getOption((ClickHouseOption)ClickHouseClientOption.ASYNC, ClickHouseDefaults.ASYNC);
        this.autoDiscovery = this.getBoolOption(ClickHouseClientOption.AUTO_DISCOVERY);
        this.customSettings = ClickHouseOption.toKeyValuePairs((String)this.getStrOption(ClickHouseClientOption.CUSTOM_SETTINGS));
        this.clientName = this.getStrOption(ClickHouseClientOption.CLIENT_NAME);
        this.compressRequest = this.getBoolOption(ClickHouseClientOption.DECOMPRESS);
        this.compressAlgorithm = this.getOption((ClickHouseOption)ClickHouseClientOption.DECOMPRESS_ALGORITHM, ClickHouseCompression.class);
        this.compressLevel = this.getIntOption(ClickHouseClientOption.DECOMPRESS_LEVEL);
        this.decompressResponse = this.getBoolOption(ClickHouseClientOption.COMPRESS);
        this.decompressAlgorithm = this.getOption((ClickHouseOption)ClickHouseClientOption.COMPRESS_ALGORITHM, ClickHouseCompression.class);
        this.decompressLevel = this.getIntOption(ClickHouseClientOption.COMPRESS_LEVEL);
        this.connectionTimeout = this.getIntOption(ClickHouseClientOption.CONNECTION_TIMEOUT);
        this.database = (String)((Object)this.getOption((ClickHouseOption)ClickHouseClientOption.DATABASE, ClickHouseDefaults.DATABASE));
        this.format = (ClickHouseFormat)this.getOption((ClickHouseOption)ClickHouseClientOption.FORMAT, ClickHouseDefaults.FORMAT);
        this.maxBufferSize = ClickHouseDataConfig.getBufferSize((int)this.getIntOption(ClickHouseClientOption.MAX_BUFFER_SIZE), (int)-1, (int)-1);
        this.bufferSize = this.getIntOption(ClickHouseClientOption.BUFFER_SIZE);
        this.bufferQueueVariation = this.getIntOption(ClickHouseClientOption.BUFFER_QUEUE_VARIATION);
        this.readBufferSize = this.getIntOption(ClickHouseClientOption.READ_BUFFER_SIZE);
        this.writeBufferSize = this.getIntOption(ClickHouseClientOption.WRITE_BUFFER_SIZE);
        this.requestChunkSize = this.getIntOption(ClickHouseClientOption.REQUEST_CHUNK_SIZE);
        this.requestBuffering = (ClickHouseBufferingMode)this.getOption((ClickHouseOption)ClickHouseClientOption.REQUEST_BUFFERING, ClickHouseDefaults.BUFFERING);
        this.responseBuffering = (ClickHouseBufferingMode)this.getOption((ClickHouseOption)ClickHouseClientOption.RESPONSE_BUFFERING, ClickHouseDefaults.BUFFERING);
        this.maxExecutionTime = this.getIntOption(ClickHouseClientOption.MAX_EXECUTION_TIME);
        this.maxMapperCache = this.getIntOption(ClickHouseClientOption.MAX_MAPPER_CACHE);
        this.maxQueuedBuffers = this.getIntOption(ClickHouseClientOption.MAX_QUEUED_BUFFERS);
        this.maxQueuedRequests = this.getIntOption(ClickHouseClientOption.MAX_QUEUED_REQUESTS);
        this.maxResultRows = this.getLongOption(ClickHouseClientOption.MAX_RESULT_ROWS);
        this.maxThreads = this.getIntOption(ClickHouseClientOption.MAX_THREADS_PER_CLIENT);
        this.productName = this.getStrOption(ClickHouseClientOption.PRODUCT_NAME);
        this.nodeCheckInterval = this.getIntOption(ClickHouseClientOption.NODE_CHECK_INTERVAL);
        this.failover = this.getIntOption(ClickHouseClientOption.FAILOVER);
        this.retry = this.getIntOption(ClickHouseClientOption.RETRY);
        this.repeatOnSessionLock = this.getBoolOption(ClickHouseClientOption.REPEAT_ON_SESSION_LOCK);
        this.reuseValueWrapper = this.getBoolOption(ClickHouseClientOption.REUSE_VALUE_WRAPPER);
        this.serverInfo = !ClickHouseChecker.isNullOrBlank((CharSequence)this.getStrOption(ClickHouseClientOption.SERVER_TIME_ZONE)) && !ClickHouseChecker.isNullOrBlank((CharSequence)this.getStrOption(ClickHouseClientOption.SERVER_VERSION));
        this.serverTimeZone = TimeZone.getTimeZone((String)((Object)this.getOption((ClickHouseOption)ClickHouseClientOption.SERVER_TIME_ZONE, ClickHouseDefaults.SERVER_TIME_ZONE)));
        this.serverVersion = ClickHouseVersion.of((String)((String)((Object)this.getOption((ClickHouseOption)ClickHouseClientOption.SERVER_VERSION, ClickHouseDefaults.SERVER_VERSION))));
        this.sessionTimeout = this.getIntOption(ClickHouseClientOption.SESSION_TIMEOUT);
        this.sessionCheck = this.getBoolOption(ClickHouseClientOption.SESSION_CHECK);
        this.socketTimeout = this.getIntOption(ClickHouseClientOption.SOCKET_TIMEOUT);
        this.ssl = this.getBoolOption(ClickHouseClientOption.SSL);
        this.sslMode = this.getOption((ClickHouseOption)ClickHouseClientOption.SSL_MODE, ClickHouseSslMode.class);
        this.sslRootCert = this.getStrOption(ClickHouseClientOption.SSL_ROOT_CERTIFICATE);
        this.sslCert = this.getStrOption(ClickHouseClientOption.SSL_CERTIFICATE);
        this.sslKey = this.getStrOption(ClickHouseClientOption.SSL_KEY);
        this.transactionTimeout = this.getIntOption(ClickHouseClientOption.TRANSACTION_TIMEOUT);
        this.widenUnsignedTypes = this.getBoolOption(ClickHouseClientOption.WIDEN_UNSIGNED_TYPES);
        this.useBinaryString = this.getBoolOption(ClickHouseClientOption.USE_BINARY_STRING);
        this.useBlockingQueue = this.getBoolOption(ClickHouseClientOption.USE_BLOCKING_QUEUE);
        this.useCompilation = this.getBoolOption(ClickHouseClientOption.USE_COMPILATION);
        this.useObjectsInArray = this.getBoolOption(ClickHouseClientOption.USE_OBJECTS_IN_ARRAYS);
        this.useNoProxy = this.getBoolOption(ClickHouseClientOption.USE_NO_PROXY);
        this.useServerTimeZone = this.getBoolOption(ClickHouseClientOption.USE_SERVER_TIME_ZONE);
        this.useServerTimeZoneForDates = this.getBoolOption(ClickHouseClientOption.USE_SERVER_TIME_ZONE_FOR_DATES);
        String timeZone = this.getStrOption(ClickHouseClientOption.USE_TIME_ZONE);
        TimeZone tz = ClickHouseChecker.isNullOrBlank((CharSequence)timeZone) ? TimeZone.getDefault() : TimeZone.getTimeZone(timeZone);
        this.useTimeZone = this.useServerTimeZone ? this.serverTimeZone : tz;
        this.timeZoneForDate = this.useServerTimeZoneForDates ? this.useTimeZone : null;
        this.credentials = credentials == null ? ClickHouseCredentials.fromUserAndPassword(this.getStrOption(ClickHouseDefaults.USER), this.getStrOption(ClickHouseDefaults.PASSWORD)) : credentials;
        this.metricRegistry = Optional.ofNullable(metricRegistry);
        this.nodeSelector = nodeSelector == null ? ClickHouseNodeSelector.EMPTY : nodeSelector;
    }

    public boolean isAsync() {
        return this.async;
    }

    public boolean isAutoDiscovery() {
        return this.autoDiscovery;
    }

    public Map<String, String> getCustomSettings() {
        return this.customSettings;
    }

    public String getClientName() {
        return this.clientName;
    }

    public boolean isResponseCompressed() {
        return this.decompressResponse;
    }

    public ClickHouseCompression getResponseCompressAlgorithm() {
        return this.decompressResponse ? this.decompressAlgorithm : ClickHouseCompression.NONE;
    }

    public int getResponseCompressLevel() {
        return this.decompressResponse ? this.decompressLevel : -1;
    }

    public boolean isRequestCompressed() {
        return this.compressRequest;
    }

    public ClickHouseCompression getRequestCompressAlgorithm() {
        return this.compressRequest ? this.compressAlgorithm : ClickHouseCompression.NONE;
    }

    public int getRequestCompressLevel() {
        return this.compressRequest ? this.compressLevel : -1;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public String getDatabase() {
        return this.database;
    }

    public ClickHouseFormat getFormat() {
        return this.format;
    }

    public int getNodeCheckInterval() {
        return this.nodeCheckInterval;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public int getMaxMapperCache() {
        return this.maxMapperCache;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getBufferQueueVariation() {
        return this.bufferQueueVariation;
    }

    public int getReadBufferSize() {
        return ClickHouseDataConfig.getBufferSize((int)this.readBufferSize, (int)this.getBufferSize(), (int)this.getMaxBufferSize());
    }

    public int getWriteBufferSize() {
        return ClickHouseDataConfig.getBufferSize((int)this.writeBufferSize, (int)this.getBufferSize(), (int)this.getMaxBufferSize());
    }

    public int getRequestChunkSize() {
        return ClickHouseDataConfig.getBufferSize((int)this.requestChunkSize, (int)this.getWriteBufferSize(), (int)this.getMaxBufferSize());
    }

    public ClickHouseBufferingMode getRequestBuffering() {
        return this.requestBuffering;
    }

    public ClickHouseBufferingMode getResponseBuffering() {
        return this.responseBuffering;
    }

    public int getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    public int getMaxQueuedBuffers() {
        return this.maxQueuedBuffers;
    }

    public int getMaxQueuedRequests() {
        return this.maxQueuedRequests;
    }

    public long getMaxResultRows() {
        return this.maxResultRows;
    }

    public int getMaxThreadsPerClient() {
        return this.maxThreads;
    }

    public String getProductName() {
        return this.productName;
    }

    public int getFailover() {
        return this.failover;
    }

    public int getRetry() {
        return this.retry;
    }

    public boolean isRepeatOnSessionLock() {
        return this.repeatOnSessionLock;
    }

    public boolean isReuseValueWrapper() {
        return this.reuseValueWrapper;
    }

    public boolean hasServerInfo() {
        return this.serverInfo;
    }

    public TimeZone getServerTimeZone() {
        return this.serverTimeZone;
    }

    public ClickHouseVersion getServerVersion() {
        return this.serverVersion;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public boolean isSessionCheck() {
        return this.sessionCheck;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public ClickHouseSslMode getSslMode() {
        return this.sslMode;
    }

    public String getSslRootCert() {
        return this.sslRootCert;
    }

    public String getSslCert() {
        return this.sslCert;
    }

    public String getSslKey() {
        return this.sslKey;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout < 1 ? this.sessionTimeout : this.transactionTimeout;
    }

    public boolean isWidenUnsignedTypes() {
        return this.widenUnsignedTypes;
    }

    public boolean isUseBinaryString() {
        return this.useBinaryString;
    }

    public boolean isUseBlockingQueue() {
        return this.useBlockingQueue;
    }

    public boolean isUseCompilation() {
        return this.useCompilation;
    }

    public boolean isUseObjectsInArray() {
        return this.useObjectsInArray;
    }

    public boolean isUseNoProxy() {
        return this.useNoProxy;
    }

    public boolean isUseServerTimeZone() {
        return this.useServerTimeZone;
    }

    public boolean isUseServerTimeZoneForDates() {
        return this.useServerTimeZoneForDates;
    }

    public TimeZone getTimeZoneForDate() {
        return this.timeZoneForDate;
    }

    public TimeZone getUseTimeZone() {
        return this.useTimeZone;
    }

    public final String getProductVersion() {
        return ClickHouseClientOption.PRODUCT_VERSION;
    }

    public final String getProductRevision() {
        return ClickHouseClientOption.PRODUCT_REVISION;
    }

    public final String getClientOsInfo() {
        return ClickHouseClientOption.CLIENT_OS_INFO;
    }

    public final String getClientJvmInfo() {
        return ClickHouseClientOption.CLIENT_JVM_INFO;
    }

    public final String getClientUser() {
        return ClickHouseClientOption.CLIENT_USER;
    }

    public final String getClientHost() {
        return ClickHouseClientOption.CLIENT_HOST;
    }

    public ClickHouseCredentials getDefaultCredentials() {
        return this.credentials;
    }

    public Optional<Object> getMetricRegistry() {
        return this.metricRegistry;
    }

    public ClickHouseNodeSelector getNodeSelector() {
        return this.nodeSelector;
    }

    public List<ClickHouseProtocol> getPreferredProtocols() {
        return this.nodeSelector.getPreferredProtocols();
    }

    public Set<String> getPreferredTags() {
        return this.nodeSelector.getPreferredTags();
    }

    public Map<ClickHouseOption, Serializable> getAllOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    public <T extends Serializable> T getOption(ClickHouseOption option, Class<T> valueType) {
        if (((ClickHouseOption)ClickHouseChecker.nonNull((Object)option, (String)PARAM_OPTION)).getValueType() != ClickHouseChecker.nonNull(valueType, (String)"valueType")) {
            throw new IllegalArgumentException("Cannot convert value from type " + option.getValueType() + " to " + valueType);
        }
        Serializable value = this.options.get(option);
        return (T)(value != null ? value : option.getEffectiveDefaultValue());
    }

    public Serializable getOption(ClickHouseOption option, ClickHouseConfig defaultConfig) {
        return this.options.getOrDefault(ClickHouseChecker.nonNull((Object)option, (String)PARAM_OPTION), defaultConfig == null ? option.getEffectiveDefaultValue() : defaultConfig.getOption(option));
    }

    public Serializable getOption(ClickHouseOption option, ClickHouseDefaults defaultValue) {
        return this.options.getOrDefault(ClickHouseChecker.nonNull((Object)option, (String)PARAM_OPTION), defaultValue == null ? option.getEffectiveDefaultValue() : defaultValue.getEffectiveDefaultValue());
    }

    public Serializable getOption(ClickHouseOption option) {
        return this.getOption(option, (ClickHouseDefaults)null);
    }

    public boolean getBoolOption(ClickHouseOption option) {
        return this.getOption(option, Boolean.class);
    }

    public int getIntOption(ClickHouseOption option) {
        return this.getOption(option, Integer.class);
    }

    public long getLongOption(ClickHouseOption option) {
        return this.getOption(option, Long.class);
    }

    public String getStrOption(ClickHouseOption option) {
        return this.getOption(option, String.class);
    }

    public boolean hasOption(ClickHouseOption option) {
        return option != null && this.options.containsKey(option);
    }

    public int hashCode() {
        return Objects.hash(this.options, this.credentials, this.metricRegistry.orElse(null), this.nodeSelector);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseConfig other = (ClickHouseConfig)obj;
        return Objects.equals(this.options, other.options) && Objects.equals(this.credentials, other.credentials) && Objects.equals(this.metricRegistry.orElse(null), other.metricRegistry.orElse(null)) && Objects.equals(this.nodeSelector, other.nodeSelector);
    }

    public int getReadTimeout() {
        return this.getSocketTimeout();
    }

    public int getWriteTimeout() {
        return this.getSocketTimeout();
    }

    public ClickHouseBufferingMode getReadBufferingMode() {
        return this.getResponseBuffering();
    }

    public ClickHouseBufferingMode getWriteBufferingMode() {
        return this.getRequestBuffering();
    }

    public ClickHouseRenameMethod getColumnRenameMethod() {
        return (ClickHouseRenameMethod)this.getOption(ClickHouseClientOption.RENAME_RESPONSE_COLUMN);
    }

    static final class ClientOptions {
        static final ClientOptions INSTANCE = new ClientOptions();
        final Map<String, ClickHouseOption> customOptions;
        final Map<String, ClickHouseOption> sensitiveOptions;

        private ClientOptions() {
            LinkedHashMap<String, ClickHouseOption> m = new LinkedHashMap<String, ClickHouseOption>();
            LinkedHashMap<String, ClickHouseOption> s = new LinkedHashMap<String, ClickHouseOption>();
            for (ClickHouseClientOption o : (ClickHouseClientOption[])ClickHouseClientOption.class.getEnumConstants()) {
                if (!o.isSensitive()) continue;
                s.put(o.getKey(), o);
            }
            try {
                for (ClickHouseClient c : ClickHouseClientBuilder.loadClients()) {
                    Class<? extends ClickHouseOption> clazz = c.getOptionClass();
                    if (clazz == null || clazz == ClickHouseClientOption.class) continue;
                    for (ClickHouseOption o : clazz.getEnumConstants()) {
                        m.put(o.getKey(), o);
                        if (!o.isSensitive()) continue;
                        s.put(o.getKey(), o);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.customOptions = m.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(m);
            this.sensitiveOptions = s.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(s);
        }
    }
}

