/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.BinaryStreamUtils;
import com.clickhouse.client.data.ClickHousePipedStream;
import com.clickhouse.client.data.ClickHouseRowBinaryProcessor;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import com.clickhouse.jdbc.ClickHouseConnection;
import com.clickhouse.jdbc.SqlExceptionUtils;
import com.clickhouse.jdbc.internal.ClickHouseStatementImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;

public class StreamBasedPreparedStatement
extends ClickHouseStatementImpl
implements PreparedStatement {
    private static final Logger log = LoggerFactory.getLogger(StreamBasedPreparedStatement.class);
    private final Calendar defaultCalendar;
    private final ZoneId jvmZoneId;
    private final List<ClickHouseColumn> columns;
    private final ClickHouseValue[] values;
    private final boolean[] flags;
    private ClickHousePipedStream stream;
    private final List<InputStream> batch;

    protected StreamBasedPreparedStatement(ClickHouseConnection connection, ClickHouseRequest<?> request, List<ClickHouseColumn> columns, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, request, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.defaultCalendar = connection.getDefaultCalendar();
        this.jvmZoneId = connection.getJvmTimeZone().toZoneId();
        this.columns = columns;
        int size = columns.size();
        int i = 0;
        this.values = new ClickHouseValue[size];
        for (ClickHouseColumn col : columns) {
            this.values[i++] = ClickHouseValues.newValue((ClickHouseColumn)col);
        }
        this.flags = new boolean[size];
        ClickHouseConfig config = request.getConfig();
        this.stream = new ClickHousePipedStream(config.getMaxBufferSize(), 0, config.getSocketTimeout());
        this.batch = new LinkedList<InputStream>();
    }

    protected void ensureParams() throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (this.flags[i]) continue;
            list.add(String.valueOf(i + 1));
        }
        if (!list.isEmpty()) {
            throw SqlExceptionUtils.clientError(ClickHouseUtils.format((String)"Missing parameter(s): %s", (Object[])new Object[]{list}));
        }
    }

    protected int toArrayIndex(int parameterIndex) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.values.length) {
            throw SqlExceptionUtils.clientError(ClickHouseUtils.format((String)"Parameter index must between 1 and %d but we got %d", (Object[])new Object[]{this.values.length, parameterIndex}));
        }
        return parameterIndex - 1;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.ensureParams();
        return null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.ensureParams();
        this.addBatch();
        return this.executeBatch()[0];
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setNull(parameterIndex, sqlType, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(new String(x, StandardCharsets.UTF_8));
        this.flags[idx] = true;
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, null);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, null);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        String s = null;
        if (x != null) {
            try {
                s = BinaryStreamUtils.readFixedString((ClickHouseInputStream)ClickHouseInputStream.of((InputStream)x), (int)length, (Charset)StandardCharsets.US_ASCII);
            }
            catch (Throwable e) {
                throw SqlExceptionUtils.clientError(e);
            }
        }
        this.setString(parameterIndex, s);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        String s = null;
        if (x != null) {
            try {
                s = BinaryStreamUtils.readFixedString((ClickHouseInputStream)ClickHouseInputStream.of((InputStream)x), (int)length, (Charset)StandardCharsets.UTF_8);
            }
            catch (Throwable e) {
                throw SqlExceptionUtils.clientError(e);
            }
        }
        this.setString(parameterIndex, s);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.ensureOpen();
        ClickHouseConfig config = this.getConfig();
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                throw SqlExceptionUtils.handle(e);
            }
        }
        this.stream = new ClickHousePipedStream(config.getMaxBufferSize(), 0, config.getSocketTimeout());
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            this.values[i].resetToNullOrEmpty();
            this.flags[i] = false;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public boolean execute() throws SQLException {
        this.ensureParams();
        return false;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.ensureOpen();
        throw SqlExceptionUtils.unsupportedError("addBatch(String) cannot be called in PreparedStatement or CallableStatement!");
    }

    @Override
    public void addBatch() throws SQLException {
        this.ensureOpen();
        ClickHouseRowBinaryProcessor.MappedFunctions functions = ClickHouseRowBinaryProcessor.getMappedFunctions();
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (!this.flags[i]) {
                throw SqlExceptionUtils.clientError(ClickHouseUtils.format((String)"Missing value for parameter #%d", (Object[])new Object[]{i + 1}));
            }
            try {
                functions.serialize(this.values[i], this.getConfig(), this.columns.get(i), (OutputStream)this.stream);
                continue;
            }
            catch (IOException e) {
                throw SqlExceptionUtils.handle(e);
            }
        }
        this.batch.add((InputStream)this.stream.getInput());
        this.clearParameters();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.ensureOpen();
        int len = this.batch.size();
        int[] results = new int[len];
        int counter = 0;
        for (InputStream input : this.batch) {
            try {
                results[counter] = this.executeInsert((String)this.getRequest().getStatements(false).get(0), input);
            }
            catch (Exception e) {
                results[counter] = -3;
                log.error((Object)"Failed to execute task %d of %d", new Object[]{counter + 1, len, e});
            }
            ++counter;
        }
        this.clearBatch();
        return results;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureOpen();
        this.batch.clear();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        String s = null;
        if (reader != null) {
            try {
                s = BinaryStreamUtils.readString((Reader)reader, (int)length);
            }
            catch (Throwable e) {
                throw SqlExceptionUtils.clientError(e);
            }
        }
        this.setString(parameterIndex, s);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        if (x != null) {
            this.setBinaryStream(parameterIndex, x.getBinaryStream());
        } else {
            this.setNull(parameterIndex, -2);
        }
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet currentResult = this.getResultSet();
        return currentResult != null ? currentResult.getMetaData() : null;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        if (x == null) {
            this.values[idx].resetToNullOrEmpty();
            this.flags[idx] = true;
            return;
        }
        LocalDateTime dt = null;
        dt = cal != null ? x.toLocalDateTime().atZone(this.jvmZoneId).withZoneSameInstant(cal.getTimeZone().toZoneId()).toLocalDateTime() : x.toLocalDateTime();
        this.values[idx].update(dt);
        this.flags[idx] = true;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].resetToNullOrEmpty();
        this.flags[idx] = true;
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setString(parameterIndex, String.valueOf(x));
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.ensureOpen();
        this.toArrayIndex(parameterIndex);
        throw SqlExceptionUtils.unsupportedError("setRowId not implemented");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.ensureOpen();
        this.toArrayIndex(parameterIndex);
        throw SqlExceptionUtils.unsupportedError("setNClob not implemented");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ensureOpen();
        this.toArrayIndex(parameterIndex);
        throw SqlExceptionUtils.unsupportedError("setClob not implemented");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.ensureOpen();
        this.toArrayIndex(parameterIndex);
        throw SqlExceptionUtils.unsupportedError("setBlob not implemented");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.ensureOpen();
        this.toArrayIndex(parameterIndex);
        throw SqlExceptionUtils.unsupportedError("setSQLXML not implemented");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.ensureOpen();
        this.toArrayIndex(parameterIndex);
        throw SqlExceptionUtils.unsupportedError("setAsciiStream not implemented");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.ensureOpen();
        this.toArrayIndex(parameterIndex);
        throw SqlExceptionUtils.unsupportedError("setBinaryStream not implemented");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ensureOpen();
        this.toArrayIndex(parameterIndex);
        throw SqlExceptionUtils.unsupportedError("setCharacterStream not implemented");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setClob(parameterIndex, reader);
    }
}

