/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.ClickHouseParameterizedQuery;
import com.clickhouse.client.ClickHouseUtils;

public final class JdbcParameterizedQuery
extends ClickHouseParameterizedQuery {
    public static JdbcParameterizedQuery of(String query) {
        return new JdbcParameterizedQuery(query);
    }

    private JdbcParameterizedQuery(String query) {
        super(query);
    }

    protected String parse() {
        int paramIndex = 0;
        int partIndex = 0;
        int len = this.originalQuery.length();
        for (int i = 0; i < len; ++i) {
            char ch = this.originalQuery.charAt(i);
            if (ClickHouseUtils.isQuote((char)ch)) {
                i = ClickHouseUtils.skipQuotedString((String)this.originalQuery, (int)i, (int)len, (char)ch) - 1;
                continue;
            }
            if (ch == '?') {
                int idx = ClickHouseUtils.skipContentsUntil((String)this.originalQuery, (int)(i + 2), (int)len, (char[])new char[]{'?', ':'});
                if (idx < len && this.originalQuery.charAt(idx - 1) == ':' && this.originalQuery.charAt(idx) != ':' && this.originalQuery.charAt(idx - 2) != ':') {
                    i = idx - 1;
                    continue;
                }
                this.addPart(this.originalQuery.substring(partIndex, i), paramIndex++, null);
                partIndex = i + 1;
                continue;
            }
            if (ch == ';') {
                throw new IllegalArgumentException(ClickHouseUtils.format((String)"Multi-statement query cannot be used in prepared statement. Please remove semicolon at %d and everything after it.", (Object[])new Object[]{i}));
            }
            if (i + 1 >= len) continue;
            char nextCh = this.originalQuery.charAt(i + 1);
            if (ch == '-' && nextCh == ch) {
                i = ClickHouseUtils.skipSingleLineComment((String)this.originalQuery, (int)(i + 2), (int)len) - 1;
                continue;
            }
            if (ch != '/' || nextCh != '*') continue;
            i = ClickHouseUtils.skipMultiLineComment((String)this.originalQuery, (int)(i + 2), (int)len) - 1;
        }
        return partIndex < len ? this.originalQuery.substring(partIndex, len) : null;
    }
}

