/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseParameterizedQuery;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRecord;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.ClickHouseVersion;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseOption;
import com.clickhouse.client.http.config.ClickHouseHttpOption;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import com.clickhouse.jdbc.ClickHouseConnection;
import com.clickhouse.jdbc.ClickHouseDatabaseMetaData;
import com.clickhouse.jdbc.ClickHouseDriver;
import com.clickhouse.jdbc.ClickHouseStatement;
import com.clickhouse.jdbc.JdbcConfig;
import com.clickhouse.jdbc.JdbcParameterizedQuery;
import com.clickhouse.jdbc.JdbcParseHandler;
import com.clickhouse.jdbc.JdbcWrapper;
import com.clickhouse.jdbc.SqlExceptionUtils;
import com.clickhouse.jdbc.internal.ClickHouseJdbcUrlParser;
import com.clickhouse.jdbc.internal.ClickHouseStatementImpl;
import com.clickhouse.jdbc.internal.FakeTransaction;
import com.clickhouse.jdbc.internal.InputBasedPreparedStatement;
import com.clickhouse.jdbc.internal.SqlBasedPreparedStatement;
import com.clickhouse.jdbc.internal.TableBasedPreparedStatement;
import com.clickhouse.jdbc.parser.ClickHouseSqlParser;
import com.clickhouse.jdbc.parser.ClickHouseSqlStatement;
import com.clickhouse.jdbc.parser.StatementType;
import java.io.Serializable;
import java.net.URI;
import java.sql.ClientInfoStatus;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class ClickHouseConnectionImpl
extends JdbcWrapper
implements ClickHouseConnection {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseConnectionImpl.class);
    private final JdbcConfig jdbcConf;
    private final ClickHouseClient client;
    private final ClickHouseRequest<?> clientRequest;
    private boolean autoCommit;
    private boolean closed;
    private String database;
    private boolean readOnly;
    private int networkTimeout;
    private int rsHoldability;
    private int txIsolation;
    private final Optional<TimeZone> clientTimeZone;
    private final Calendar defaultCalendar;
    private final TimeZone jvmTimeZone;
    private final TimeZone serverTimeZone;
    private final ClickHouseVersion serverVersion;
    private final String user;
    private final Map<String, Class<?>> typeMap;
    private final AtomicReference<FakeTransaction> fakeTransaction;
    private URI uri;

    protected void ensureOpen() throws SQLException {
        if (this.closed) {
            throw SqlExceptionUtils.clientError("Cannot operate on a closed connection");
        }
    }

    protected void ensureSupport(String feature, boolean silent) throws SQLException {
        String msg = feature + " is not supported";
        if (this.jdbcConf.isJdbcCompliant()) {
            if (silent) {
                log.debug((Object)"[JDBC Compliant Mode] %s. Change %s to false to throw SQLException instead.", new Object[]{msg, "jdbcCompliant"});
            } else {
                log.warn((Object)"[JDBC Compliant Mode] %s. Change %s to false to throw SQLException instead.", new Object[]{msg, "jdbcCompliant"});
            }
        } else if (!silent) {
            throw SqlExceptionUtils.unsupportedError(msg);
        }
    }

    protected void ensureTransactionSupport() throws SQLException {
        this.ensureSupport("Transaction", false);
    }

    final FakeTransaction getTransaction() {
        return this.fakeTransaction.get();
    }

    public ClickHouseConnectionImpl(String url) throws SQLException {
        this(url, new Properties());
    }

    public ClickHouseConnectionImpl(String url, Properties properties) throws SQLException {
        this(ClickHouseJdbcUrlParser.parse(url, properties));
    }

    public ClickHouseConnectionImpl(ClickHouseJdbcUrlParser.ConnectionInfo connInfo) throws SQLException {
        Properties properties = connInfo.getProperties();
        this.jdbcConf = connInfo.getJdbcConfig();
        this.autoCommit = !this.jdbcConf.isJdbcCompliant() || this.jdbcConf.isAutoCommit();
        this.uri = connInfo.getUri();
        log.debug((Object)"Creating a new connection to %s", new Object[]{connInfo.getUri()});
        ClickHouseNode node = connInfo.getServer();
        log.debug((Object)"Target node: %s", new Object[]{node});
        this.jvmTimeZone = TimeZone.getDefault();
        this.client = ClickHouseClient.builder().options(ClickHouseDriver.toClientOptions(connInfo.getProperties())).nodeSelector(ClickHouseNodeSelector.of((ClickHouseProtocol)node.getProtocol(), (ClickHouseProtocol[])new ClickHouseProtocol[0])).build();
        this.clientRequest = this.client.connect((Function)node);
        ClickHouseConfig config = this.clientRequest.getConfig();
        String currentDb = null;
        String currentUser = null;
        TimeZone timeZone = null;
        ClickHouseVersion version = null;
        if (config.hasServerInfo()) {
            timeZone = config.getServerTimeZone();
            version = config.getServerVersion();
        } else {
            try (ClickHouseResponse response = (ClickHouseResponse)this.clientRequest.copy().option((ClickHouseOption)ClickHouseClientOption.ASYNC, (Serializable)Boolean.valueOf(false)).option((ClickHouseOption)ClickHouseClientOption.COMPRESS, (Serializable)Boolean.valueOf(false)).option((ClickHouseOption)ClickHouseClientOption.DECOMPRESS, (Serializable)Boolean.valueOf(false)).option((ClickHouseOption)ClickHouseClientOption.FORMAT, (Serializable)ClickHouseFormat.RowBinaryWithNamesAndTypes).query("select currentDatabase(), currentUser(), timezone(), version() FORMAT RowBinaryWithNamesAndTypes").execute().get();){
                ClickHouseRecord r = response.firstRecord();
                currentDb = r.getValue(0).asString();
                currentUser = r.getValue(1).asString();
                String tz = r.getValue(2).asString();
                String ver = r.getValue(3).asString();
                version = ClickHouseVersion.of((String)ver);
                if (ClickHouseChecker.isNullOrBlank((CharSequence)tz)) {
                    tz = "UTC";
                }
                timeZone = "UTC".equals(tz) ? ClickHouseValues.UTC_TIMEZONE : TimeZone.getTimeZone(tz);
                this.clientRequest.option((ClickHouseOption)ClickHouseClientOption.SERVER_TIME_ZONE, (Serializable)((Object)tz)).option((ClickHouseOption)ClickHouseClientOption.SERVER_VERSION, (Serializable)((Object)ver));
            }
            catch (InterruptedException | CancellationException e) {
                Thread.currentThread().interrupt();
                throw SqlExceptionUtils.forCancellation(e);
            }
            catch (Exception e) {
                throw SqlExceptionUtils.handle(e);
            }
        }
        this.autoCommit = true;
        this.closed = false;
        this.database = currentDb != null ? currentDb : config.getDatabase();
        this.clientRequest.use(this.database);
        this.readOnly = false;
        this.networkTimeout = 0;
        this.rsHoldability = 1;
        this.txIsolation = this.jdbcConf.isJdbcCompliant() ? 2 : 0;
        this.user = currentUser != null ? currentUser : node.getCredentials(config).getUserName();
        this.serverTimeZone = timeZone;
        if (config.isUseServerTimeZone()) {
            this.clientTimeZone = Optional.empty();
            this.defaultCalendar = new GregorianCalendar();
        } else {
            this.clientTimeZone = Optional.of(ClickHouseChecker.isNullOrBlank((CharSequence)config.getUseTimeZone()) ? TimeZone.getDefault() : TimeZone.getTimeZone(config.getUseTimeZone()));
            this.defaultCalendar = new GregorianCalendar(this.clientTimeZone.get());
        }
        this.serverVersion = version;
        this.typeMap = new HashMap(this.jdbcConf.getTypeMap());
        this.fakeTransaction = new AtomicReference();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.ensureOpen();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.ensureOpen();
        if (this.autoCommit == autoCommit) {
            return;
        }
        this.ensureTransactionSupport();
        this.autoCommit = autoCommit;
        if (this.autoCommit) {
            FakeTransaction tx = this.fakeTransaction.getAndSet(null);
            if (tx != null) {
                tx.logTransactionDetails(log, "committed");
                tx.clear();
            }
        } else if (!this.fakeTransaction.compareAndSet(null, new FakeTransaction())) {
            log.warn((Object)"[JDBC Compliant Mode] not able to start a new transaction, reuse the exist one", new Object[0]);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.ensureOpen();
        return this.autoCommit;
    }

    @Override
    public void commit() throws SQLException {
        this.ensureOpen();
        if (this.getAutoCommit()) {
            throw SqlExceptionUtils.clientError("Cannot commit in auto-commit mode");
        }
        this.ensureTransactionSupport();
        FakeTransaction tx = this.fakeTransaction.getAndSet(new FakeTransaction());
        if (tx == null) {
            throw new SQLException("Transaction not started", "25000");
        }
        tx.logTransactionDetails(log, "committed");
        tx.clear();
    }

    @Override
    public void rollback() throws SQLException {
        this.ensureOpen();
        if (this.getAutoCommit()) {
            throw SqlExceptionUtils.clientError("Cannot rollback in auto-commit mode");
        }
        this.ensureTransactionSupport();
        FakeTransaction tx = this.fakeTransaction.getAndSet(new FakeTransaction());
        if (tx == null) {
            throw new SQLException("Transaction not started", "25000");
        }
        tx.logTransactionDetails(log, "rolled back");
        tx.clear();
    }

    @Override
    public void close() throws SQLException {
        try {
            this.client.close();
        }
        catch (Exception e) {
            log.warn((Object)"Failed to close connection due to %s", new Object[]{e.getMessage()});
            throw SqlExceptionUtils.handle(e);
        }
        finally {
            this.closed = true;
        }
        FakeTransaction tx = this.fakeTransaction.getAndSet(null);
        if (tx != null) {
            tx.logTransactionDetails(log, "committed");
            tx.clear();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new ClickHouseDatabaseMetaData(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.ensureOpen();
        this.readOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.ensureOpen();
        return this.readOnly;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.ensureOpen();
        log.warn((Object)"ClickHouse does not support catalog, please use setSchema instead", new Object[0]);
    }

    @Override
    public String getCatalog() throws SQLException {
        this.ensureOpen();
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.ensureOpen();
        if (level != 1 && level != 2 && level != 4 && level != 8) {
            throw new SQLException("Invalid transaction isolation level: " + level);
        }
        this.txIsolation = level;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.ensureOpen();
        return this.txIsolation;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureOpen();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.ensureOpen();
        return new HashMap(this.typeMap);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.ensureOpen();
        if (map != null) {
            this.typeMap.putAll(map);
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.ensureOpen();
        if (holdability != 2 && holdability != 1) {
            throw new SQLException("Invalid holdability: " + holdability);
        }
        this.rsHoldability = holdability;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.ensureOpen();
        return this.rsHoldability;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.setSavepoint(null);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.ensureOpen();
        if (this.getAutoCommit()) {
            throw SqlExceptionUtils.clientError("Cannot set savepoint in auto-commit mode");
        }
        if (!this.jdbcConf.isJdbcCompliant()) {
            throw SqlExceptionUtils.unsupportedError("setSavepoint not implemented");
        }
        FakeTransaction tx = this.fakeTransaction.updateAndGet(current -> current != null ? current : new FakeTransaction());
        return tx.newSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.ensureOpen();
        if (this.getAutoCommit()) {
            throw SqlExceptionUtils.clientError("Cannot rollback to savepoint in auto-commit mode");
        }
        if (!this.jdbcConf.isJdbcCompliant()) {
            throw SqlExceptionUtils.unsupportedError("rollback not implemented");
        }
        if (!(savepoint instanceof FakeTransaction.FakeSavepoint)) {
            throw SqlExceptionUtils.clientError("Unsupported type of savepoint: " + savepoint);
        }
        FakeTransaction tx = this.fakeTransaction.get();
        if (tx == null) {
            throw new SQLException("Transaction not started", "25000");
        }
        FakeTransaction.FakeSavepoint s = (FakeTransaction.FakeSavepoint)savepoint;
        tx.logSavepointDetails(log, s, "rolled back");
        tx.toSavepoint(s);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.ensureOpen();
        if (this.getAutoCommit()) {
            throw SqlExceptionUtils.clientError("Cannot release savepoint in auto-commit mode");
        }
        if (!this.jdbcConf.isJdbcCompliant()) {
            throw SqlExceptionUtils.unsupportedError("rollback not implemented");
        }
        if (!(savepoint instanceof FakeTransaction.FakeSavepoint)) {
            throw SqlExceptionUtils.clientError("Unsupported type of savepoint: " + savepoint);
        }
        FakeTransaction tx = this.fakeTransaction.get();
        if (tx == null) {
            throw new SQLException("Transaction not started", "25000");
        }
        FakeTransaction.FakeSavepoint s = (FakeTransaction.FakeSavepoint)savepoint;
        tx.logSavepointDetails(log, s, "released");
        tx.toSavepoint(s);
    }

    @Override
    public ClickHouseStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.ensureOpen();
        return new ClickHouseStatementImpl(this, this.clientRequest.copy(), resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        ClickHouseParameterizedQuery preparedQuery;
        this.ensureOpen();
        ClickHouseSqlStatement[] stmts = this.parse(sql, this.clientRequest.getConfig());
        if (stmts.length != 1) {
            throw SqlExceptionUtils.clientError("Prepared statement only supports one query but we got: " + stmts.length);
        }
        ClickHouseSqlStatement parsedStmt = stmts[0];
        try {
            preparedQuery = this.jdbcConf.useNamedParameter() ? ClickHouseParameterizedQuery.of((String)parsedStmt.getSQL()) : JdbcParameterizedQuery.of(parsedStmt.getSQL());
        }
        catch (RuntimeException e) {
            throw SqlExceptionUtils.clientError(e);
        }
        ClickHouseStatementImpl ps = null;
        if (preparedQuery.hasParameter()) {
            if (parsedStmt.hasTempTable() || parsedStmt.hasInput()) {
                throw SqlExceptionUtils.clientError("External table, input function, and query parameter cannot be used together in PreparedStatement.");
            }
            if (parsedStmt.hasValues()) {
                // empty if block
            }
        } else if (parsedStmt.hasTempTable()) {
            ps = new TableBasedPreparedStatement(this, this.clientRequest.write().query(parsedStmt.getSQL(), this.newQueryId()), parsedStmt.getTempTables(), resultSetType, resultSetConcurrency, resultSetHoldability);
        } else if (parsedStmt.getStatementType() == StatementType.INSERT && !ClickHouseChecker.isNullOrBlank((CharSequence)parsedStmt.getInput())) {
            ps = new InputBasedPreparedStatement(this, this.clientRequest.write().query(parsedStmt.getSQL(), this.newQueryId()), ClickHouseColumn.parse((String)parsedStmt.getInput()), resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return ps != null ? ps : new SqlBasedPreparedStatement(this, this.clientRequest.copy().query(preparedQuery, this.newQueryId()), stmts[0], resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.ensureOpen();
        return this.createClob();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw SqlExceptionUtils.clientError("Negative milliseconds is not allowed");
        }
        if (this.isClosed()) {
            return false;
        }
        return this.client.ping(this.clientRequest.getServer(), (int)TimeUnit.SECONDS.toMillis(timeout));
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.ensureOpen();
        }
        catch (SQLException e) {
            HashMap<String, ClientInfoStatus> failedProps = new HashMap<String, ClientInfoStatus>();
            failedProps.put("ApplicationName", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            failedProps.put("CustomHttpHeaders", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            failedProps.put("CustomHttpParameters", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            throw new SQLClientInfoException(e.getMessage(), failedProps);
        }
        if ("ApplicationName".equals(name)) {
            if (ClickHouseChecker.isNullOrBlank((CharSequence)value)) {
                this.clientRequest.removeOption((ClickHouseOption)ClickHouseClientOption.CLIENT_NAME);
            } else {
                this.clientRequest.option((ClickHouseOption)ClickHouseClientOption.CLIENT_NAME, (Serializable)((Object)value));
            }
        } else if ("CustomHttpHeaders".equals(name)) {
            if (ClickHouseChecker.isNullOrBlank((CharSequence)value)) {
                this.clientRequest.removeOption((ClickHouseOption)ClickHouseHttpOption.CUSTOM_HEADERS);
            } else {
                this.clientRequest.option((ClickHouseOption)ClickHouseHttpOption.CUSTOM_HEADERS, (Serializable)((Object)value));
            }
        } else if ("CustomHttpParameters".equals(name)) {
            if (ClickHouseChecker.isNullOrBlank((CharSequence)value)) {
                this.clientRequest.removeOption((ClickHouseOption)ClickHouseHttpOption.CUSTOM_PARAMS);
            } else {
                this.clientRequest.option((ClickHouseOption)ClickHouseHttpOption.CUSTOM_PARAMS, (Serializable)((Object)value));
            }
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.ensureOpen();
        }
        catch (SQLException e) {
            HashMap<String, ClientInfoStatus> failedProps = new HashMap<String, ClientInfoStatus>();
            failedProps.put("ApplicationName", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            failedProps.put("CustomHttpHeaders", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            failedProps.put("CustomHttpParameters", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            throw new SQLClientInfoException(e.getMessage(), failedProps);
        }
        if (properties != null) {
            String value = properties.getProperty("ApplicationName");
            if (ClickHouseChecker.isNullOrBlank((CharSequence)value)) {
                this.clientRequest.removeOption((ClickHouseOption)ClickHouseClientOption.CLIENT_NAME);
            } else {
                this.clientRequest.option((ClickHouseOption)ClickHouseClientOption.CLIENT_NAME, (Serializable)((Object)value));
            }
            value = properties.getProperty("CustomHttpHeaders");
            if (ClickHouseChecker.isNullOrBlank((CharSequence)value)) {
                this.clientRequest.removeOption((ClickHouseOption)ClickHouseHttpOption.CUSTOM_HEADERS);
            } else {
                this.clientRequest.option((ClickHouseOption)ClickHouseHttpOption.CUSTOM_HEADERS, (Serializable)((Object)value));
            }
            value = properties.getProperty("CustomHttpParameters");
            if (ClickHouseChecker.isNullOrBlank((CharSequence)value)) {
                this.clientRequest.removeOption((ClickHouseOption)ClickHouseHttpOption.CUSTOM_PARAMS);
            } else {
                this.clientRequest.option((ClickHouseOption)ClickHouseHttpOption.CUSTOM_PARAMS, (Serializable)((Object)value));
            }
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.ensureOpen();
        ClickHouseConfig config = this.clientRequest.getConfig();
        String value = null;
        if ("ApplicationName".equals(name)) {
            value = config.getClientName();
        } else if ("CustomHttpHeaders".equals(name)) {
            value = (String)((Object)config.getOption((ClickHouseOption)ClickHouseHttpOption.CUSTOM_HEADERS));
        } else if ("CustomHttpParameters".equals(name)) {
            value = (String)((Object)config.getOption((ClickHouseOption)ClickHouseHttpOption.CUSTOM_PARAMS));
        }
        return value;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.ensureOpen();
        ClickHouseConfig config = this.clientRequest.getConfig();
        Properties props = new Properties();
        props.setProperty("ApplicationName", config.getClientName());
        props.setProperty("CustomHttpHeaders", (String)((Object)config.getOption((ClickHouseOption)ClickHouseHttpOption.CUSTOM_HEADERS)));
        props.setProperty("CustomHttpParameters", (String)((Object)config.getOption((ClickHouseOption)ClickHouseHttpOption.CUSTOM_PARAMS)));
        return props;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.ensureOpen();
        if (schema == null || schema.isEmpty()) {
            throw new SQLException("Non-empty schema name is required", "3F000");
        }
        if (!schema.equals(this.database)) {
            this.database = schema;
            this.clientRequest.use(schema);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        this.ensureOpen();
        return this.getCurrentDatabase();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw SqlExceptionUtils.clientError("Non-null executor is required");
        }
        executor.execute(() -> {
            try {
                this.client.close();
            }
            finally {
                this.closed = true;
            }
        });
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.ensureOpen();
        if (executor == null) {
            throw SqlExceptionUtils.clientError("Non-null executor is required");
        }
        if (milliseconds < 0) {
            throw SqlExceptionUtils.clientError("Negative milliseconds is not allowed");
        }
        executor.execute(() -> {
            this.networkTimeout = milliseconds;
        });
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.ensureOpen();
        return this.networkTimeout;
    }

    @Override
    public String getCurrentDatabase() {
        return this.database;
    }

    @Override
    public String getCurrentUser() {
        return this.user;
    }

    @Override
    public Calendar getDefaultCalendar() {
        return this.defaultCalendar;
    }

    @Override
    public Optional<TimeZone> getEffectiveTimeZone() {
        return this.clientTimeZone;
    }

    @Override
    public TimeZone getJvmTimeZone() {
        return this.jvmTimeZone;
    }

    @Override
    public TimeZone getServerTimeZone() {
        return this.serverTimeZone;
    }

    @Override
    public ClickHouseVersion getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public JdbcConfig getJdbcConfig() {
        return this.jdbcConf;
    }

    @Override
    public String newQueryId() {
        FakeTransaction tx = this.fakeTransaction.get();
        return tx != null ? tx.newQuery(null) : UUID.randomUUID().toString();
    }

    @Override
    public ClickHouseSqlStatement[] parse(String sql, ClickHouseConfig config) {
        return ClickHouseSqlParser.parse(sql, config != null ? config : this.clientRequest.getConfig(), this.jdbcConf.isJdbcCompliant() ? JdbcParseHandler.INSTANCE : null);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface == ClickHouseClient.class || iface == ClickHouseRequest.class || super.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == ClickHouseClient.class) {
            return iface.cast(this.client);
        }
        if (iface == ClickHouseRequest.class) {
            return iface.cast(this.clientRequest);
        }
        return super.unwrap(iface);
    }
}

