/*
 * Decompiled with CFR 0.152.
 */
package com.codingame.gameengine.module.entities;

import com.codingame.gameengine.module.entities.ContainerBasedEntity;
import com.codingame.gameengine.module.entities.Curve;
import com.codingame.gameengine.module.entities.EntityState;
import com.codingame.gameengine.module.entities.GraphicEntityModule;
import com.codingame.gameengine.module.entities.Mask;
import com.codingame.gameengine.module.entities.Shape;
import com.codingame.gameengine.module.entities.Sprite;
import com.codingame.gameengine.module.entities.SpriteAnimation;
import java.util.Optional;

public abstract class Entity<T extends Entity<?>> {
    final int id = ++GraphicEntityModule.ENTITY_COUNT;
    EntityState state = new EntityState();
    private int x;
    private int y;
    private int zIndex;
    private double scaleX = 1.0;
    private double scaleY = 1.0;
    private boolean visible = false;
    private double rotation;
    private double alpha = 1.0;
    ContainerBasedEntity parent;
    Mask mask;

    Entity() {
        this.setVisible(true);
    }

    protected T self() {
        return (T)this;
    }

    public int getId() {
        return this.id;
    }

    protected void set(String key, Object value, Curve curve) {
        this.state.put(key, value, Optional.ofNullable(curve).orElse(Curve.DEFAULT));
    }

    protected void set(String key, Object value) {
        this.set(key, value, null);
    }

    abstract Type getType();

    public T setX(int x) {
        return this.setX(x, null);
    }

    public T setX(int x, Curve curve) {
        this.x = x;
        this.set("x", x, curve);
        return this.self();
    }

    public T setY(int y) {
        return this.setY(y, null);
    }

    public T setY(int y, Curve curve) {
        this.y = y;
        this.set("y", y, curve);
        return this.self();
    }

    public T setZIndex(int zIndex) {
        this.zIndex = zIndex;
        this.set("zIndex", zIndex);
        return this.self();
    }

    public T setScaleX(double scaleX) {
        return this.setScaleX(scaleX, null);
    }

    public T setScaleX(double scaleX, Curve curve) {
        this.scaleX = scaleX;
        this.set("scaleX", scaleX, curve);
        return this.self();
    }

    public T setScaleY(double scaleY) {
        return this.setScaleY(scaleY, null);
    }

    public T setScaleY(double scaleY, Curve curve) {
        this.scaleY = scaleY;
        this.set("scaleY", scaleY, curve);
        return this.self();
    }

    public T setAlpha(double alpha) {
        return this.setAlpha(alpha, null);
    }

    public T setAlpha(double alpha, Curve curve) {
        Entity.requireValidAlpha(alpha);
        this.alpha = alpha;
        this.set("alpha", alpha, curve);
        return this.self();
    }

    public T setScale(double scale) {
        return this.setScale(scale, null);
    }

    public T setScale(double scale, Curve curve) {
        this.setScaleX(scale, curve);
        this.setScaleY(scale, curve);
        return this.self();
    }

    public T setRotation(double rotation) {
        return this.setRotation(rotation, null);
    }

    public T setRotation(double rotation, Curve curve) {
        this.rotation = rotation;
        this.set("rotation", rotation, curve);
        return this.self();
    }

    public T setVisible(boolean visible) {
        this.visible = visible;
        this.set("visible", visible);
        return this.self();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZIndex() {
        return this.zIndex;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getRotation() {
        return this.rotation;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public T setMask(Shape<?> shape) {
        return this.saveMask(shape);
    }

    public T setMask(Sprite sprite) {
        return this.saveMask(sprite);
    }

    public T setMask(SpriteAnimation animation) {
        return this.saveMask(animation);
    }

    private T saveMask(Mask entity) {
        this.mask = entity;
        this.set("mask", entity == null ? -1 : entity.getId());
        return this.self();
    }

    public Mask getMask() {
        return this.mask;
    }

    protected static void requireValidAlpha(double alpha) {
        if (alpha > 1.0) {
            throw new IllegalArgumentException("An alpha may not exceed 1");
        }
        if (alpha < 0.0) {
            throw new IllegalArgumentException("An alpha may not be less than 0");
        }
    }

    protected static void requireValidColor(int color) {
        if (color > 0xFFFFFF) {
            throw new IllegalArgumentException(color + "is not a valid RGB integer.");
        }
    }

    static enum Type {
        CIRCLE,
        LINE,
        RECTANGLE,
        SPRITE,
        TEXT,
        BITMAPTEXT,
        GROUP,
        BUFFERED_GROUP,
        SPRITEANIMATION;

    }
}

