/*
 * Decompiled with CFR 0.152.
 */
package com.codingame.gameengine.module.entities;

import com.codingame.gameengine.module.entities.Entity;
import com.codingame.gameengine.module.entities.GraphicEntityModule;
import com.codingame.gameengine.module.entities.Mask;
import com.codingame.gameengine.module.entities.TextureBasedEntity;
import com.google.inject.Inject;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SpriteAnimation
extends TextureBasedEntity<SpriteAnimation>
implements Mask {
    @Inject
    GraphicEntityModule entityModule;
    private int RESTART_INDEX = 0;
    private String[] images = new String[0];
    private boolean loop;
    private boolean playing = true;
    private int duration = 1000;

    SpriteAnimation() {
    }

    @Override
    Entity.Type getType() {
        return Entity.Type.SPRITEANIMATION;
    }

    private static void requireValidDuration(int duration) {
        if (duration < 0) {
            throw new IllegalArgumentException("Invalid duration: " + duration + "ms");
        }
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public SpriteAnimation setPlaying(boolean playing) {
        this.playing = playing;
        this.set("playing", playing, null);
        return this;
    }

    public SpriteAnimation reset() {
        this.set("restarted", this.RESTART_INDEX++, null);
        return this;
    }

    public SpriteAnimation play() {
        return this.setPlaying(true);
    }

    public SpriteAnimation pause() {
        return this.setPlaying(false);
    }

    public boolean isLoop() {
        return this.loop;
    }

    public SpriteAnimation setLoop(boolean loop) {
        this.loop = loop;
        this.set("loop", loop, null);
        return this;
    }

    public int getDuration() {
        return this.duration;
    }

    public SpriteAnimation setDuration(int duration) {
        SpriteAnimation.requireValidDuration(duration);
        this.duration = duration;
        this.set("duration", duration, null);
        return this;
    }

    public SpriteAnimation setImages(String ... images) {
        if (images.length == 0) {
            throw new IllegalArgumentException("Animation must contain at least 1 image.");
        }
        this.images = images;
        this.set("images", Stream.of(images).collect(Collectors.joining(",")), null);
        return this;
    }

    public String[] getImages() {
        return this.images;
    }
}

