/*
 * Decompiled with CFR 0.152.
 */
package com.codingame.gameengine.module.entities;

import com.codingame.gameengine.module.entities.GraphicEntityModule;
import com.google.inject.Inject;
import java.util.stream.IntStream;

public class SpriteSheetSplitter {
    private String name;
    private String sourceImage;
    private Integer width;
    private Integer height;
    private Integer origRow;
    private Integer origCol;
    private Integer imageCount;
    private int imagesPerRow = 0;
    private final GraphicEntityModule graphicEntityModule;

    @Inject
    public SpriteSheetSplitter(GraphicEntityModule graphicEntityModule) {
        this.graphicEntityModule = graphicEntityModule;
    }

    public String getName() {
        return this.name;
    }

    public String getSourceImage() {
        return this.sourceImage;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getOrigRow() {
        return this.origRow;
    }

    public int getOrigCol() {
        return this.origCol;
    }

    public int getImageCount() {
        return this.imageCount;
    }

    public int getImagesPerRow() {
        return this.imagesPerRow;
    }

    public SpriteSheetSplitter setName(String name) {
        this.name = name;
        return this;
    }

    public SpriteSheetSplitter setSourceImage(String sourceImage) {
        this.sourceImage = sourceImage;
        return this;
    }

    public SpriteSheetSplitter setWidth(int width) {
        this.width = width;
        return this;
    }

    public SpriteSheetSplitter setHeight(int height) {
        this.height = height;
        return this;
    }

    public SpriteSheetSplitter setOrigRow(int origRow) {
        this.origRow = origRow;
        return this;
    }

    public SpriteSheetSplitter setOrigCol(int origCol) {
        this.origCol = origCol;
        return this;
    }

    public SpriteSheetSplitter setImageCount(int imageCount) {
        this.imageCount = imageCount;
        return this;
    }

    public SpriteSheetSplitter setImagesPerRow(int imagesPerRow) {
        this.imagesPerRow = imagesPerRow;
        return this;
    }

    public String[] split() {
        if (this.name == null) {
            throw new IllegalStateException("invalid name");
        }
        if (this.sourceImage == null) {
            throw new IllegalStateException("invalid sourceImage");
        }
        if (this.width == null || this.width <= 0) {
            throw new IllegalStateException("invalid width");
        }
        if (this.height == null || this.height <= 0) {
            throw new IllegalStateException("invalid height");
        }
        if (this.imageCount == null || this.imageCount <= 0) {
            throw new IllegalStateException("invalid imageCount");
        }
        if (this.origRow == null || this.origRow < 0) {
            throw new IllegalStateException("invalid origRow");
        }
        if (this.origCol == null || this.origCol < 0) {
            throw new IllegalStateException("invalid origCol");
        }
        this.graphicEntityModule.loadSpriteSheetSplitter(this);
        if (this.imageCount > 1) {
            return (String[])IntStream.range(0, this.imageCount).mapToObj(i -> this.name + i).toArray(String[]::new);
        }
        return new String[]{this.name};
    }
}

