/*
 * Decompiled with CFR 0.152.
 */
package com.codingame.gameengine.module.entities;

import com.codingame.gameengine.module.entities.Curve;
import com.codingame.gameengine.module.entities.Entity;
import com.codingame.gameengine.module.entities.TextBasedEntity;

public class Text
extends TextBasedEntity<Text> {
    private int strokeColor = 0;
    private double strokeThickness = 0.0;
    private int fillColor = 0;
    private String fontFamily = "Lato";
    private FontWeight fontWeight = FontWeight.NORMAL;

    Text() {
    }

    @Override
    Entity.Type getType() {
        return Entity.Type.TEXT;
    }

    public int getStrokeColor() {
        return this.strokeColor;
    }

    public Text setStrokeColor(int strokeColor) {
        return this.setStrokeColor(strokeColor, null);
    }

    public Text setStrokeColor(int strokeColor, Curve curve) {
        Text.requireValidColor(strokeColor);
        this.strokeColor = strokeColor;
        this.set("strokeColor", strokeColor, curve);
        return this;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public Text setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
        this.set("fontFamily", fontFamily, null);
        return this;
    }

    public double getStrokeThickness() {
        return this.strokeThickness;
    }

    public Text setStrokeThickness(double strokeThickness) {
        return this.setStrokeThickness(strokeThickness, null);
    }

    public Text setStrokeThickness(double strokeThickness, Curve curve) {
        this.strokeThickness = strokeThickness;
        this.set("strokeThickness", strokeThickness, curve);
        return this;
    }

    public Text setFontWeight(FontWeight weight) {
        this.fontWeight = weight;
        this.set("fontWeight", weight.toString());
        return this;
    }

    public FontWeight getFontWeight() {
        return this.fontWeight;
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public Text setFillColor(int fillColor) {
        return this.setFillColor(fillColor, null);
    }

    public Text setFillColor(int fillColor, Curve curve) {
        this.fillColor = fillColor;
        this.set("fillColor", fillColor, curve);
        return this;
    }

    public static enum FontWeight {
        NORMAL,
        BOLD,
        BOLDER,
        LIGHTER;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

