/*
 * Decompiled with CFR 0.152.
 */
package com.codingame.gameengine.module.entities;

import com.codingame.gameengine.module.entities.Entity;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class ContainerBasedEntity<T extends Entity<?>>
extends Entity<T> {
    private Set<Entity<?>> entities = new HashSet();

    ContainerBasedEntity() {
    }

    public void remove(Entity<?> entity) {
        if (entity.parent == this) {
            entity.parent = null;
            this.entities.remove(entity);
            this.set("children", this.asString(this.entities), null);
        }
    }

    public void add(Entity<?> ... entities) {
        Stream.of(entities).forEach(entity -> {
            if (entity.parent != null) {
                throw new IllegalArgumentException();
            }
            this.entities.add((Entity<?>)entity);
        });
        this.set("children", this.asString(this.entities), null);
    }

    private String asString(Set<Entity<?>> entities) {
        return entities.stream().map(e -> String.valueOf(e.getId())).collect(Collectors.joining(","));
    }
}

