/*
 * Decompiled with CFR 0.152.
 */
package com.codingame.gameengine.module.entities;

import com.codingame.gameengine.core.AbstractPlayer;
import com.codingame.gameengine.core.GameManager;
import com.codingame.gameengine.core.Module;
import com.codingame.gameengine.module.entities.BitmapText;
import com.codingame.gameengine.module.entities.BufferedGroup;
import com.codingame.gameengine.module.entities.Circle;
import com.codingame.gameengine.module.entities.Entity;
import com.codingame.gameengine.module.entities.Group;
import com.codingame.gameengine.module.entities.Line;
import com.codingame.gameengine.module.entities.Polygon;
import com.codingame.gameengine.module.entities.Rectangle;
import com.codingame.gameengine.module.entities.RoundedRectangle;
import com.codingame.gameengine.module.entities.Serializer;
import com.codingame.gameengine.module.entities.Sprite;
import com.codingame.gameengine.module.entities.SpriteAnimation;
import com.codingame.gameengine.module.entities.SpriteSheetSplitter;
import com.codingame.gameengine.module.entities.Text;
import com.codingame.gameengine.module.entities.World;
import com.codingame.gameengine.module.entities.WorldState;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Singleton
public class GraphicEntityModule
implements Module {
    static int ENTITY_COUNT = 0;
    private List<SpriteSheetSplitter> newSpriteSheetSplitters;
    private List<Entity<?>> newEntities;
    private List<Entity<?>> entities;
    private Map<String, WorldState> worldStates;
    private World world;
    private boolean lockWorld;
    private WorldState currentWorldState;
    private GameManager<AbstractPlayer> gameManager;
    @Inject
    private Serializer gameSerializer;
    @Inject
    private Provider<SpriteSheetSplitter> spriteSheetProvider;

    @Inject
    GraphicEntityModule(GameManager<AbstractPlayer> gameManager) {
        this.gameManager = gameManager;
        this.world = new World();
        this.entities = new ArrayList();
        this.newEntities = new ArrayList();
        this.newSpriteSheetSplitters = new ArrayList<SpriteSheetSplitter>();
        this.lockWorld = false;
        this.worldStates = new HashMap<String, WorldState>();
        this.currentWorldState = new WorldState("0");
        gameManager.registerModule((Module)this);
    }

    public World createWorld(int width, int height) {
        if (this.lockWorld) {
            throw new IllegalStateException("World creation must be the first use of this module.");
        }
        this.lockWorld = true;
        this.world = new World(width, height);
        return this.world;
    }

    public World getWorld() {
        return this.world;
    }

    void loadSpriteSheetSplitter(SpriteSheetSplitter spritesheetsplitter) {
        this.newSpriteSheetSplitters.add(spritesheetsplitter);
    }

    public SpriteSheetSplitter createSpriteSheetSplitter() {
        return (SpriteSheetSplitter)this.spriteSheetProvider.get();
    }

    public void commitWorldState(double t) {
        this.commitState(t, true, this.entities.toArray(new Entity[this.entities.size()]));
    }

    public void commitEntityState(double t, Entity<?> ... entities) {
        this.commitState(t, false, entities);
    }

    private void commitState(double t, boolean commitAll, Entity<?> ... entities) {
        GraphicEntityModule.requireValidFrameInstant(t);
        this.requireNonEmpty(entities);
        String actualT = Serializer.formatFrameTime(t);
        WorldState state = this.worldStates.get(actualT);
        if (state == null) {
            state = new WorldState(actualT);
            this.worldStates.put(actualT, state);
        }
        if (commitAll) {
            state.markAsWorldCommit();
        }
        this.flushAllEntityStates(entities, state);
    }

    private void flushAllEntityStates(Entity<?>[] entities, WorldState state) {
        Stream.of(entities).forEach(entity -> state.flushEntityState((Entity<?>)entity));
    }

    private void requireNonEmpty(Object[] items) {
        if (items.length == 0) {
            throw new IllegalArgumentException("Must not be an empty array");
        }
    }

    private static void requireValidFrameInstant(double t) {
        if (t < 0.0 || t > 1.0) {
            throw new IllegalArgumentException("Not a valid frame instant: " + t);
        }
    }

    private void sendFrameData() {
        this.autocommit();
        Optional<String> load = this.gameSerializer.serializeLoadSpriteSheets(this.newSpriteSheetSplitters);
        this.newSpriteSheetSplitters.clear();
        Optional<String> create = this.gameSerializer.serializeCreateEntities(this.newEntities);
        this.newEntities.clear();
        List orderedStates = this.worldStates.entrySet().stream().sorted((e1, e2) -> ((WorldState)e1.getValue()).getFrameTime().compareTo(((WorldState)e2.getValue()).getFrameTime())).map(Map.Entry::getValue).collect(Collectors.toList());
        ArrayList<String> worldCommitsBuilder = new ArrayList<String>();
        ArrayList<WorldState> updateBuilder = new ArrayList<WorldState>();
        for (WorldState nextWorldState : orderedStates) {
            if (nextWorldState.isWorldCommit()) {
                worldCommitsBuilder.add(nextWorldState.getFrameTime());
            }
            WorldState worldStateDiff = nextWorldState.diffFromOtherWorldState(this.currentWorldState);
            updateBuilder.add(worldStateDiff);
            this.currentWorldState.updateAllEntities(nextWorldState);
        }
        Optional<String> worldCommits = this.gameSerializer.serializeWorldCommits(worldCommitsBuilder);
        Optional<String> update = this.gameSerializer.serializeWorldDiff(updateBuilder);
        this.worldStates.clear();
        this.gameManager.setViewData("entitymodule", (Object)Stream.of(load, create, update, worldCommits).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining("\n")));
    }

    private void autocommit() {
        WorldState state = this.worldStates.computeIfAbsent("1", key -> new WorldState("1"));
        state.markAsWorldCommit();
        state.flushMissingEntities(this.entities);
    }

    public Circle createCircle() {
        Circle c = new Circle();
        this.newEntity(c);
        return c;
    }

    public Sprite createSprite() {
        Sprite c = new Sprite();
        this.newEntity(c);
        return c;
    }

    public Line createLine() {
        Line c = new Line();
        this.newEntity(c);
        return c;
    }

    public Rectangle createRectangle() {
        Rectangle c = new Rectangle();
        this.newEntity(c);
        return c;
    }

    public RoundedRectangle createRoundedRectangle() {
        RoundedRectangle c = new RoundedRectangle();
        this.newEntity(c);
        return c;
    }

    public Polygon createPolygon() {
        Polygon c = new Polygon();
        this.newEntity(c);
        return c;
    }

    public Text createText(String string) {
        Text e = new Text();
        e.setText(string);
        this.newEntity(e);
        return e;
    }

    public BitmapText createBitmapText() {
        BitmapText e = new BitmapText();
        this.newEntity(e);
        return e;
    }

    public Group createGroup(Entity<?> ... entities) {
        Group e = new Group();
        this.newEntity(e);
        e.add(entities);
        return e;
    }

    public BufferedGroup createBufferedGroup(Entity<?> ... entities) {
        BufferedGroup e = new BufferedGroup();
        this.newEntity(e);
        e.add(entities);
        return e;
    }

    public SpriteAnimation createSpriteAnimation() {
        SpriteAnimation c = new SpriteAnimation();
        this.newEntity(c);
        return c;
    }

    private void newEntity(Entity<?> e) {
        this.lockWorld = true;
        this.entities.add(e);
        this.newEntities.add(e);
    }

    private void sendGlobalData() {
        this.gameManager.setViewGlobalData("entitymodule", (Object)this.world);
        this.lockWorld = true;
    }

    public final void onGameInit() {
        this.sendGlobalData();
        this.sendFrameData();
    }

    public final void onAfterGameTurn() {
        this.sendFrameData();
    }

    public final void onAfterOnEnd() {
    }
}

