/*
 * Decompiled with CFR 0.152.
 */
package com.codingame.gameengine.module.entities;

import com.codingame.gameengine.module.entities.Curve;
import com.codingame.gameengine.module.entities.Entity;
import com.codingame.gameengine.module.entities.Shape;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Polygon
extends Shape<Polygon> {
    private List<Point> points = new ArrayList<Point>();

    Polygon() {
    }

    public Polygon addPoint(int x, int y) {
        this.points.add(new Point(x, y));
        this.set("points", this.asString(this.points));
        return this;
    }

    public Polygon clearPoints() {
        this.points.clear();
        this.set("points", this.asString(this.points));
        return this;
    }

    public Polygon setPointsInterpolationCurve(Curve curve) {
        this.set("points", this.asString(this.points), curve);
        return this;
    }

    private String asString(List<Point> points) {
        return points.stream().map(p -> p.x + "," + p.y).collect(Collectors.joining(","));
    }

    @Override
    Entity.Type getType() {
        return Entity.Type.POLYGON;
    }

    private static class Point {
        int x;
        int y;

        public Point(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

