/*
 * Decompiled with CFR 0.152.
 */
package com.codingame.gameengine.module.entities;

import com.codingame.gameengine.module.entities.BlendableEntity;
import com.codingame.gameengine.module.entities.Curve;
import com.codingame.gameengine.module.entities.Mask;

public abstract class Shape<T extends BlendableEntity<?>>
extends BlendableEntity<T>
implements Mask {
    private int lineColor = 0;
    private int lineWidth = 0;
    private int fillColor = 0xFFFFFF;
    private double fillAlpha = 1.0;
    private double lineAlpha = 1.0;

    Shape() {
    }

    public T setFillColor(int color) {
        return this.setFillColor(color, null);
    }

    public T setFillColor(int color, Curve curve) {
        Shape.requireValidColor(color);
        this.fillColor = color;
        this.set("fillColor", color, curve);
        return (T)((BlendableEntity)this.self());
    }

    public Integer getFillColor() {
        return this.fillColor;
    }

    public T setFillAlpha(double alpha) {
        return this.setFillAlpha(alpha, null);
    }

    public T setFillAlpha(double alpha, Curve curve) {
        Shape.requireValidAlpha(alpha);
        this.fillAlpha = alpha;
        this.set("fillAlpha", alpha, curve);
        return (T)((BlendableEntity)this.self());
    }

    public double getFillAlpha() {
        return this.fillAlpha;
    }

    public T setLineAlpha(double alpha) {
        return this.setLineAlpha(alpha, null);
    }

    public T setLineAlpha(double alpha, Curve curve) {
        Shape.requireValidAlpha(alpha);
        this.lineAlpha = alpha;
        this.set("lineAlpha", alpha, curve);
        return (T)((BlendableEntity)this.self());
    }

    public double getLineAlpha() {
        return this.lineAlpha;
    }

    public T setLineWidth(int lineWidth) {
        return this.setLineWidth(lineWidth, null);
    }

    public T setLineWidth(int lineWidth, Curve curve) {
        this.lineWidth = lineWidth;
        this.set("lineWidth", lineWidth, curve);
        return (T)((BlendableEntity)this.self());
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public T setLineColor(int lineColor) {
        return this.setLineColor(lineColor, null);
    }

    public T setLineColor(int lineColor, Curve curve) {
        Shape.requireValidColor(lineColor);
        this.lineColor = lineColor;
        this.set("lineColor", lineColor, curve);
        return (T)((BlendableEntity)this.self());
    }

    public int getLineColor() {
        return this.lineColor;
    }
}

