/*
 * Decompiled with CFR 0.152.
 */
package com.codingame.gameengine.module.entities;

import com.codingame.gameengine.module.entities.Curve;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;

class EntityState {
    Map<String, Param> map;

    public EntityState(EntityState other) {
        this.map = new HashMap<String, Param>(other.map);
    }

    EntityState() {
        this.map = new HashMap<String, Param>();
    }

    public void forEach(BiConsumer<? super String, ? super Param> action) {
        this.map.forEach(action);
    }

    public Object put(String key, Param value) {
        return this.map.put(key, value);
    }

    public Param get(String key) {
        return this.map.get(key);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<Map.Entry<String, Param>> entrySet() {
        return this.map.entrySet();
    }

    public void put(String key, Object value, Curve curve) {
        this.map.put(key, new Param(value, curve));
    }

    EntityState diffFromNonNullOtherState(EntityState prevState) {
        EntityState diff = new EntityState();
        this.forEach((key, value) -> {
            Param prevValue = prevState.get((String)key);
            if (!value.equals(prevValue)) {
                diff.put((String)key, (Param)value);
            }
        });
        return diff;
    }

    EntityState diffFromOtherState(Optional<EntityState> optionalPrevState) {
        if (optionalPrevState.isPresent()) {
            return this.diffFromNonNullOtherState(optionalPrevState.get());
        }
        return new EntityState(this);
    }

    static class Param {
        Object value;
        Curve curve;

        public Param(Object value, Curve curve) {
            Objects.requireNonNull(curve);
            this.value = value;
            this.curve = curve;
        }

        public boolean equals(Param other) {
            return other != null && other.value.equals(this.value);
        }
    }
}

