/*
 * Decompiled with CFR 0.152.
 */
package com.codingame.gameengine.module.entities;

import com.codingame.gameengine.module.entities.Curve;
import com.codingame.gameengine.module.entities.Entity;
import com.codingame.gameengine.module.entities.EntityState;
import com.codingame.gameengine.module.entities.SpriteSheetSplitter;
import com.codingame.gameengine.module.entities.WorldState;
import com.google.inject.Singleton;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Singleton
class Serializer {
    public Map<String, String> commands;
    public Map<String, String> keys = new HashMap<String, String>();
    public Map<String, String> separators;
    Map<Entity.Type, String> types;
    Map<Curve, String> curves;
    private static DecimalFormat decimalFormat;

    Serializer() {
        this.keys.put("rotation", "r");
        this.keys.put("radius", "R");
        this.keys.put("x2", "X");
        this.keys.put("y2", "Y");
        this.keys.put("width", "w");
        this.keys.put("height", "h");
        this.keys.put("tint", "t");
        this.keys.put("fillColor", "f");
        this.keys.put("fillAlpha", "F");
        this.keys.put("lineColor", "c");
        this.keys.put("lineWidth", "W");
        this.keys.put("lineAlpha", "A");
        this.keys.put("alpha", "a");
        this.keys.put("image", "i");
        this.keys.put("strokeThickness", "S");
        this.keys.put("strokeColor", "sc");
        this.keys.put("fontFamily", "ff");
        this.keys.put("fontSize", "s");
        this.keys.put("fontWeight", "fw");
        this.keys.put("text", "T");
        this.keys.put("children", "ch");
        this.keys.put("scaleX", "sx");
        this.keys.put("scaleY", "sy");
        this.keys.put("anchorX", "ax");
        this.keys.put("anchorY", "ay");
        this.keys.put("visible", "v");
        this.keys.put("zIndex", "z");
        this.keys.put("blendMode", "b");
        this.keys.put("images", "I");
        this.keys.put("restarted", "rs");
        this.keys.put("playing", "p");
        this.keys.put("loop", "l");
        this.keys.put("duration", "d");
        this.keys.put("baseWidth", "bw");
        this.keys.put("baseHeight", "bh");
        this.keys.put("points", "ps");
        this.keys.put("skewX", "kx");
        this.keys.put("skewY", "ky");
        this.commands = new HashMap<String, String>();
        this.commands.put("CREATE", "C");
        this.commands.put("UPDATE", "U");
        this.commands.put("LOADSPRITESHEET", "L");
        this.separators = new HashMap<String, String>();
        this.separators.put("COMMAND", ";");
        this.separators.put("COMMAND_ARGUMENT", " ");
        this.separators.put("ARGUMENT_DETAILS", ",");
        this.separators.put("COMMAND_TYPE", "\n");
        this.curves = new HashMap<Curve, String>();
        this.curves.put(Curve.NONE, "_");
        this.curves.put(Curve.IMMEDIATE, "\u0393");
        this.curves.put(Curve.LINEAR, "/");
        this.curves.put(Curve.EASE_IN_AND_OUT, "\u222b");
        this.curves.put(Curve.ELASTIC, "~");
        this.types = new HashMap<Entity.Type, String>();
        this.types.put(Entity.Type.RECTANGLE, "R");
        this.types.put(Entity.Type.ROUNDED_RECTANGLE, "K");
        this.types.put(Entity.Type.CIRCLE, "C");
        this.types.put(Entity.Type.GROUP, "G");
        this.types.put(Entity.Type.BUFFERED_GROUP, "B");
        this.types.put(Entity.Type.LINE, "L");
        this.types.put(Entity.Type.SPRITE, "S");
        this.types.put(Entity.Type.TEXT, "T");
        this.types.put(Entity.Type.BITMAPTEXT, "X");
        this.types.put(Entity.Type.SPRITEANIMATION, "A");
        this.types.put(Entity.Type.POLYGON, "P");
        if (this.keys.values().stream().distinct().count() != (long)this.keys.values().size()) {
            throw new RuntimeException("Duplicate keys");
        }
        if (this.commands.values().stream().distinct().count() != (long)this.commands.values().size()) {
            throw new RuntimeException("Duplicate commands");
        }
        if (this.separators.values().stream().distinct().count() != (long)this.separators.values().size()) {
            throw new RuntimeException("Duplicate separators");
        }
        if (this.types.values().stream().distinct().count() != (long)this.types.values().size()) {
            throw new RuntimeException("Duplicate types");
        }
        if (this.curves.values().stream().distinct().count() != (long)this.curves.values().size()) {
            throw new RuntimeException("Duplicate curves");
        }
        if (this.keys.values().stream().anyMatch(character -> this.curves.containsValue(character))) {
            throw new RuntimeException("Same string used for a curve and a property");
        }
        if (this.separators.values().stream().anyMatch(character -> this.curves.containsValue(character) || this.keys.containsValue(character) || this.types.containsValue(character) || this.commands.containsValue(character))) {
            throw new RuntimeException("String already used as separator");
        }
    }

    private static String join(Object ... args) {
        return Stream.of(args).map(String::valueOf).collect(Collectors.joining(" "));
    }

    static String formatFrameTime(double t) {
        return decimalFormat.format(t);
    }

    static String escape(String text) {
        String escaped = text.replaceAll("\\'", "\\\\'");
        if (escaped.contains(" ") || escaped.contains(";")) {
            return "'" + escaped + "'";
        }
        return escaped;
    }

    private String serializeEntitiesStateDiff(Entity<?> entity, EntityState diff, String frameInstant) {
        String meta = Serializer.join(entity.getId(), frameInstant);
        if (diff.isEmpty()) {
            return meta;
        }
        return Serializer.join(meta, this.minifyDiff(diff));
    }

    private String minifyParam(String key, EntityState.Param param) {
        String result = key.equals("rotation") || key.equals("skewX") || key.equals("skewY") ? String.valueOf((int)Math.toDegrees((Double)param.value)) : (param.value instanceof Double ? decimalFormat.format(param.value) : (param.value instanceof Boolean ? ((Boolean)param.value != false ? "1" : "0") : Serializer.escape(param.value.toString())));
        if (param.curve.equals((Object)Curve.DEFAULT)) {
            return result;
        }
        return Serializer.join(result, this.curves.get((Object)param.curve));
    }

    private String minifyKey(String key) {
        return this.keys.getOrDefault(key, key);
    }

    private String minifyDiff(EntityState diff) {
        return diff.entrySet().stream().map(entry -> Serializer.join(this.minifyKey((String)entry.getKey()), this.minifyParam((String)entry.getKey(), (EntityState.Param)entry.getValue()))).collect(Collectors.joining(this.separators.get("COMMAND_ARGUMENT")));
    }

    private String serializeCreateEntity(Entity<?> e) {
        return Serializer.join(this.types.get((Object)e.getType()));
    }

    public Optional<String> serializeCreateEntities(List<Entity<?>> entities) {
        if (entities.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.commands.get("CREATE") + entities.stream().map(e -> this.serializeCreateEntity((Entity<?>)e)).collect(Collectors.joining(this.separators.get("COMMAND"))));
    }

    private String serializeLoadSpriteSheet(SpriteSheetSplitter spriteSheet) {
        return Serializer.join(spriteSheet.getName(), spriteSheet.getSourceImage(), spriteSheet.getWidth(), spriteSheet.getHeight(), spriteSheet.getOrigRow(), spriteSheet.getOrigCol(), spriteSheet.getImageCount(), spriteSheet.getImagesPerRow());
    }

    public Optional<String> serializeLoadSpriteSheets(List<SpriteSheetSplitter> spriteSheets) {
        if (spriteSheets.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.commands.get("LOADSPRITESHEET") + spriteSheets.stream().map(e -> this.serializeLoadSpriteSheet((SpriteSheetSplitter)e)).collect(Collectors.joining(this.separators.get("COMMAND"))));
    }

    public Optional<String> serializeWorldDiff(List<WorldState> diffs) {
        if (diffs.isEmpty()) {
            return Optional.empty();
        }
        List serialized = diffs.stream().map(worldDiff -> {
            Set<Map.Entry<Entity<?>, EntityState>> diff = worldDiff.getEntityStateMap().entrySet();
            Optional<Object> result = diff.isEmpty() ? Optional.empty() : Optional.of(diff.stream().map(e -> this.serializeEntitiesStateDiff((Entity)e.getKey(), (EntityState)e.getValue(), worldDiff.getFrameTime())).collect(Collectors.joining(this.separators.get("COMMAND"))));
            return result;
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (serialized.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.commands.get("UPDATE") + serialized.stream().collect(Collectors.joining(this.separators.get("COMMAND"))));
    }

    static {
        DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols();
        otherSymbols.setDecimalSeparator('.');
        decimalFormat = new DecimalFormat("0.######");
        decimalFormat.setGroupingUsed(false);
        decimalFormat.setDecimalFormatSymbols(otherSymbols);
    }
}

