/*
 * Decompiled with CFR 0.152.
 */
package com.codingame.gameengine.module.entities;

import com.codingame.gameengine.module.entities.Entity;
import com.codingame.gameengine.module.entities.EntityState;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class WorldState {
    private Map<Entity<?>, EntityState> entityStateMap;
    private final String t;
    private boolean worldCommit = false;

    WorldState(String t) {
        this.t = t;
        this.entityStateMap = new HashMap();
    }

    String getFrameTime() {
        return this.t;
    }

    Map<Entity<?>, EntityState> getEntityStateMap() {
        return this.entityStateMap;
    }

    void flushMissingEntities(List<Entity<?>> entities) {
        entities.stream().forEach(entity -> {
            if (!this.entityStateMap.containsKey(entity)) {
                this.entityStateMap.put((Entity<?>)entity, entity.state);
                entity.state = new EntityState();
            }
        });
    }

    void markAsWorldCommit() {
        this.worldCommit = true;
    }

    boolean isWorldCommit() {
        return this.worldCommit;
    }

    private void updateStateMap(EntityState oldState, EntityState currentState, Entity<?> entity) {
        if (oldState == null) {
            this.entityStateMap.put(entity, currentState);
        } else {
            currentState.forEach((key, value) -> oldState.put((String)key, (EntityState.Param)value));
        }
    }

    void flushEntityState(Entity<?> entity) {
        EntityState state = this.entityStateMap.get(entity);
        this.updateStateMap(state, entity.state, entity);
        entity.state = new EntityState();
    }

    void updateAllEntities(WorldState next) {
        next.entityStateMap.forEach((entity, nextState) -> {
            EntityState oldState = this.entityStateMap.get(entity);
            this.updateStateMap(oldState, (EntityState)nextState, (Entity<?>)entity);
        });
    }

    public WorldState diffFromOtherWorldState(WorldState previousWorldState) {
        WorldState worldDiff = new WorldState(this.t);
        this.getEntityStateMap().forEach((entity, nextEntityState) -> {
            Optional<EntityState> prevEntityState = Optional.ofNullable(previousWorldState.getEntityStateMap().get(entity));
            EntityState entitiesDiff = nextEntityState.diffFromOtherState(prevEntityState);
            if (!this.isWorldCommit() || !entitiesDiff.isEmpty()) {
                worldDiff.getEntityStateMap().put((Entity<?>)entity, entitiesDiff);
            }
        });
        return worldDiff;
    }
}

