/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.TestAction;
import com.consol.citrus.TestActor;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.dsl.builder.TestActionBuilder;

public abstract class AbstractTestActionBuilder<T extends TestAction>
implements TestAction,
TestActionBuilder<T> {
    protected T action;

    public AbstractTestActionBuilder(T action) {
        this.action = action;
    }

    public AbstractTestActionBuilder<T> description(String description) {
        this.action.setDescription(description);
        return this;
    }

    @Override
    public T build() {
        return this.action;
    }

    public final void execute(TestContext context) {
        throw new IllegalStateException("Test action builder must not be executed");
    }

    public final boolean isDisabled(TestContext context) {
        return false;
    }

    public final String getName() {
        return this.action.getName();
    }

    public final AbstractTestActionBuilder setName(String name) {
        this.action.setName(name);
        return this;
    }

    public TestActor getActor() {
        return this.action.getActor();
    }

    public final String getDescription() {
        return this.action.getDescription();
    }

    public final AbstractTestActionBuilder setDescription(String description) {
        this.action.setDescription(description);
        return this;
    }
}

