/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.actions.ExecuteSQLQueryAction;
import com.consol.citrus.dsl.builder.AbstractTestActionBuilder;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.util.SqlUtils;
import com.consol.citrus.validation.script.ScriptValidationContext;
import com.consol.citrus.validation.script.sql.SqlResultSetScriptValidator;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.JdbcTemplate;

public class ExecuteSQLQueryBuilder
extends AbstractTestActionBuilder<ExecuteSQLQueryAction> {
    public ExecuteSQLQueryBuilder(ExecuteSQLQueryAction action) {
        super(action);
    }

    public ExecuteSQLQueryBuilder() {
        super(new ExecuteSQLQueryAction());
    }

    public ExecuteSQLQueryBuilder jdbcTemplate(JdbcTemplate jdbcTemplate) {
        ((ExecuteSQLQueryAction)this.action).setJdbcTemplate(jdbcTemplate);
        return this;
    }

    public ExecuteSQLQueryBuilder dataSource(DataSource dataSource) {
        ((ExecuteSQLQueryAction)this.action).setDataSource(dataSource);
        return this;
    }

    public ExecuteSQLQueryBuilder statements(List<String> statements) {
        ((ExecuteSQLQueryAction)this.action).getStatements().addAll(statements);
        return this;
    }

    public ExecuteSQLQueryBuilder statement(String statements) {
        ((ExecuteSQLQueryAction)this.action).getStatements().add(statements);
        return this;
    }

    public ExecuteSQLQueryBuilder sqlResource(Resource sqlResource) {
        this.statements(SqlUtils.createStatementsFromFileResource((Resource)sqlResource));
        return this;
    }

    public ExecuteSQLQueryBuilder sqlResource(String filePath) {
        ((ExecuteSQLQueryAction)this.action).setSqlResourcePath(filePath);
        return this;
    }

    public ExecuteSQLQueryBuilder validate(String column, String ... values) {
        ((ExecuteSQLQueryAction)this.action).getControlResultSet().put(column, Arrays.asList(values));
        return this;
    }

    public ExecuteSQLQueryBuilder validateScript(String script, String type) {
        ScriptValidationContext scriptValidationContext = new ScriptValidationContext(type);
        scriptValidationContext.setValidationScript(script);
        ((ExecuteSQLQueryAction)this.action).setScriptValidationContext(scriptValidationContext);
        return this;
    }

    public ExecuteSQLQueryBuilder validateScript(Resource scriptResource, String type) {
        ScriptValidationContext scriptValidationContext = new ScriptValidationContext(type);
        try {
            scriptValidationContext.setValidationScript(FileUtils.readToString((Resource)scriptResource));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read script resource", (Throwable)e);
        }
        ((ExecuteSQLQueryAction)this.action).setScriptValidationContext(scriptValidationContext);
        return this;
    }

    public ExecuteSQLQueryBuilder groovy(String script) {
        return this.validateScript(script, "groovy");
    }

    public ExecuteSQLQueryBuilder groovy(Resource scriptResource) {
        return this.validateScript(scriptResource, "groovy");
    }

    public ExecuteSQLQueryBuilder extract(String columnName, String variableName) {
        ((ExecuteSQLQueryAction)this.action).getExtractVariables().put(columnName, variableName);
        return this;
    }

    public ExecuteSQLQueryBuilder validator(SqlResultSetScriptValidator validator) {
        ((ExecuteSQLQueryAction)this.action).setValidator(validator);
        return this;
    }
}

