/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.dsl.builder.AbstractTestActionBuilder;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.script.GroovyAction;
import com.consol.citrus.util.FileUtils;
import java.io.IOException;
import org.springframework.core.io.Resource;

public class GroovyActionBuilder
extends AbstractTestActionBuilder<GroovyAction> {
    public GroovyActionBuilder(GroovyAction action) {
        super(action);
    }

    public GroovyActionBuilder() {
        super(new GroovyAction());
    }

    public GroovyActionBuilder script(String script) {
        ((GroovyAction)this.action).setScript(script);
        return this;
    }

    public GroovyActionBuilder script(Resource scriptResource) {
        try {
            ((GroovyAction)this.action).setScript(FileUtils.readToString((Resource)scriptResource));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read script resource file", (Throwable)e);
        }
        return this;
    }

    public GroovyActionBuilder template(String scriptTemplatePath) {
        ((GroovyAction)this.action).setScriptTemplatePath(scriptTemplatePath);
        return this;
    }

    public GroovyActionBuilder template(Resource scriptTemplate) {
        try {
            ((GroovyAction)this.action).setScriptTemplate(FileUtils.readToString((Resource)scriptTemplate));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read script template file", (Throwable)e);
        }
        return this;
    }

    public GroovyActionBuilder skipTemplate() {
        ((GroovyAction)this.action).setUseScriptTemplate(false);
        return this;
    }
}

