/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.TestAction;
import com.consol.citrus.actions.SendMessageAction;
import com.consol.citrus.dsl.actions.DelegatingTestAction;
import com.consol.citrus.dsl.builder.SendMessageBuilder;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.validation.builder.MessageContentBuilder;
import com.consol.citrus.validation.builder.StaticMessageContentBuilder;
import org.springframework.http.HttpMethod;

public class HttpClientRequestActionBuilder
extends SendMessageBuilder<SendMessageAction, HttpClientRequestActionBuilder> {
    private HttpMessage httpMessage = new HttpMessage();

    public HttpClientRequestActionBuilder(DelegatingTestAction<TestAction> delegate, Endpoint httpClient) {
        super(delegate);
        delegate.setDelegate((TestAction)new SendMessageAction());
        this.getAction().setEndpoint(httpClient);
        this.getAction().setMessageBuilder((MessageContentBuilder)new StaticMessageContentBuilder((Message)this.httpMessage));
    }

    public HttpClientRequestActionBuilder(DelegatingTestAction<TestAction> delegate, String httpClientUri) {
        super(delegate);
        delegate.setDelegate((TestAction)new SendMessageAction());
        this.getAction().setEndpointUri(httpClientUri);
        this.getAction().setMessageBuilder((MessageContentBuilder)new StaticMessageContentBuilder((Message)this.httpMessage));
    }

    @Override
    protected void setPayload(String payload) {
        this.httpMessage.setPayload((Object)payload);
    }

    public HttpClientRequestActionBuilder path(String path) {
        this.httpMessage.path(path);
        return this;
    }

    public HttpClientRequestActionBuilder method(HttpMethod method) {
        this.httpMessage.method(method);
        return this;
    }

    public HttpClientRequestActionBuilder uri(String uri) {
        this.httpMessage.uri(uri);
        return this;
    }

    public HttpClientRequestActionBuilder queryParam(String name, String value) {
        this.httpMessage.queryParam(name, value);
        return this;
    }

    public HttpClientRequestActionBuilder version(String version) {
        this.httpMessage.version(version);
        return this;
    }

    public HttpClientRequestActionBuilder contentType(String contentType) {
        this.httpMessage.contentType(contentType);
        return this;
    }

    public HttpClientRequestActionBuilder accept(String accept) {
        this.httpMessage.accept(accept);
        return this;
    }
}

