/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.TestAction;
import com.consol.citrus.actions.ReceiveMessageAction;
import com.consol.citrus.dsl.actions.DelegatingTestAction;
import com.consol.citrus.dsl.builder.ReceiveMessageBuilder;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import org.springframework.http.HttpStatus;

public class HttpClientResponseActionBuilder
extends ReceiveMessageBuilder<ReceiveMessageAction, HttpClientResponseActionBuilder> {
    private HttpMessage httpMessage = new HttpMessage();

    public HttpClientResponseActionBuilder(DelegatingTestAction<TestAction> delegate, Endpoint httpClient) {
        super(delegate);
        delegate.setDelegate((TestAction)new ReceiveMessageAction());
        this.getAction().setEndpoint(httpClient);
        this.message((Message)this.httpMessage);
        this.messageType(MessageType.XML);
    }

    public HttpClientResponseActionBuilder(DelegatingTestAction<TestAction> delegate, String httpClientUri) {
        super(delegate);
        delegate.setDelegate((TestAction)new ReceiveMessageAction());
        this.getAction().setEndpointUri(httpClientUri);
        this.message((Message)this.httpMessage);
        this.messageType(MessageType.XML);
    }

    @Override
    protected void setPayload(String payload) {
        this.httpMessage.setPayload((Object)payload);
    }

    public HttpClientResponseActionBuilder status(HttpStatus status) {
        this.httpMessage.status(status);
        return this;
    }

    public HttpClientResponseActionBuilder statusCode(Integer statusCode) {
        this.httpMessage.statusCode(statusCode);
        return this;
    }

    public HttpClientResponseActionBuilder reasonPhrase(String reasonPhrase) {
        this.httpMessage.reasonPhrase(reasonPhrase);
        return this;
    }

    public HttpClientResponseActionBuilder version(String version) {
        this.httpMessage.version(version);
        return this;
    }

    public HttpClientResponseActionBuilder contentType(String contentType) {
        this.httpMessage.contentType(contentType);
        return this;
    }
}

