/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.TestAction;
import com.consol.citrus.dsl.actions.DelegatingTestAction;
import com.consol.citrus.dsl.builder.AbstractTestActionBuilder;
import com.consol.citrus.dsl.builder.TestActionBuilder;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.selenium.actions.AlertAction;
import com.consol.citrus.selenium.actions.CheckInputAction;
import com.consol.citrus.selenium.actions.ClearBrowserCacheAction;
import com.consol.citrus.selenium.actions.ClickAction;
import com.consol.citrus.selenium.actions.CloseWindowAction;
import com.consol.citrus.selenium.actions.DropDownSelectAction;
import com.consol.citrus.selenium.actions.FindElementAction;
import com.consol.citrus.selenium.actions.GetStoredFileAction;
import com.consol.citrus.selenium.actions.HoverAction;
import com.consol.citrus.selenium.actions.JavaScriptAction;
import com.consol.citrus.selenium.actions.MakeScreenshotAction;
import com.consol.citrus.selenium.actions.NavigateAction;
import com.consol.citrus.selenium.actions.OpenWindowAction;
import com.consol.citrus.selenium.actions.PageAction;
import com.consol.citrus.selenium.actions.SeleniumAction;
import com.consol.citrus.selenium.actions.SeleniumWindowAction;
import com.consol.citrus.selenium.actions.SetInputAction;
import com.consol.citrus.selenium.actions.StartBrowserAction;
import com.consol.citrus.selenium.actions.StopBrowserAction;
import com.consol.citrus.selenium.actions.StoreFileAction;
import com.consol.citrus.selenium.actions.SwitchWindowAction;
import com.consol.citrus.selenium.actions.WaitUntilAction;
import com.consol.citrus.selenium.endpoint.SeleniumBrowser;
import com.consol.citrus.selenium.model.PageValidator;
import com.consol.citrus.selenium.model.WebPage;
import com.consol.citrus.util.FileUtils;
import java.io.IOException;
import java.util.Arrays;
import org.openqa.selenium.By;
import org.springframework.core.io.Resource;

public class SeleniumActionBuilder
extends AbstractTestActionBuilder<DelegatingTestAction<SeleniumAction>> {
    private SeleniumBrowser seleniumBrowser;

    public SeleniumActionBuilder(DelegatingTestAction<SeleniumAction> action) {
        super(action);
    }

    public SeleniumActionBuilder() {
        super(new DelegatingTestAction());
    }

    public SeleniumActionBuilder browser(SeleniumBrowser seleniumBrowser) {
        this.seleniumBrowser = seleniumBrowser;
        return this;
    }

    public SeleniumActionBuilder start() {
        this.action(new StartBrowserAction());
        return this;
    }

    public SeleniumActionBuilder start(SeleniumBrowser seleniumBrowser) {
        this.browser(seleniumBrowser);
        this.action(new StartBrowserAction());
        return this;
    }

    public SeleniumActionBuilder stop() {
        this.action(new StopBrowserAction());
        return this;
    }

    public SeleniumActionBuilder stop(SeleniumBrowser seleniumBrowser) {
        this.browser(seleniumBrowser);
        this.action(new StopBrowserAction());
        return this;
    }

    public AlertActionBuilder alert() {
        AlertAction action = new AlertAction();
        this.action(action);
        return new AlertActionBuilder(action);
    }

    public SeleniumActionBuilder navigate(String page) {
        NavigateAction action = new NavigateAction();
        action.setPage(page);
        this.action(action);
        return this;
    }

    public PageActionBuilder page(WebPage page) {
        PageAction action = new PageAction();
        action.setPage(page);
        this.action(action);
        return new PageActionBuilder(action);
    }

    public PageActionBuilder page(Class<WebPage> pageType) {
        PageAction action = new PageAction();
        action.setType(pageType.getName());
        this.action(action);
        return new PageActionBuilder(action);
    }

    public FindElementActionBuilder find() {
        FindElementAction action = new FindElementAction();
        this.action(action);
        return new FindElementActionBuilder(action);
    }

    public ElementActionBuilder select(String option) {
        DropDownSelectAction action = new DropDownSelectAction();
        action.setOption(option);
        this.action(action);
        return new ElementActionBuilder(this, (FindElementAction)action);
    }

    public ElementActionBuilder select(String ... options) {
        DropDownSelectAction action = new DropDownSelectAction();
        action.setOptions(Arrays.asList(options));
        this.action(action);
        return new ElementActionBuilder(this, (FindElementAction)action);
    }

    public ElementActionBuilder setInput(String value) {
        SetInputAction action = new SetInputAction();
        action.setValue(value);
        this.action(action);
        return new ElementActionBuilder(this, (FindElementAction)action);
    }

    public ElementActionBuilder checkInput(boolean checked) {
        CheckInputAction action = new CheckInputAction();
        action.setChecked(checked);
        this.action(action);
        return new ElementActionBuilder(this, (FindElementAction)action);
    }

    public ElementActionBuilder click() {
        ClickAction action = new ClickAction();
        this.action(action);
        return new ElementActionBuilder(this, (FindElementAction)action);
    }

    public ElementActionBuilder hover() {
        HoverAction action = new HoverAction();
        this.action(action);
        return new ElementActionBuilder(this, (FindElementAction)action);
    }

    public SeleniumActionBuilder clearCache() {
        this.action(new ClearBrowserCacheAction());
        return this;
    }

    public SeleniumActionBuilder screenshot() {
        this.action(new MakeScreenshotAction());
        return this;
    }

    public SeleniumActionBuilder screenshot(String outputDir) {
        MakeScreenshotAction action = new MakeScreenshotAction();
        action.setOutputDir(outputDir);
        this.action(action);
        return this;
    }

    public SeleniumActionBuilder store(String filePath) {
        StoreFileAction action = new StoreFileAction();
        action.setFilePath(filePath);
        this.action(action);
        return this;
    }

    public SeleniumActionBuilder getStored(String fileName) {
        GetStoredFileAction action = new GetStoredFileAction();
        action.setFileName(fileName);
        this.action(action);
        return this;
    }

    public WaitUntilActionBuilder waitUntil() {
        WaitUntilAction action = new WaitUntilAction();
        this.action(action);
        return new WaitUntilActionBuilder(action);
    }

    public JavaScriptActionBuilder javascript(String script) {
        JavaScriptAction action = new JavaScriptAction();
        action.setScript(script);
        this.action(action);
        return new JavaScriptActionBuilder(action);
    }

    public JavaScriptActionBuilder javascript(Resource script) {
        JavaScriptAction action = new JavaScriptAction();
        try {
            action.setScript(FileUtils.readToString((Resource)script));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read script resource", (Throwable)e);
        }
        this.action(action);
        return new JavaScriptActionBuilder(action);
    }

    public WindowActionBuilder open() {
        OpenWindowAction action = new OpenWindowAction();
        this.action(action);
        return new WindowActionBuilder((SeleniumWindowAction)action);
    }

    public WindowActionBuilder close() {
        CloseWindowAction action = new CloseWindowAction();
        this.action(action);
        return new WindowActionBuilder((SeleniumWindowAction)action);
    }

    public WindowActionBuilder focus() {
        SwitchWindowAction action = new SwitchWindowAction();
        this.action(action);
        return new WindowActionBuilder((SeleniumWindowAction)action);
    }

    private <T extends SeleniumAction> T action(T delegate) {
        if (this.seleniumBrowser != null) {
            delegate.setBrowser(this.seleniumBrowser);
        }
        ((DelegatingTestAction)this.action).setDelegate(delegate);
        return delegate;
    }

    public class FindElementActionBuilder
    extends ElementActionBuilder<FindElementAction> {
        private final FindElementAction action;

        public FindElementActionBuilder(FindElementAction action) {
            super(SeleniumActionBuilder.this, action);
            this.action = action;
        }

        public FindElementActionBuilder tagName(String tagName) {
            this.action.setTagName(tagName);
            return this;
        }

        public FindElementActionBuilder text(String text) {
            this.action.setText(text);
            return this;
        }

        public FindElementActionBuilder attribute(String name, String value) {
            this.action.getAttributes().put(name, value);
            return this;
        }

        public FindElementActionBuilder style(String name, String value) {
            this.action.getStyles().put(name, value);
            return this;
        }

        public FindElementActionBuilder enabled(boolean enabled) {
            this.action.setEnabled(enabled);
            return this;
        }

        public FindElementActionBuilder displayed(boolean displayed) {
            this.action.setDisplayed(displayed);
            return this;
        }

        @Override
        public FindElementActionBuilder element(By by) {
            super.element(by);
            return this;
        }

        @Override
        public FindElementActionBuilder element(String property, String propertyValue) {
            super.element(property, propertyValue);
            return this;
        }
    }

    public static class ElementActionBuilder<T extends FindElementAction>
    implements TestActionBuilder {
        private final T action;
        final /* synthetic */ SeleniumActionBuilder this$0;

        public ElementActionBuilder(T action) {
            this.this$0 = this$0;
            this.action = action;
        }

        public ElementActionBuilder element(By by) {
            this.action.setBy(by);
            return this;
        }

        public ElementActionBuilder element(String property, String propertyValue) {
            this.action.setProperty(property);
            this.action.setPropertyValue(propertyValue);
            return this;
        }

        public TestAction build() {
            return this.this$0.build();
        }
    }

    public class WindowActionBuilder
    implements TestActionBuilder {
        private final SeleniumWindowAction action;

        public WindowActionBuilder(SeleniumWindowAction action) {
            this.action = action;
        }

        public WindowActionBuilder window(String name) {
            this.action.setWindowName(name);
            return this;
        }

        public TestAction build() {
            return SeleniumActionBuilder.this.build();
        }
    }

    public class WaitUntilActionBuilder
    extends ElementActionBuilder<WaitUntilAction> {
        private final WaitUntilAction action;

        public WaitUntilActionBuilder(WaitUntilAction action) {
            super(SeleniumActionBuilder.this, (FindElementAction)action);
            this.action = action;
        }

        public WaitUntilActionBuilder visible() {
            this.action.setCondition("visible");
            return this;
        }

        public WaitUntilActionBuilder hidden() {
            this.action.setCondition("hidden");
            return this;
        }

        public WaitUntilActionBuilder timeout(Long timeout) {
            this.action.setTimeout(timeout);
            return this;
        }

        @Override
        public WaitUntilActionBuilder element(By by) {
            super.element(by);
            return this;
        }

        @Override
        public WaitUntilActionBuilder element(String property, String propertyValue) {
            super.element(property, propertyValue);
            return this;
        }
    }

    public class JavaScriptActionBuilder
    implements TestActionBuilder {
        private final JavaScriptAction action;

        public JavaScriptActionBuilder(JavaScriptAction action) {
            this.action = action;
        }

        public JavaScriptActionBuilder argument(Object arg) {
            this.action.getArguments().add(arg);
            return this;
        }

        public JavaScriptActionBuilder errors(String ... errors) {
            this.action.setExpectedErrors(Arrays.asList(errors));
            return this;
        }

        public TestAction build() {
            return SeleniumActionBuilder.this.build();
        }
    }

    public class PageActionBuilder
    implements TestActionBuilder {
        private final PageAction action;

        public PageActionBuilder(PageAction action) {
            this.action = action;
        }

        public PageActionBuilder validate() {
            this.action.setAction("validate");
            return this;
        }

        public PageActionBuilder validator(PageValidator validator) {
            this.action.setValidator(validator);
            return this;
        }

        public PageActionBuilder execute(String method) {
            this.action.setAction(method);
            return this;
        }

        public PageActionBuilder argument(String arg) {
            this.action.getArguments().add(arg);
            return this;
        }

        public PageActionBuilder arguments(String ... args) {
            this.action.setArguments(Arrays.asList(args));
            return this;
        }

        public TestAction build() {
            return SeleniumActionBuilder.this.build();
        }
    }

    public class AlertActionBuilder
    implements TestActionBuilder {
        private final AlertAction action;

        public AlertActionBuilder(AlertAction action) {
            this.action = action;
        }

        public AlertActionBuilder text(String text) {
            this.action.setText(text);
            return this;
        }

        public AlertActionBuilder accept() {
            this.action.setAccept(true);
            return this;
        }

        public AlertActionBuilder dismiss() {
            this.action.setAccept(false);
            return this;
        }

        public TestAction build() {
            return SeleniumActionBuilder.this.build();
        }
    }
}

