/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.Citrus;
import com.consol.citrus.TestAction;
import com.consol.citrus.actions.SendMessageAction;
import com.consol.citrus.dsl.actions.DelegatingTestAction;
import com.consol.citrus.dsl.builder.AbstractTestActionBuilder;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.validation.builder.AbstractMessageContentBuilder;
import com.consol.citrus.validation.builder.MessageContentBuilder;
import com.consol.citrus.validation.builder.PayloadTemplateMessageBuilder;
import com.consol.citrus.validation.builder.StaticMessageContentBuilder;
import com.consol.citrus.validation.interceptor.MessageConstructionInterceptor;
import com.consol.citrus.validation.json.JsonPathMessageConstructionInterceptor;
import com.consol.citrus.validation.json.JsonPathMessageValidationContext;
import com.consol.citrus.validation.json.JsonPathVariableExtractor;
import com.consol.citrus.validation.xml.XpathMessageConstructionInterceptor;
import com.consol.citrus.validation.xml.XpathPayloadVariableExtractor;
import com.consol.citrus.variable.MessageHeaderVariableExtractor;
import com.consol.citrus.variable.dictionary.DataDictionary;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import javax.xml.transform.Result;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.XmlMappingException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.xml.transform.StringResult;

public class SendMessageBuilder<A extends SendMessageAction, T extends SendMessageBuilder>
extends AbstractTestActionBuilder<DelegatingTestAction<TestAction>> {
    private final T self;
    private String messageType = Citrus.DEFAULT_MESSAGE_TYPE;
    private MessageHeaderVariableExtractor headerExtractor;
    private XpathPayloadVariableExtractor xpathExtractor;
    private JsonPathVariableExtractor jsonPathExtractor;
    private XpathMessageConstructionInterceptor xpathMessageConstructionInterceptor;
    private JsonPathMessageConstructionInterceptor jsonPathMessageConstructionInterceptor;
    private ApplicationContext applicationContext;

    public SendMessageBuilder(A action) {
        this(new DelegatingTestAction<TestAction>((TestAction)action));
    }

    public SendMessageBuilder() {
        this(new SendMessageAction());
    }

    public SendMessageBuilder(DelegatingTestAction<TestAction> action) {
        super(action);
        this.self = this;
    }

    public SendMessageBuilder endpoint(Endpoint messageEndpoint) {
        this.getAction().setEndpoint(messageEndpoint);
        return this;
    }

    public SendMessageBuilder endpoint(String messageEndpointUri) {
        this.getAction().setEndpointUri(messageEndpointUri);
        return this;
    }

    public T fork(boolean forkMode) {
        this.getAction().setForkMode(forkMode);
        return this.self;
    }

    public T message(Message message) {
        StaticMessageContentBuilder staticMessageContentBuilder = StaticMessageContentBuilder.withMessage((Message)message);
        staticMessageContentBuilder.setMessageHeaders(this.getMessageContentBuilder().getMessageHeaders());
        this.getAction().setMessageBuilder((MessageContentBuilder)staticMessageContentBuilder);
        return this.self;
    }

    protected void setPayload(String payload) {
        AbstractMessageContentBuilder messageContentBuilder = this.getMessageContentBuilder();
        if (messageContentBuilder instanceof PayloadTemplateMessageBuilder) {
            ((PayloadTemplateMessageBuilder)messageContentBuilder).setPayloadData(payload);
        } else if (messageContentBuilder instanceof StaticMessageContentBuilder) {
            ((StaticMessageContentBuilder)messageContentBuilder).getMessage().setPayload((Object)payload);
        } else {
            throw new CitrusRuntimeException("Unable to set payload on message builder type: " + messageContentBuilder.getClass());
        }
    }

    public T name(String name) {
        this.getMessageContentBuilder().setMessageName(name);
        return this.self;
    }

    public T payload(String payload) {
        this.setPayload(payload);
        return this.self;
    }

    public T payload(Resource payloadResource) {
        try {
            this.setPayload(FileUtils.readToString((Resource)payloadResource));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read payload resource", (Throwable)e);
        }
        return this.self;
    }

    public T payload(Object payload, Marshaller marshaller) {
        StringResult result = new StringResult();
        try {
            marshaller.marshal(payload, (Result)result);
        }
        catch (XmlMappingException e) {
            throw new CitrusRuntimeException("Failed to marshal object graph for message payload", (Throwable)e);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to marshal object graph for message payload", (Throwable)e);
        }
        this.setPayload(result.toString());
        return this.self;
    }

    public T payload(Object payload, ObjectMapper objectMapper) {
        try {
            this.setPayload(objectMapper.writer().writeValueAsString(payload));
        }
        catch (JsonProcessingException e) {
            throw new CitrusRuntimeException("Failed to map object graph for message payload", (Throwable)e);
        }
        return this.self;
    }

    public T payloadModel(Object payload) {
        Assert.notNull((Object)this.applicationContext, (String)"Citrus application context is not initialized!");
        if (!CollectionUtils.isEmpty((Map)this.applicationContext.getBeansOfType(Marshaller.class))) {
            return this.payload(payload, (Marshaller)this.applicationContext.getBean(Marshaller.class));
        }
        if (!CollectionUtils.isEmpty((Map)this.applicationContext.getBeansOfType(ObjectMapper.class))) {
            return this.payload(payload, (ObjectMapper)this.applicationContext.getBean(ObjectMapper.class));
        }
        throw new CitrusRuntimeException("Unable to find default object mapper or marshaller in application context");
    }

    public T payload(Object payload, String mapperName) {
        Assert.notNull((Object)this.applicationContext, (String)"Citrus application context is not initialized!");
        if (this.applicationContext.containsBean(mapperName)) {
            Object mapper = this.applicationContext.getBean(mapperName);
            if (Marshaller.class.isAssignableFrom(mapper.getClass())) {
                return this.payload(payload, (Marshaller)mapper);
            }
            if (ObjectMapper.class.isAssignableFrom(mapper.getClass())) {
                return this.payload(payload, (ObjectMapper)mapper);
            }
            throw new CitrusRuntimeException(String.format("Invalid bean type for mapper '%s' expected ObjectMapper or Marshaller but was '%s'", mapperName, mapper.getClass()));
        }
        throw new CitrusRuntimeException("Unable to find default object mapper or marshaller in application context");
    }

    public T header(String name, Object value) {
        this.getMessageContentBuilder().getMessageHeaders().put(name, value);
        return this.self;
    }

    public T header(String data) {
        this.getMessageContentBuilder().getHeaderData().add(data);
        return this.self;
    }

    public T header(Resource resource) {
        try {
            this.getMessageContentBuilder().getHeaderData().add(FileUtils.readToString((Resource)resource));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read header resource", (Throwable)e);
        }
        return this.self;
    }

    public T messageType(MessageType messageType) {
        this.messageType(messageType.name());
        return this.self;
    }

    public T messageType(String messageType) {
        this.messageType = messageType;
        this.getAction().setMessageType(messageType);
        return this.self;
    }

    protected AbstractMessageContentBuilder getMessageContentBuilder() {
        if (this.getAction().getMessageBuilder() != null && this.getAction().getMessageBuilder() instanceof AbstractMessageContentBuilder) {
            return (AbstractMessageContentBuilder)this.getAction().getMessageBuilder();
        }
        PayloadTemplateMessageBuilder messageBuilder = new PayloadTemplateMessageBuilder();
        this.getAction().setMessageBuilder((MessageContentBuilder)messageBuilder);
        return messageBuilder;
    }

    public T extractFromHeader(String headerName, String variable) {
        if (this.headerExtractor == null) {
            this.headerExtractor = new MessageHeaderVariableExtractor();
            this.getAction().getVariableExtractors().add(this.headerExtractor);
        }
        this.headerExtractor.getHeaderMappings().put(headerName, variable);
        return this.self;
    }

    public T extractFromPayload(String path, String variable) {
        if (JsonPathMessageValidationContext.isJsonPathExpression((String)path)) {
            this.getJsonPathVariableExtractor().getJsonPathExpressions().put(path, variable);
        } else {
            this.getXpathVariableExtractor().getXpathExpressions().put(path, variable);
        }
        return this.self;
    }

    public T xpath(String expression, String value) {
        if (this.xpathMessageConstructionInterceptor == null) {
            this.xpathMessageConstructionInterceptor = new XpathMessageConstructionInterceptor();
            if (this.getAction().getMessageBuilder() != null) {
                this.getAction().getMessageBuilder().add((MessageConstructionInterceptor)this.xpathMessageConstructionInterceptor);
            } else {
                PayloadTemplateMessageBuilder messageBuilder = new PayloadTemplateMessageBuilder();
                messageBuilder.getMessageInterceptors().add(this.xpathMessageConstructionInterceptor);
                this.getAction().setMessageBuilder((MessageContentBuilder)messageBuilder);
            }
        }
        this.xpathMessageConstructionInterceptor.getXPathExpressions().put(expression, value);
        return this.self;
    }

    public T jsonPath(String expression, String value) {
        if (this.jsonPathMessageConstructionInterceptor == null) {
            this.jsonPathMessageConstructionInterceptor = new JsonPathMessageConstructionInterceptor();
            if (this.getAction().getMessageBuilder() != null) {
                this.getAction().getMessageBuilder().add((MessageConstructionInterceptor)this.jsonPathMessageConstructionInterceptor);
            } else {
                PayloadTemplateMessageBuilder messageBuilder = new PayloadTemplateMessageBuilder();
                messageBuilder.getMessageInterceptors().add(this.jsonPathMessageConstructionInterceptor);
                this.getAction().setMessageBuilder((MessageContentBuilder)messageBuilder);
            }
        }
        this.jsonPathMessageConstructionInterceptor.getJsonPathExpressions().put(expression, value);
        return this.self;
    }

    private XpathPayloadVariableExtractor getXpathVariableExtractor() {
        if (this.xpathExtractor == null) {
            this.xpathExtractor = new XpathPayloadVariableExtractor();
            this.getAction().getVariableExtractors().add(this.xpathExtractor);
        }
        return this.xpathExtractor;
    }

    private JsonPathVariableExtractor getJsonPathVariableExtractor() {
        if (this.jsonPathExtractor == null) {
            this.jsonPathExtractor = new JsonPathVariableExtractor();
            this.getAction().getVariableExtractors().add(this.jsonPathExtractor);
        }
        return this.jsonPathExtractor;
    }

    public T withApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        return this.self;
    }

    public T dictionary(DataDictionary dictionary) {
        this.getAction().setDataDictionary(dictionary);
        return this.self;
    }

    public T dictionary(String dictionaryName) {
        Assert.notNull((Object)this.applicationContext, (String)"Citrus application context is not initialized!");
        DataDictionary dictionary = (DataDictionary)this.applicationContext.getBean(dictionaryName, DataDictionary.class);
        this.getAction().setDataDictionary(dictionary);
        return this.self;
    }

    protected SendMessageAction getAction() {
        return (SendMessageAction)((DelegatingTestAction)this.action).getDelegate();
    }
}

