/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.TestAction;
import com.consol.citrus.dsl.actions.DelegatingTestAction;
import com.consol.citrus.dsl.builder.AbstractTestActionBuilder;
import com.consol.citrus.dsl.builder.SoapClientActionBuilder;
import com.consol.citrus.dsl.builder.SoapServerActionBuilder;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.ws.client.WebServiceClient;
import com.consol.citrus.ws.server.WebServiceServer;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public class SoapActionBuilder
extends AbstractTestActionBuilder<DelegatingTestAction<TestAction>> {
    private ApplicationContext applicationContext;

    public SoapActionBuilder() {
        super(new DelegatingTestAction());
    }

    public SoapClientActionBuilder client(WebServiceClient soapClient) {
        SoapClientActionBuilder clientAction = new SoapClientActionBuilder((DelegatingTestAction<TestAction>)((DelegatingTestAction)this.action), (Endpoint)soapClient).withApplicationContext(this.applicationContext);
        return clientAction;
    }

    public SoapClientActionBuilder client(String soapClient) {
        SoapClientActionBuilder clientAction = new SoapClientActionBuilder((DelegatingTestAction<TestAction>)((DelegatingTestAction)this.action), soapClient).withApplicationContext(this.applicationContext);
        return clientAction;
    }

    public SoapServerActionBuilder server(WebServiceServer soapServer) {
        SoapServerActionBuilder serverAction = new SoapServerActionBuilder((DelegatingTestAction)this.action, (Endpoint)soapServer).withApplicationContext(this.applicationContext);
        return serverAction;
    }

    public SoapServerActionBuilder server(String soapServer) {
        Assert.notNull((Object)this.applicationContext, (String)"Citrus application context is not initialized!");
        SoapServerActionBuilder serverAction = new SoapServerActionBuilder((DelegatingTestAction)this.action, (Endpoint)this.applicationContext.getBean(soapServer, Endpoint.class)).withApplicationContext(this.applicationContext);
        return serverAction;
    }

    public SoapActionBuilder withApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        return this;
    }
}

