/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.TestAction;
import com.consol.citrus.dsl.actions.DelegatingTestAction;
import com.consol.citrus.dsl.builder.SendMessageBuilder;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.validation.builder.MessageContentBuilder;
import com.consol.citrus.validation.builder.StaticMessageContentBuilder;
import com.consol.citrus.ws.actions.SendSoapMessageAction;
import com.consol.citrus.ws.message.SoapAttachment;
import com.consol.citrus.ws.message.SoapMessage;
import java.io.IOException;
import org.springframework.core.io.Resource;

public class SoapClientRequestActionBuilder
extends SendMessageBuilder<SendSoapMessageAction, SoapClientRequestActionBuilder> {
    private SoapMessage soapMessage = new SoapMessage();

    public SoapClientRequestActionBuilder(DelegatingTestAction<TestAction> delegate, Endpoint soapClient) {
        super(delegate);
        delegate.setDelegate((TestAction)new SendSoapMessageAction());
        this.getAction().setEndpoint(soapClient);
        this.getAction().setMessageBuilder((MessageContentBuilder)new StaticMessageContentBuilder((Message)this.soapMessage));
    }

    public SoapClientRequestActionBuilder(DelegatingTestAction<TestAction> delegate, String soapClientUri) {
        super(delegate);
        delegate.setDelegate((TestAction)new SendSoapMessageAction());
        this.getAction().setEndpointUri(soapClientUri);
        this.getAction().setMessageBuilder((MessageContentBuilder)new StaticMessageContentBuilder((Message)this.soapMessage));
    }

    @Override
    protected void setPayload(String payload) {
        this.soapMessage.setPayload((Object)payload);
    }

    public SoapClientRequestActionBuilder soapAction(String soapAction) {
        this.soapMessage.header("citrus_soap_action", (Object)soapAction);
        return this;
    }

    public SoapClientRequestActionBuilder attachment(String contentId, String contentType, String content) {
        SoapAttachment attachment = new SoapAttachment();
        attachment.setContentId(contentId);
        attachment.setContentType(contentType);
        attachment.setContent(content);
        this.getAction().getAttachments().add(attachment);
        return this;
    }

    public SoapClientRequestActionBuilder attachment(String contentId, String contentType, Resource contentResource) {
        SoapAttachment attachment = new SoapAttachment();
        attachment.setContentId(contentId);
        attachment.setContentType(contentType);
        try {
            attachment.setContent(FileUtils.readToString((Resource)contentResource));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read attachment resource", (Throwable)e);
        }
        this.getAction().getAttachments().add(attachment);
        return this;
    }

    public SoapClientRequestActionBuilder charset(String charsetName) {
        if (!this.getAction().getAttachments().isEmpty()) {
            ((SoapAttachment)this.getAction().getAttachments().get(this.getAction().getAttachments().size() - 1)).setCharsetName(charsetName);
        }
        return this;
    }

    public SoapClientRequestActionBuilder attachment(SoapAttachment attachment) {
        this.getAction().getAttachments().add(attachment);
        return this;
    }

    public SoapClientRequestActionBuilder uri(String uri) {
        this.soapMessage.header("citrus_endpoint_uri", (Object)uri);
        return this;
    }

    public SoapClientRequestActionBuilder contentType(String contentType) {
        this.soapMessage.header("citrus_http_Content-Type", (Object)contentType);
        return this;
    }

    public SoapClientRequestActionBuilder accept(String accept) {
        this.soapMessage.header("citrus_http_Accept", (Object)accept);
        return this;
    }

    protected SendSoapMessageAction getAction() {
        return (SendSoapMessageAction)super.getAction();
    }
}

