/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.TestAction;
import com.consol.citrus.dsl.actions.DelegatingTestAction;
import com.consol.citrus.dsl.builder.ReceiveMessageBuilder;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.ws.actions.ReceiveSoapMessageAction;
import com.consol.citrus.ws.message.SoapAttachment;
import com.consol.citrus.ws.message.SoapMessage;
import com.consol.citrus.ws.validation.SoapAttachmentValidator;
import java.io.IOException;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;

public class SoapClientResponseActionBuilder
extends ReceiveMessageBuilder<ReceiveSoapMessageAction, SoapClientResponseActionBuilder> {
    private SoapMessage soapMessage = new SoapMessage();

    public SoapClientResponseActionBuilder(DelegatingTestAction<TestAction> delegate, Endpoint soapClient) {
        super(delegate);
        delegate.setDelegate((TestAction)new ReceiveSoapMessageAction());
        this.getAction().setEndpoint(soapClient);
        this.message((Message)this.soapMessage);
        this.messageType(MessageType.XML);
    }

    public SoapClientResponseActionBuilder(DelegatingTestAction<TestAction> delegate, String soapClientUri) {
        super(delegate);
        delegate.setDelegate((TestAction)new ReceiveSoapMessageAction());
        this.getAction().setEndpointUri(soapClientUri);
        this.message((Message)this.soapMessage);
        this.messageType(MessageType.XML);
    }

    @Override
    protected void setPayload(String payload) {
        this.soapMessage.setPayload((Object)payload);
    }

    public SoapClientResponseActionBuilder attachment(String contentId, String contentType, String content) {
        SoapAttachment attachment = new SoapAttachment();
        attachment.setContentId(contentId);
        attachment.setContentType(contentType);
        attachment.setContent(content);
        this.getAction().getAttachments().add(attachment);
        return this;
    }

    public SoapClientResponseActionBuilder attachment(String contentId, String contentType, Resource contentResource) {
        SoapAttachment attachment = new SoapAttachment();
        attachment.setContentId(contentId);
        attachment.setContentType(contentType);
        try {
            attachment.setContent(FileUtils.readToString((Resource)contentResource));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read attachment content resource", (Throwable)e);
        }
        this.getAction().getAttachments().add(attachment);
        return this;
    }

    public SoapClientResponseActionBuilder charset(String charsetName) {
        if (!this.getAction().getAttachments().isEmpty()) {
            ((SoapAttachment)this.getAction().getAttachments().get(this.getAction().getAttachments().size() - 1)).setCharsetName(charsetName);
        }
        return this;
    }

    public SoapClientResponseActionBuilder attachment(SoapAttachment attachment) {
        this.getAction().getAttachments().add(attachment);
        return this;
    }

    public SoapClientResponseActionBuilder attachmentValidator(SoapAttachmentValidator validator) {
        this.getAction().setAttachmentValidator(validator);
        return this;
    }

    public SoapClientResponseActionBuilder status(HttpStatus status) {
        this.soapMessage.header("citrus_http_status_code", (Object)status.value());
        return this;
    }

    public SoapClientResponseActionBuilder statusCode(Integer statusCode) {
        this.soapMessage.header("citrus_http_status_code", (Object)statusCode);
        return this;
    }

    public SoapClientResponseActionBuilder contextPath(String contextPath) {
        this.soapMessage.header("citrus_http_context_path", (Object)contextPath);
        return this;
    }

    public SoapClientResponseActionBuilder contentType(String contentType) {
        this.soapMessage.header("citrus_http_Content-Type", (Object)contentType);
        return this;
    }

    protected ReceiveSoapMessageAction getAction() {
        return (ReceiveSoapMessageAction)super.getAction();
    }
}

