/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.actions.WaitAction;
import com.consol.citrus.condition.Condition;
import com.consol.citrus.condition.HttpCondition;
import com.consol.citrus.dsl.builder.WaitConditionBuilder;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class WaitHttpConditionBuilder
extends WaitConditionBuilder {
    private final HttpCondition condition;

    public WaitHttpConditionBuilder(WaitAction action, HttpCondition condition) {
        super(action, (Condition)condition);
        this.condition = condition;
    }

    public WaitHttpConditionBuilder timeout(String timeout) {
        this.condition.setTimeout(timeout);
        return this;
    }

    public WaitHttpConditionBuilder timeout(Long timeout) {
        this.condition.setTimeout(timeout.toString());
        return this;
    }

    public WaitHttpConditionBuilder status(HttpStatus status) {
        this.condition.setHttpResponseCode(String.valueOf(status.value()));
        return this;
    }

    public WaitHttpConditionBuilder method(HttpMethod method) {
        this.condition.setMethod(method.name());
        return this;
    }
}

