/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.dsl.builder.AbstractTestActionBuilder;
import com.consol.citrus.validation.json.JsonPathMessageValidationContext;
import com.consol.citrus.validation.json.JsonPathVariableExtractor;
import com.consol.citrus.variable.VariableExtractor;
import com.consol.citrus.zookeeper.actions.ZooExecuteAction;
import com.consol.citrus.zookeeper.client.ZooClient;
import com.consol.citrus.zookeeper.command.Create;
import com.consol.citrus.zookeeper.command.Delete;
import com.consol.citrus.zookeeper.command.Exists;
import com.consol.citrus.zookeeper.command.GetChildren;
import com.consol.citrus.zookeeper.command.GetData;
import com.consol.citrus.zookeeper.command.Info;
import com.consol.citrus.zookeeper.command.SetData;
import com.consol.citrus.zookeeper.command.ZooCommand;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import org.springframework.context.ApplicationContext;

public class ZooActionBuilder
extends AbstractTestActionBuilder<ZooExecuteAction> {
    public static final String DEFAULT_MODE = "EPHEMERAL";
    public static final String DEFAULT_ACL = "OPEN_ACL_UNSAFE";
    public static final int DEFAULT_VERSION = 0;
    private ApplicationContext applicationContext;

    public ZooActionBuilder(ZooExecuteAction action) {
        super(action);
    }

    public ZooActionBuilder() {
        super(new ZooExecuteAction());
    }

    public ZooActionBuilder client(ZooClient zooClient) {
        ((ZooExecuteAction)this.action).setZookeeperClient(zooClient);
        return this;
    }

    public Create create(String path, String data) {
        Create command = new Create();
        command.path(path);
        command.data(data);
        command.mode(DEFAULT_MODE);
        command.acl(DEFAULT_ACL);
        ((ZooExecuteAction)this.action).setCommand((ZooCommand)command);
        return command;
    }

    public Delete delete(String path) {
        Delete command = new Delete();
        command.path(path);
        command.version(0);
        ((ZooExecuteAction)this.action).setCommand((ZooCommand)command);
        return command;
    }

    public Exists exists(String path) {
        Exists command = new Exists();
        command.path(path);
        ((ZooExecuteAction)this.action).setCommand((ZooCommand)command);
        return command;
    }

    public GetChildren children(String path) {
        GetChildren command = new GetChildren();
        command.path(path);
        ((ZooExecuteAction)this.action).setCommand((ZooCommand)command);
        return command;
    }

    public GetData get(String path) {
        GetData command = new GetData();
        command.path(path);
        ((ZooExecuteAction)this.action).setCommand((ZooCommand)command);
        return command;
    }

    public Info info() {
        Info command = new Info();
        ((ZooExecuteAction)this.action).setCommand((ZooCommand)command);
        return command;
    }

    public SetData set(String path, String data) {
        SetData command = new SetData();
        command.path(path);
        command.data(data);
        command.version(0);
        ((ZooExecuteAction)this.action).setCommand((ZooCommand)command);
        return command;
    }

    public ZooActionBuilder result(String result) {
        ((ZooExecuteAction)this.action).setExpectedCommandResult(result);
        return this;
    }

    public ZooActionBuilder extract(String jsonPath, String variableName) {
        JsonPathVariableExtractor jsonPathVariableExtractor = new JsonPathVariableExtractor();
        HashMap<String, String> pathVariableMap = new HashMap<String, String>();
        pathVariableMap.put(jsonPath, variableName);
        jsonPathVariableExtractor.setJsonPathExpressions(pathVariableMap);
        ((ZooExecuteAction)this.action).addVariableExtractors((VariableExtractor)jsonPathVariableExtractor);
        return this;
    }

    public ZooActionBuilder validate(String jsonPath, String expectedValue) {
        JsonPathMessageValidationContext validationContext = ((ZooExecuteAction)this.action).getJsonPathMessageValidationContext();
        if (validationContext == null) {
            validationContext = new JsonPathMessageValidationContext();
            ((ZooExecuteAction)this.action).setJsonPathMessageValidationContext(validationContext);
        }
        validationContext.getJsonPathExpressions().put(jsonPath, expectedValue);
        return this;
    }

    public ZooActionBuilder withApplicationContext(ApplicationContext ctx) {
        this.applicationContext = ctx;
        if (this.applicationContext.containsBean("zookeeperClient")) {
            ((ZooExecuteAction)this.action).setZookeeperClient((ZooClient)this.applicationContext.getBean("zookeeperClient", ZooClient.class));
        }
        if (this.applicationContext.containsBean("zookeeperCommandResultMapper")) {
            ((ZooExecuteAction)this.action).setJsonMapper((ObjectMapper)this.applicationContext.getBean("zookeeperCommandResultMapper", ObjectMapper.class));
        }
        return this;
    }
}

