/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.design;

import com.consol.citrus.TestAction;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestCaseMetaInfo;
import com.consol.citrus.actions.AntRunAction;
import com.consol.citrus.actions.CreateVariablesAction;
import com.consol.citrus.actions.EchoAction;
import com.consol.citrus.actions.ExecutePLSQLAction;
import com.consol.citrus.actions.ExecuteSQLAction;
import com.consol.citrus.actions.ExecuteSQLQueryAction;
import com.consol.citrus.actions.FailAction;
import com.consol.citrus.actions.JavaAction;
import com.consol.citrus.actions.LoadPropertiesAction;
import com.consol.citrus.actions.ReceiveMessageAction;
import com.consol.citrus.actions.ReceiveTimeoutAction;
import com.consol.citrus.actions.SendMessageAction;
import com.consol.citrus.actions.SleepAction;
import com.consol.citrus.actions.StartServerAction;
import com.consol.citrus.actions.StopServerAction;
import com.consol.citrus.actions.StopTimeAction;
import com.consol.citrus.actions.StopTimerAction;
import com.consol.citrus.actions.TraceVariablesAction;
import com.consol.citrus.actions.WaitAction;
import com.consol.citrus.container.AbstractActionContainer;
import com.consol.citrus.container.SequenceAfterTest;
import com.consol.citrus.container.SequenceBeforeTest;
import com.consol.citrus.container.Template;
import com.consol.citrus.container.TestActionContainer;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.dsl.actions.DelegatingTestAction;
import com.consol.citrus.dsl.builder.AbstractTestContainerBuilder;
import com.consol.citrus.dsl.builder.AntRunBuilder;
import com.consol.citrus.dsl.builder.AssertExceptionBuilder;
import com.consol.citrus.dsl.builder.AssertSoapFaultBuilder;
import com.consol.citrus.dsl.builder.CamelRouteActionBuilder;
import com.consol.citrus.dsl.builder.CatchExceptionBuilder;
import com.consol.citrus.dsl.builder.ConditionalBuilder;
import com.consol.citrus.dsl.builder.DockerActionBuilder;
import com.consol.citrus.dsl.builder.ExecutePLSQLBuilder;
import com.consol.citrus.dsl.builder.ExecuteSQLBuilder;
import com.consol.citrus.dsl.builder.ExecuteSQLQueryBuilder;
import com.consol.citrus.dsl.builder.FinallySequenceBuilder;
import com.consol.citrus.dsl.builder.GroovyActionBuilder;
import com.consol.citrus.dsl.builder.HttpActionBuilder;
import com.consol.citrus.dsl.builder.InputActionBuilder;
import com.consol.citrus.dsl.builder.IterateBuilder;
import com.consol.citrus.dsl.builder.JavaActionBuilder;
import com.consol.citrus.dsl.builder.KubernetesActionBuilder;
import com.consol.citrus.dsl.builder.ParallelBuilder;
import com.consol.citrus.dsl.builder.PurgeChannelsBuilder;
import com.consol.citrus.dsl.builder.PurgeEndpointsBuilder;
import com.consol.citrus.dsl.builder.PurgeJmsQueuesBuilder;
import com.consol.citrus.dsl.builder.ReceiveMessageBuilder;
import com.consol.citrus.dsl.builder.ReceiveTimeoutBuilder;
import com.consol.citrus.dsl.builder.RepeatBuilder;
import com.consol.citrus.dsl.builder.RepeatOnErrorBuilder;
import com.consol.citrus.dsl.builder.SeleniumActionBuilder;
import com.consol.citrus.dsl.builder.SendMessageBuilder;
import com.consol.citrus.dsl.builder.SequenceBuilder;
import com.consol.citrus.dsl.builder.SoapActionBuilder;
import com.consol.citrus.dsl.builder.TemplateBuilder;
import com.consol.citrus.dsl.builder.TestActionBuilder;
import com.consol.citrus.dsl.builder.TestActionContainerBuilder;
import com.consol.citrus.dsl.builder.TimerBuilder;
import com.consol.citrus.dsl.builder.TransformActionBuilder;
import com.consol.citrus.dsl.builder.WaitActionBuilder;
import com.consol.citrus.dsl.builder.ZooActionBuilder;
import com.consol.citrus.dsl.container.FinallySequence;
import com.consol.citrus.dsl.design.ApplyTestBehaviorAction;
import com.consol.citrus.dsl.design.TestBehavior;
import com.consol.citrus.dsl.design.TestDesigner;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.report.TestActionListeners;
import com.consol.citrus.server.Server;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.sql.DataSource;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;

public class DefaultTestDesigner
implements TestDesigner {
    private final TestCase testCase;
    private TestContext context;
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();
    private ApplicationContext applicationContext;
    private Stack<AbstractActionContainer> containers = new Stack();

    public DefaultTestDesigner() {
        this(new TestCase());
        this.testCase.setVariableDefinitions(this.variables);
        this.testClass(this.getClass());
        this.name(this.getClass().getSimpleName());
        this.packageName(this.getClass().getPackage().getName());
    }

    protected DefaultTestDesigner(TestCase testCase) {
        this.testCase = testCase;
    }

    public DefaultTestDesigner(ApplicationContext applicationContext, TestContext context) {
        this();
        this.context = context;
        try {
            if (applicationContext != null) {
                this.applicationContext = applicationContext;
                this.initialize();
            }
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to setup test designer", (Throwable)e);
        }
    }

    protected void initialize() {
        this.testCase.setTestActionListeners((TestActionListeners)this.applicationContext.getBean(TestActionListeners.class));
        if (!this.applicationContext.getBeansOfType(SequenceBeforeTest.class).isEmpty()) {
            this.testCase.setBeforeTest(CollectionUtils.arrayToList((Object)this.applicationContext.getBeansOfType(SequenceBeforeTest.class).values().toArray()));
        }
        if (!this.applicationContext.getBeansOfType(SequenceAfterTest.class).isEmpty()) {
            this.testCase.setAfterTest(CollectionUtils.arrayToList((Object)this.applicationContext.getBeansOfType(SequenceAfterTest.class).values().toArray()));
        }
    }

    private void removeNestedActions(TestAction ... actions) {
        for (TestAction action : actions) {
            if (action instanceof TestActionBuilder) {
                this.testCase.getActions().remove(((TestActionBuilder)action).build());
                continue;
            }
            if (action.getClass().isAnonymousClass() || this.testCase.getActions().remove(action)) continue;
            TestAction toBeRemoved = null;
            for (TestAction testCaseAction : this.testCase.getActions()) {
                if (!(testCaseAction instanceof DelegatingTestAction) || !((DelegatingTestAction)testCaseAction).getDelegate().equals(action)) continue;
                toBeRemoved = testCaseAction;
                break;
            }
            if (toBeRemoved == null) continue;
            this.testCase.getActions().remove(toBeRemoved);
        }
    }

    @Override
    public void testClass(Class<?> type) {
        this.getTestCase().setTestClass(type);
    }

    @Override
    public void name(String name) {
        this.getTestCase().setBeanName(name);
        this.getTestCase().setName(name);
    }

    @Override
    public void description(String description) {
        this.getTestCase().setDescription(description);
    }

    @Override
    public void author(String author) {
        this.getTestCase().getMetaInfo().setAuthor(author);
    }

    @Override
    public void packageName(String packageName) {
        this.getTestCase().setPackageName(packageName);
    }

    @Override
    public void status(TestCaseMetaInfo.Status status) {
        this.getTestCase().getMetaInfo().setStatus(status);
    }

    @Override
    public void creationDate(Date date) {
        this.getTestCase().getMetaInfo().setCreationDate(date);
    }

    @Override
    public void variable(String name, Object value) {
        this.getVariables().put(name, value);
    }

    @Override
    public void action(TestAction testAction) {
        List actions = null;
        if (testAction instanceof TestActionContainerBuilder) {
            actions = ((TestActionContainerBuilder)testAction).getActions();
        } else if (testAction instanceof TestActionContainer) {
            actions = ((TestActionContainer)testAction).getActions();
        }
        if (!CollectionUtils.isEmpty(actions)) {
            if (!((AbstractActionContainer)this.containers.lastElement()).equals(testAction)) {
                throw new CitrusRuntimeException("Invalid use of action containers - the container execution is not expected!");
            }
            this.containers.pop();
            if (testAction instanceof FinallySequence) {
                this.testCase.getFinalActions().addAll(((FinallySequence)testAction).getActions());
                return;
            }
        }
        if (testAction instanceof TestActionBuilder) {
            if (!this.containers.isEmpty()) {
                ((AbstractActionContainer)this.containers.lastElement()).addTestAction(((TestActionBuilder)testAction).build());
            } else {
                this.testCase.addTestAction(((TestActionBuilder)testAction).build());
            }
        } else if (!this.containers.isEmpty()) {
            ((AbstractActionContainer)this.containers.lastElement()).addTestAction(testAction);
        } else {
            this.testCase.addTestAction(testAction);
        }
    }

    @Override
    public ApplyTestBehaviorAction applyBehavior(TestBehavior behavior) {
        ApplyTestBehaviorAction action = new ApplyTestBehaviorAction(this, behavior);
        behavior.setApplicationContext(this.getApplicationContext());
        action.execute(null);
        return action;
    }

    @Override
    public <T extends AbstractActionContainer> AbstractTestContainerBuilder<T> container(T container) {
        AbstractTestContainerBuilder containerBuilder = new AbstractTestContainerBuilder<T>(this, container){};
        this.containers.push((AbstractActionContainer)containerBuilder.build());
        return containerBuilder;
    }

    @Override
    public CreateVariablesAction createVariable(String variableName, String value) {
        CreateVariablesAction action = new CreateVariablesAction();
        action.getVariables().put(variableName, value);
        this.action((TestAction)action);
        return action;
    }

    @Override
    public AntRunBuilder antrun(String buildFilePath) {
        AntRunAction action = new AntRunAction();
        action.setBuildFilePath(buildFilePath);
        AntRunBuilder builder = new AntRunBuilder(action);
        this.action(builder);
        return builder;
    }

    @Override
    public EchoAction echo(String message) {
        EchoAction action = new EchoAction();
        action.setMessage(message);
        this.action((TestAction)action);
        return action;
    }

    @Override
    public ExecutePLSQLBuilder plsql(DataSource dataSource) {
        ExecutePLSQLAction action = new ExecutePLSQLAction();
        action.setDataSource(dataSource);
        ExecutePLSQLBuilder builder = new ExecutePLSQLBuilder(action);
        this.action(builder);
        return builder;
    }

    @Override
    public ExecuteSQLBuilder sql(DataSource dataSource) {
        ExecuteSQLAction action = new ExecuteSQLAction();
        action.setDataSource(dataSource);
        ExecuteSQLBuilder builder = new ExecuteSQLBuilder(action);
        this.action(builder);
        return builder;
    }

    @Override
    public ExecuteSQLQueryBuilder query(DataSource dataSource) {
        ExecuteSQLQueryAction action = new ExecuteSQLQueryAction();
        action.setDataSource(dataSource);
        ExecuteSQLQueryBuilder builder = new ExecuteSQLQueryBuilder(action);
        this.action(builder);
        return builder;
    }

    @Override
    public ReceiveTimeoutBuilder receiveTimeout(Endpoint messageEndpoint) {
        ReceiveTimeoutAction action = new ReceiveTimeoutAction();
        action.setEndpoint(messageEndpoint);
        ReceiveTimeoutBuilder builder = new ReceiveTimeoutBuilder(action);
        this.action(builder);
        return builder;
    }

    @Override
    public ReceiveTimeoutBuilder receiveTimeout(String messageEndpointUri) {
        ReceiveTimeoutAction action = new ReceiveTimeoutAction();
        action.setEndpointUri(messageEndpointUri);
        ReceiveTimeoutBuilder builder = new ReceiveTimeoutBuilder(action);
        this.action(builder);
        return builder;
    }

    @Override
    public FailAction fail(String message) {
        FailAction action = new FailAction();
        action.setMessage(message);
        this.action((TestAction)action);
        return action;
    }

    @Override
    public InputActionBuilder input() {
        InputActionBuilder builder = new InputActionBuilder();
        this.action(builder);
        return builder;
    }

    @Override
    public JavaActionBuilder java(String className) {
        JavaAction action = new JavaAction();
        action.setClassName(className);
        JavaActionBuilder builder = new JavaActionBuilder(action);
        this.action(builder);
        return builder;
    }

    @Override
    public JavaActionBuilder java(Class<?> clazz) {
        JavaAction action = new JavaAction();
        action.setClassName(clazz.getSimpleName());
        JavaActionBuilder builder = new JavaActionBuilder(action);
        this.action(builder);
        return builder;
    }

    @Override
    public JavaActionBuilder java(Object instance) {
        JavaAction action = new JavaAction();
        action.setInstance(instance);
        JavaActionBuilder builder = new JavaActionBuilder(action);
        this.action(builder);
        return builder;
    }

    @Override
    public LoadPropertiesAction load(String filePath) {
        LoadPropertiesAction action = new LoadPropertiesAction();
        action.setFilePath(filePath);
        this.action((TestAction)action);
        return action;
    }

    @Override
    public PurgeJmsQueuesBuilder purgeQueues() {
        PurgeJmsQueuesBuilder builder = new PurgeJmsQueuesBuilder().withApplicationContext(this.applicationContext);
        this.action(builder);
        return builder;
    }

    @Override
    public PurgeChannelsBuilder purgeChannels() {
        PurgeChannelsBuilder builder = new PurgeChannelsBuilder();
        builder.channelResolver(this.getApplicationContext());
        this.action(builder);
        return builder;
    }

    @Override
    public PurgeEndpointsBuilder purgeEndpoints() {
        PurgeEndpointsBuilder builder = new PurgeEndpointsBuilder().withApplicationContext(this.getApplicationContext());
        this.action(builder);
        return builder;
    }

    @Override
    public ReceiveMessageBuilder receive(Endpoint messageEndpoint) {
        ReceiveMessageAction action = new ReceiveMessageAction();
        action.setEndpoint(messageEndpoint);
        Object builder = ((ReceiveMessageBuilder)new ReceiveMessageBuilder(action).messageType(MessageType.XML)).withApplicationContext(this.getApplicationContext());
        this.action((TestAction)builder);
        return builder;
    }

    @Override
    public ReceiveMessageBuilder receive(String messageEndpointUri) {
        ReceiveMessageAction action = new ReceiveMessageAction();
        action.setEndpointUri(messageEndpointUri);
        Object builder = ((ReceiveMessageBuilder)new ReceiveMessageBuilder(action).messageType(MessageType.XML)).withApplicationContext(this.getApplicationContext());
        this.action((TestAction)builder);
        return builder;
    }

    @Override
    public SendMessageBuilder send(Endpoint messageEndpoint) {
        SendMessageAction action = new SendMessageAction();
        action.setEndpoint(messageEndpoint);
        Object builder = new SendMessageBuilder(action).withApplicationContext(this.getApplicationContext());
        this.action((TestAction)builder);
        return builder;
    }

    @Override
    public SendMessageBuilder send(String messageEndpointUri) {
        SendMessageAction action = new SendMessageAction();
        action.setEndpointUri(messageEndpointUri);
        Object builder = new SendMessageBuilder(action).withApplicationContext(this.getApplicationContext());
        this.action((TestAction)builder);
        return builder;
    }

    @Override
    public SleepAction sleep() {
        SleepAction action = new SleepAction();
        this.action((TestAction)action);
        return action;
    }

    @Override
    public SleepAction sleep(long milliseconds) {
        SleepAction action = new SleepAction();
        action.setMilliseconds(String.valueOf(milliseconds));
        this.action((TestAction)action);
        return action;
    }

    @Override
    public SleepAction sleep(double seconds) {
        SleepAction action = new SleepAction();
        action.setSeconds(String.valueOf(seconds));
        this.action((TestAction)action);
        return action;
    }

    @Override
    public WaitActionBuilder waitFor() {
        WaitAction action = new WaitAction();
        WaitActionBuilder builder = new WaitActionBuilder(action);
        this.action(builder);
        return builder;
    }

    @Override
    public StartServerAction start(Server ... servers) {
        StartServerAction action = new StartServerAction();
        action.getServerList().addAll(Arrays.asList(servers));
        this.action((TestAction)action);
        return action;
    }

    @Override
    public StartServerAction start(Server server) {
        StartServerAction action = new StartServerAction();
        action.setServer(server);
        this.action((TestAction)action);
        return action;
    }

    @Override
    public StopServerAction stop(Server ... servers) {
        StopServerAction action = new StopServerAction();
        action.getServerList().addAll(Arrays.asList(servers));
        this.action((TestAction)action);
        return action;
    }

    @Override
    public StopServerAction stop(Server server) {
        StopServerAction action = new StopServerAction();
        action.setServer(server);
        this.action((TestAction)action);
        return action;
    }

    @Override
    public StopTimeAction stopTime() {
        StopTimeAction action = new StopTimeAction();
        this.action((TestAction)action);
        return action;
    }

    @Override
    public StopTimeAction stopTime(String id) {
        StopTimeAction action = new StopTimeAction();
        action.setId(id);
        this.action((TestAction)action);
        return action;
    }

    @Override
    public TraceVariablesAction traceVariables() {
        TraceVariablesAction action = new TraceVariablesAction();
        this.action((TestAction)action);
        return action;
    }

    @Override
    public TraceVariablesAction traceVariables(String ... variables) {
        TraceVariablesAction action = new TraceVariablesAction();
        action.setVariableNames(Arrays.asList(variables));
        this.action((TestAction)action);
        return action;
    }

    @Override
    public GroovyActionBuilder groovy(String script) {
        GroovyActionBuilder builder = new GroovyActionBuilder().script(script);
        this.action(builder);
        return builder;
    }

    @Override
    public GroovyActionBuilder groovy(Resource scriptResource) {
        GroovyActionBuilder builder = new GroovyActionBuilder().script(scriptResource);
        this.action(builder);
        return builder;
    }

    @Override
    public TransformActionBuilder transform() {
        TransformActionBuilder builder = new TransformActionBuilder();
        this.action(builder);
        return builder;
    }

    @Override
    public AssertExceptionBuilder assertException() {
        AssertExceptionBuilder builder = new AssertExceptionBuilder(this);
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    @Override
    public CatchExceptionBuilder catchException() {
        CatchExceptionBuilder builder = new CatchExceptionBuilder(this).exception(CitrusRuntimeException.class.getName());
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    @Override
    public AssertSoapFaultBuilder assertSoapFault() {
        AssertSoapFaultBuilder builder = new AssertSoapFaultBuilder(this).withApplicationContext(this.applicationContext);
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    @Override
    public ConditionalBuilder conditional() {
        ConditionalBuilder builder = new ConditionalBuilder(this);
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    @Override
    public IterateBuilder iterate() {
        IterateBuilder builder = new IterateBuilder(this);
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    @Override
    public ParallelBuilder parallel() {
        ParallelBuilder builder = new ParallelBuilder(this);
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    @Override
    public RepeatOnErrorBuilder repeatOnError() {
        RepeatOnErrorBuilder builder = new RepeatOnErrorBuilder(this);
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    @Override
    public RepeatBuilder repeat() {
        RepeatBuilder builder = new RepeatBuilder(this);
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    @Override
    public SequenceBuilder sequential() {
        SequenceBuilder builder = new SequenceBuilder(this);
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    @Override
    public TimerBuilder timer() {
        TimerBuilder builder = new TimerBuilder(this);
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    @Override
    public StopTimerAction stopTimer(String timerId) {
        StopTimerAction action = new StopTimerAction();
        action.setTimerId(timerId);
        this.action((TestAction)action);
        return action;
    }

    @Override
    public StopTimerAction stopTimers() {
        StopTimerAction action = new StopTimerAction();
        this.action((TestAction)action);
        return action;
    }

    @Override
    public DockerActionBuilder docker() {
        DockerActionBuilder builder = new DockerActionBuilder();
        this.action(builder);
        return builder;
    }

    @Override
    public KubernetesActionBuilder kubernetes() {
        KubernetesActionBuilder builder = new KubernetesActionBuilder();
        this.action(builder);
        return builder;
    }

    @Override
    public SeleniumActionBuilder selenium() {
        SeleniumActionBuilder builder = new SeleniumActionBuilder();
        this.action(builder);
        return builder;
    }

    @Override
    public HttpActionBuilder http() {
        HttpActionBuilder builder = new HttpActionBuilder().withApplicationContext(this.getApplicationContext());
        this.action(builder);
        return builder;
    }

    @Override
    public SoapActionBuilder soap() {
        SoapActionBuilder builder = new SoapActionBuilder().withApplicationContext(this.getApplicationContext());
        this.action(builder);
        return builder;
    }

    @Override
    public CamelRouteActionBuilder camel() {
        CamelRouteActionBuilder builder = new CamelRouteActionBuilder().withApplicationContext(this.getApplicationContext());
        this.action(builder);
        return builder;
    }

    @Override
    public ZooActionBuilder zookeeper() {
        ZooActionBuilder builder = new ZooActionBuilder().withApplicationContext(this.getApplicationContext());
        this.action(builder);
        return builder;
    }

    @Override
    public TemplateBuilder applyTemplate(String name) {
        Template template = new Template();
        template.setName(name);
        TemplateBuilder builder = new TemplateBuilder(template).load(this.getApplicationContext());
        this.action(builder);
        return builder;
    }

    @Override
    public FinallySequenceBuilder doFinally() {
        FinallySequenceBuilder builder = new FinallySequenceBuilder(this);
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    @Override
    public TestCase getTestCase() {
        return this.testCase;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public TestContext getTestContext() {
        return this.context;
    }

    public void setTestContext(TestContext context) {
        this.context = context;
    }
}

