/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.testng;

import com.consol.citrus.Citrus;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestCase;
import com.consol.citrus.annotations.CitrusAnnotations;
import com.consol.citrus.annotations.CitrusTest;
import com.consol.citrus.common.TestLoader;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.dsl.design.DefaultTestDesigner;
import com.consol.citrus.dsl.design.TestDesigner;
import com.consol.citrus.dsl.runner.DefaultTestRunner;
import com.consol.citrus.dsl.runner.TestRunner;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.testng.AbstractTestNGCitrusTest;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.testng.IHookCallBack;
import org.testng.ITestResult;

public class TestNGCitrusTest
extends AbstractTestNGCitrusTest {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String DESIGNER_ATTRIBUTE = "designer";
    private static final String RUNNER_ATTRIBUTE = "runner";

    public void run(IHookCallBack callBack, ITestResult testResult) {
        Method method = testResult.getMethod().getConstructorOrMethod().getMethod();
        if (method != null && method.getAnnotation(CitrusTest.class) != null) {
            try {
                this.run(testResult, method, null, testResult.getMethod().getCurrentInvocationCount());
            }
            catch (RuntimeException e) {
                testResult.setThrowable((Throwable)e);
                testResult.setStatus(2);
            }
            catch (Exception e) {
                testResult.setThrowable((Throwable)e);
                testResult.setStatus(2);
            }
            super.run((IHookCallBack)new AbstractTestNGCitrusTest.FakeExecutionCallBack(callBack.getParameters()), testResult);
            if (testResult.getThrowable() != null) {
                if (testResult.getThrowable() instanceof RuntimeException) {
                    throw (RuntimeException)testResult.getThrowable();
                }
                throw new CitrusRuntimeException(testResult.getThrowable());
            }
        } else {
            super.run(callBack, testResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(ITestResult testResult, Method method, TestLoader testLoader, int invocationCount) {
        TestDesigner testDesigner = null;
        TestRunner testRunner = null;
        try {
            if (this.citrus == null) {
                this.citrus = Citrus.newInstance((ApplicationContext)this.applicationContext);
            }
            TestContext ctx = this.prepareTestContext(this.citrus.createTestContext());
            if (this.isDesignerMethod(method)) {
                testDesigner = this.createTestDesigner(method, ctx);
            } else if (this.isRunnerMethod(method)) {
                testRunner = this.createTestRunner(method, ctx);
            } else {
                throw new CitrusRuntimeException("Missing designer or runner method parameter");
            }
            testResult.setAttribute(DESIGNER_ATTRIBUTE, (Object)testDesigner);
            testResult.setAttribute(RUNNER_ATTRIBUTE, (Object)testRunner);
            TestCase testCase = testDesigner != null ? testDesigner.getTestCase() : testRunner.getTestCase();
            testCase.setGroups(testResult.getMethod().getGroups());
            CitrusAnnotations.injectAll((Object)((Object)this), (Citrus)this.citrus, (TestContext)ctx);
            this.invokeTestMethod(testResult, method, testCase, ctx, invocationCount);
        }
        finally {
            if (testRunner != null) {
                testRunner.stop();
            }
            testResult.removeAttribute(DESIGNER_ATTRIBUTE);
            testResult.removeAttribute(RUNNER_ATTRIBUTE);
        }
    }

    protected void invokeTestMethod(ITestResult testResult, Method method, TestCase testCase, TestContext context, int invocationCount) {
        if (testResult.getAttribute(DESIGNER_ATTRIBUTE) != null) {
            ReflectionUtils.invokeMethod((Method)method, (Object)((Object)this), (Object[])this.resolveParameter(testResult, method, testCase, context, invocationCount));
            this.citrus.run((TestAction)testCase, context);
        } else if (testResult.getAttribute(RUNNER_ATTRIBUTE) != null) {
            TestRunner testRunner = (TestRunner)testResult.getAttribute(RUNNER_ATTRIBUTE);
            Object[] params = this.resolveParameter(testResult, method, testCase, context, invocationCount);
            testRunner.start();
            ReflectionUtils.invokeMethod((Method)method, (Object)((Object)this), (Object[])params);
        }
    }

    protected Object resolveAnnotatedResource(ITestResult testResult, Class<?> parameterType, TestContext context) {
        if (TestDesigner.class.isAssignableFrom(parameterType)) {
            return testResult.getAttribute(DESIGNER_ATTRIBUTE);
        }
        if (TestRunner.class.isAssignableFrom(parameterType)) {
            return testResult.getAttribute(RUNNER_ATTRIBUTE);
        }
        return super.resolveAnnotatedResource(testResult, parameterType, context);
    }

    protected TestDesigner createTestDesigner(Method method, TestContext context) {
        DefaultTestDesigner testDesigner = new DefaultTestDesigner(this.applicationContext, context);
        testDesigner.testClass(((Object)((Object)this)).getClass());
        testDesigner.packageName(((Object)((Object)this)).getClass().getPackage().getName());
        if (method.getAnnotation(CitrusTest.class) != null) {
            CitrusTest citrusTestAnnotation = method.getAnnotation(CitrusTest.class);
            if (StringUtils.hasText((String)citrusTestAnnotation.name())) {
                testDesigner.name(citrusTestAnnotation.name());
            } else {
                testDesigner.name(method.getDeclaringClass().getSimpleName() + "." + method.getName());
            }
        } else {
            testDesigner.name(method.getDeclaringClass().getSimpleName() + "." + method.getName());
        }
        return testDesigner;
    }

    protected TestRunner createTestRunner(Method method, TestContext context) {
        DefaultTestRunner testRunner = new DefaultTestRunner(this.applicationContext, context);
        testRunner.testClass(((Object)((Object)this)).getClass());
        testRunner.packageName(((Object)((Object)this)).getClass().getPackage().getName());
        if (method.getAnnotation(CitrusTest.class) != null) {
            CitrusTest citrusTestAnnotation = method.getAnnotation(CitrusTest.class);
            if (StringUtils.hasText((String)citrusTestAnnotation.name())) {
                testRunner.name(citrusTestAnnotation.name());
            } else {
                testRunner.name(method.getDeclaringClass().getSimpleName() + "." + method.getName());
            }
        } else {
            testRunner.name(method.getDeclaringClass().getSimpleName() + "." + method.getName());
        }
        return testRunner;
    }

    protected boolean isDesignerMethod(Method method) {
        Class<?>[] parameterTypes;
        for (Class<TestDesigner> clazz : parameterTypes = method.getParameterTypes()) {
            if (!clazz.isAssignableFrom(TestDesigner.class)) continue;
            return true;
        }
        return false;
    }

    protected boolean isRunnerMethod(Method method) {
        Class<?>[] parameterTypes;
        for (Class<TestRunner> clazz : parameterTypes = method.getParameterTypes()) {
            if (!clazz.isAssignableFrom(TestRunner.class)) continue;
            return true;
        }
        return false;
    }
}

