/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.nashorn_modules;

import com.coveo.nashorn_modules.AbstractFolder;
import com.coveo.nashorn_modules.Folder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class FilesystemFolder
extends AbstractFolder {
    private File root;
    private String encoding = "UTF-8";

    private FilesystemFolder(File root, Folder parent, String path, String encoding) {
        super(parent, path);
        this.root = root;
        this.encoding = encoding;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getFile(String name) {
        File file = new File(this.root, name);
        try (FileInputStream stream = new FileInputStream(file);){
            String string = IOUtils.toString((InputStream)stream, (String)this.encoding);
            return string;
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public Folder getFolder(String name) {
        File folder = new File(this.root, name);
        if (!folder.exists()) {
            return null;
        }
        return new FilesystemFolder(folder, this, this.getPath() + name + "/", this.encoding);
    }

    public static FilesystemFolder create(File root, String encoding) {
        File absolute = root.getAbsoluteFile();
        return new FilesystemFolder(absolute, null, absolute.getPath() + "/", encoding);
    }
}

