/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.nashorn_modules;

import com.coveo.nashorn_modules.Folder;
import com.coveo.nashorn_modules.ModuleCache;
import com.coveo.nashorn_modules.Paths;
import com.coveo.nashorn_modules.RequireFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import jdk.nashorn.api.scripting.NashornScriptEngine;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import jdk.nashorn.internal.runtime.ECMAException;

public class Module
extends SimpleBindings
implements RequireFunction {
    private NashornScriptEngine engine;
    private ScriptObjectMirror objectConstructor;
    private ScriptObjectMirror jsonConstructor;
    private ScriptObjectMirror errorConstructor;
    private Folder folder;
    private ModuleCache cache;
    private Module main;
    private Bindings module;
    private List<Bindings> children = new ArrayList<Bindings>();
    private Object exports;
    private static ThreadLocal<Map<String, Bindings>> refCache = new ThreadLocal();

    public Module(NashornScriptEngine engine, Folder folder, ModuleCache cache, String filename, Bindings module, Bindings exports, Module parent, Module main) throws ScriptException {
        this.engine = engine;
        if (parent != null) {
            this.objectConstructor = parent.objectConstructor;
            this.jsonConstructor = parent.jsonConstructor;
            this.errorConstructor = parent.errorConstructor;
        } else {
            this.objectConstructor = (ScriptObjectMirror)engine.eval("Object");
            this.jsonConstructor = (ScriptObjectMirror)engine.eval("JSON");
            this.errorConstructor = (ScriptObjectMirror)engine.eval("Error");
        }
        this.folder = folder;
        this.cache = cache;
        this.main = main != null ? main : this;
        this.module = module;
        this.exports = exports;
        this.put("main", (Object)this.main.module);
        module.put("exports", (Object)exports);
        module.put("children", (Object)this.children);
        module.put("filename", (Object)filename);
        module.put("id", (Object)filename);
        module.put("loaded", (Object)false);
        module.put("parent", (Object)(parent != null ? parent.module : null));
    }

    void setLoaded() {
        this.module.put("loaded", (Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object require(String module) throws ScriptException {
        String[] parts;
        if (module == null) {
            this.throwModuleNotFoundException("<null>");
        }
        if ((parts = Paths.splitPath(module)).length == 0) {
            this.throwModuleNotFoundException(module);
        }
        String[] folderParts = Arrays.copyOfRange(parts, 0, parts.length - 1);
        String filename = parts[parts.length - 1];
        Module found = null;
        Folder resolvedFolder = this.resolveFolder(this.folder, folderParts);
        if (refCache.get() == null) {
            refCache.set(new HashMap());
        }
        String requestedFullPath = null;
        if (resolvedFolder != null) {
            requestedFullPath = resolvedFolder.getPath() + filename;
            Bindings cachedExports = refCache.get().get(requestedFullPath);
            if (cachedExports != null) {
                return cachedExports;
            }
            refCache.get().put(requestedFullPath, this.createSafeBindings());
        }
        try {
            if (Module.isPrefixedModuleName(module)) {
                found = this.attemptToLoadFromThisFolder(resolvedFolder, filename);
            }
            if (found == null) {
                found = this.searchForModuleInNodeModules(this.folder, folderParts, filename);
            }
            if (found == null) {
                this.throwModuleNotFoundException(module);
            }
            assert (found != null);
            this.children.add(found.module);
            Object object = found.exports;
            return object;
        }
        finally {
            if (requestedFullPath != null) {
                refCache.get().remove(requestedFullPath);
            }
        }
    }

    private Module searchForModuleInNodeModules(Folder resolvedFolder, String[] folderParts, String filename) throws ScriptException {
        for (Folder current = resolvedFolder; current != null; current = current.getParent()) {
            Module found;
            Folder nodeModules = current.getFolder("node_modules");
            if (nodeModules == null || (found = this.attemptToLoadFromThisFolder(this.resolveFolder(nodeModules, folderParts), filename)) == null) continue;
            return found;
        }
        return null;
    }

    private Module attemptToLoadFromThisFolder(Folder resolvedFolder, String filename) throws ScriptException {
        if (resolvedFolder == null) {
            return null;
        }
        String requestedFullPath = resolvedFolder.getPath() + filename;
        Module found = this.cache.get(requestedFullPath);
        if (found != null) {
            return found;
        }
        found = this.loadModuleAsFile(resolvedFolder, filename);
        if (found == null) {
            found = this.loadModuleAsFolder(resolvedFolder, filename);
        }
        if (found != null) {
            this.cache.put(requestedFullPath, found);
        }
        return found;
    }

    private Module loadModuleAsFile(Folder parent, String filename) throws ScriptException {
        String[] filenamesToAttempt;
        for (String tentativeFilename : filenamesToAttempt = Module.getFilenamesToAttempt(filename)) {
            String code = parent.getFile(tentativeFilename);
            if (code == null) continue;
            String fullPath = parent.getPath() + tentativeFilename;
            return this.compileModuleAndPutInCache(parent, fullPath, code);
        }
        return null;
    }

    private Module loadModuleAsFolder(Folder parent, String name) throws ScriptException {
        Folder fileAsFolder = parent.getFolder(name);
        if (fileAsFolder == null) {
            return null;
        }
        Module found = this.loadModuleThroughPackageJson(fileAsFolder);
        if (found == null) {
            found = this.loadModuleThroughIndexJs(fileAsFolder);
        }
        if (found == null) {
            found = this.loadModuleThroughIndexJson(fileAsFolder);
        }
        return found;
    }

    private Module loadModuleThroughPackageJson(Folder parent) throws ScriptException {
        String packageJson = parent.getFile("package.json");
        if (packageJson == null) {
            return null;
        }
        String mainFile = this.getMainFileFromPackageJson(packageJson);
        if (mainFile == null) {
            return null;
        }
        String[] parts = Paths.splitPath(mainFile);
        String[] folders = Arrays.copyOfRange(parts, 0, parts.length - 1);
        String filename = parts[parts.length - 1];
        Folder folder = this.resolveFolder(parent, folders);
        if (folder == null) {
            return null;
        }
        Module module = this.loadModuleAsFile(folder, filename);
        if (module == null && (folder = this.resolveFolder(parent, parts)) != null) {
            module = this.loadModuleThroughIndexJs(folder);
        }
        return module;
    }

    private String getMainFileFromPackageJson(String packageJson) throws ScriptException {
        ScriptObjectMirror parsed = this.parseJson(packageJson);
        return (String)parsed.get("main");
    }

    private Module loadModuleThroughIndexJs(Folder parent) throws ScriptException {
        String code = parent.getFile("index.js");
        if (code == null) {
            return null;
        }
        return this.compileModuleAndPutInCache(parent, parent.getPath() + "index.js", code);
    }

    private Module loadModuleThroughIndexJson(Folder parent) throws ScriptException {
        String code = parent.getFile("index.json");
        if (code == null) {
            return null;
        }
        return this.compileModuleAndPutInCache(parent, parent.getPath() + "index.json", code);
    }

    private Module compileModuleAndPutInCache(Folder parent, String fullPath, String code) throws ScriptException {
        Module created;
        String lowercaseFullPath = fullPath.toLowerCase();
        if (lowercaseFullPath.endsWith(".js")) {
            created = this.compileJavaScriptModule(parent, fullPath, code);
        } else if (lowercaseFullPath.endsWith(".json")) {
            created = this.compileJsonModule(parent, fullPath, code);
        } else {
            return null;
        }
        this.cache.put(fullPath, created);
        return created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Module compileJavaScriptModule(Folder parent, String fullPath, String code) throws ScriptException {
        Bindings engineScope = this.engine.getBindings(100);
        Bindings module = this.createSafeBindings();
        module.putAll(engineScope);
        Bindings exports = refCache.get().get(fullPath);
        if (exports == null) {
            exports = this.createSafeBindings();
        }
        Module created = new Module(this.engine, parent, this.cache, fullPath, module, exports, this, this.main);
        String[] split = Paths.splitPath(fullPath);
        String filename = split[split.length - 1];
        String dirname = fullPath.substring(0, Math.max(fullPath.length() - filename.length() - 1, 0));
        String previousFilename = (String)this.engine.get("javax.script.filename");
        this.engine.put("javax.script.filename", (Object)fullPath);
        try {
            ScriptObjectMirror function = (ScriptObjectMirror)this.engine.eval("(function (exports, require, module, __filename, __dirname) {" + code + "\n})");
            function.call((Object)created, new Object[]{created.exports, created, created.module, filename, dirname});
        }
        finally {
            this.engine.put("javax.script.filename", (Object)previousFilename);
        }
        created.exports = created.module.get("exports");
        created.setLoaded();
        return created;
    }

    private Module compileJsonModule(Folder parent, String fullPath, String code) throws ScriptException {
        Bindings module = this.createSafeBindings();
        Bindings exports = this.createSafeBindings();
        Module created = new Module(this.engine, parent, this.cache, fullPath, module, exports, this, this.main);
        created.exports = this.parseJson(code);
        created.setLoaded();
        return created;
    }

    private ScriptObjectMirror parseJson(String json) throws ScriptException {
        return (ScriptObjectMirror)this.jsonConstructor.callMember("parse", new Object[]{json});
    }

    private void throwModuleNotFoundException(String module) throws ScriptException {
        Bindings error = (Bindings)this.errorConstructor.newObject(new Object[]{"Module not found: " + module});
        error.put("code", (Object)"MODULE_NOT_FOUND");
        throw new ECMAException((Object)error, null);
    }

    private Folder resolveFolder(Folder from, String[] folders) {
        Folder current = from;
        String[] stringArray = folders;
        int n = stringArray.length;
        block10: for (int i = 0; i < n; ++i) {
            String name;
            switch (name = stringArray[i]) {
                case "": {
                    throw new IllegalArgumentException();
                }
                case ".": {
                    continue block10;
                }
                case "..": {
                    current = current.getParent();
                    break;
                }
                default: {
                    current = current.getFolder(name);
                }
            }
            if (current != null) continue;
            return null;
        }
        return current;
    }

    private Bindings createSafeBindings() throws ScriptException {
        return (ScriptObjectMirror)this.objectConstructor.newObject(new Object[0]);
    }

    private static boolean isPrefixedModuleName(String module) {
        return module.startsWith("/") || module.startsWith("../") || module.startsWith("./");
    }

    private static String[] getFilenamesToAttempt(String filename) {
        return new String[]{filename, filename + ".js", filename + ".json"};
    }
}

