/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.xssf.usermodel;

import java.util.List;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColors;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRgbColor;
import shadeio.poi.xssf.usermodel.IndexedColorMap;

public class CustomIndexedColorMap
implements IndexedColorMap {
    private final byte[][] colorIndex;

    private CustomIndexedColorMap(byte[][] colors) {
        this.colorIndex = colors;
    }

    @Override
    public byte[] getRGB(int index) {
        if (this.colorIndex == null || index < 0 || index >= this.colorIndex.length) {
            return null;
        }
        return this.colorIndex[index];
    }

    public static CustomIndexedColorMap fromColors(CTColors colors) {
        if (colors == null || !colors.isSetIndexedColors()) {
            return null;
        }
        List rgbColorList = colors.getIndexedColors().getRgbColorList();
        byte[][] customColorIndex = new byte[rgbColorList.size()][3];
        for (int i = 0; i < rgbColorList.size(); ++i) {
            customColorIndex[i] = ((CTRgbColor)rgbColorList.get(i)).getRgb();
        }
        return new CustomIndexedColorMap(customColorIndex);
    }
}

