/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.ddf;

import java.util.function.Supplier;
import shadeio.poi.ddf.EscherBlipRecord;
import shadeio.poi.ddf.EscherContainerRecord;
import shadeio.poi.ddf.EscherRecord;
import shadeio.poi.ddf.EscherRecordFactory;
import shadeio.poi.ddf.EscherRecordTypes;
import shadeio.poi.ddf.EscherTextboxRecord;
import shadeio.poi.ddf.UnknownEscherRecord;
import shadeio.poi.util.BitField;
import shadeio.poi.util.BitFieldFactory;
import shadeio.poi.util.LittleEndian;
import shadeio.poi.util.Removal;

public class DefaultEscherRecordFactory
implements EscherRecordFactory {
    private static final BitField IS_CONTAINER = BitFieldFactory.getInstance(15);

    @Override
    public EscherRecord createRecord(byte[] data, int offset) {
        short options = LittleEndian.getShort(data, offset);
        short recordId = LittleEndian.getShort(data, offset + 2);
        EscherRecord escherRecord = this.getConstructor(options, recordId).get();
        escherRecord.setRecordId(recordId);
        escherRecord.setOptions(options);
        return escherRecord;
    }

    protected Supplier<? extends EscherRecord> getConstructor(short options, short recordId) {
        EscherRecordTypes recordTypes = EscherRecordTypes.forTypeID(recordId);
        if (recordTypes == EscherRecordTypes.UNKNOWN && IS_CONTAINER.isAllSet(options)) {
            return EscherContainerRecord::new;
        }
        if (recordTypes.constructor != null) {
            return recordTypes.constructor;
        }
        if (EscherBlipRecord.RECORD_ID_START <= recordId && recordId <= EscherBlipRecord.RECORD_ID_END) {
            return EscherBlipRecord::new;
        }
        return UnknownEscherRecord::new;
    }

    @Deprecated
    @Removal(version="5.0.0")
    public static boolean isContainer(short options, short recordId) {
        if (recordId >= EscherContainerRecord.DGG_CONTAINER && recordId <= EscherContainerRecord.SOLVER_CONTAINER) {
            return true;
        }
        if (recordId == EscherTextboxRecord.RECORD_ID) {
            return false;
        }
        return (options & 0xF) == 15;
    }
}

