/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.hssf.model;

import shadeio.poi.hssf.usermodel.HSSFEvaluationWorkbook;
import shadeio.poi.hssf.usermodel.HSSFWorkbook;
import shadeio.poi.ss.formula.FormulaParseException;
import shadeio.poi.ss.formula.FormulaParser;
import shadeio.poi.ss.formula.FormulaParsingWorkbook;
import shadeio.poi.ss.formula.FormulaRenderer;
import shadeio.poi.ss.formula.FormulaType;
import shadeio.poi.ss.formula.ptg.Ptg;
import shadeio.poi.util.Internal;

@Internal
public final class HSSFFormulaParser {
    private static FormulaParsingWorkbook createParsingWorkbook(HSSFWorkbook book) {
        return HSSFEvaluationWorkbook.create(book);
    }

    private HSSFFormulaParser() {
    }

    public static Ptg[] parse(String formula, HSSFWorkbook workbook) throws FormulaParseException {
        return HSSFFormulaParser.parse(formula, workbook, FormulaType.CELL);
    }

    public static Ptg[] parse(String formula, HSSFWorkbook workbook, FormulaType formulaType) throws FormulaParseException {
        return HSSFFormulaParser.parse(formula, workbook, formulaType, -1);
    }

    public static Ptg[] parse(String formula, HSSFWorkbook workbook, FormulaType formulaType, int sheetIndex) throws FormulaParseException {
        return FormulaParser.parse(formula, HSSFFormulaParser.createParsingWorkbook(workbook), formulaType, sheetIndex);
    }

    public static String toFormulaString(HSSFWorkbook book, Ptg[] ptgs) {
        return FormulaRenderer.toFormulaString(HSSFEvaluationWorkbook.create(book), ptgs);
    }
}

