/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.ss.usermodel;

import java.util.Iterator;
import java.util.List;
import shadeio.poi.ss.formula.ConditionalFormattingEvaluator;
import shadeio.poi.ss.formula.EvaluationConditionalFormatRule;
import shadeio.poi.ss.usermodel.Cell;
import shadeio.poi.ss.usermodel.CellStyle;

public class ExcelNumberFormat {
    private final int idx;
    private final String format;

    public static ExcelNumberFormat from(CellStyle style) {
        if (style == null) {
            return null;
        }
        return new ExcelNumberFormat(style.getDataFormat(), style.getDataFormatString());
    }

    public static ExcelNumberFormat from(Cell cell, ConditionalFormattingEvaluator cfEvaluator) {
        if (cell == null) {
            return null;
        }
        ExcelNumberFormat nf = null;
        if (cfEvaluator != null) {
            EvaluationConditionalFormatRule rule;
            List<EvaluationConditionalFormatRule> rules = cfEvaluator.getConditionalFormattingForCell(cell);
            Iterator<EvaluationConditionalFormatRule> iterator = rules.iterator();
            while (iterator.hasNext() && (nf = (rule = iterator.next()).getNumberFormat()) == null) {
            }
        }
        if (nf == null) {
            CellStyle style = cell.getCellStyle();
            nf = ExcelNumberFormat.from(style);
        }
        return nf;
    }

    public ExcelNumberFormat(int idx, String format) {
        this.idx = idx;
        this.format = format;
    }

    public int getIdx() {
        return this.idx;
    }

    public String getFormat() {
        return this.format;
    }
}

