/*
 * Decompiled with CFR 0.152.
 */
package com.crealytics.spark.excel.v2;

import com.crealytics.spark.excel.v2.ExcelDateTimeStringUtils$;
import com.crealytics.spark.excel.v2.ExcelFilters;
import com.crealytics.spark.excel.v2.ExcelHeaderChecker;
import com.crealytics.spark.excel.v2.ExcelHelper;
import com.crealytics.spark.excel.v2.ExcelHelper$;
import com.crealytics.spark.excel.v2.ExcelOptions;
import com.crealytics.spark.excel.v2.ExcelParser$;
import com.crealytics.spark.excel.v2.ExcelParserBase;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.BadRecordException;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tMd\u0001\u0002\u0015*\u0001QB\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t'\u0002\u0011\t\u0011)A\u0005\u0017\"AA\u000b\u0001BC\u0002\u0013\u0005Q\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003W\u0011!Q\u0006A!A!\u0002\u0013Y\u0006\"B7\u0001\t\u0003q\u0007\"B7\u0001\t\u0003!\b\"B7\u0001\t\u0003A\bb\u0002?\u0001\u0005\u0004%I! \u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003\u007f\u000b\u0019\t)\u0001\u0001\u0003\u0002\b!I\u0011q\u0005\u0001C\u0002\u0013%\u0011\u0011\u0006\u0005\t\u0003w\u0001\u0001\u0015!\u0003\u0002,!I\u0011Q\b\u0001C\u0002\u0013%\u0011q\b\u0005\t\u0003/\u0002\u0001\u0015!\u0003\u0002B!I\u0011\u0011\f\u0001C\u0002\u0013%\u00111\f\u0005\t\u0003S\u0002\u0001\u0015!\u0003\u0002^!I\u00111\u000e\u0001C\u0002\u0013%\u0011Q\u000e\u0005\t\u0003\u000b\u0003\u0001\u0015!\u0003\u0002p!I\u0011q\u0011\u0001C\u0002\u0013%\u0011\u0011\u0012\u0005\t\u0003#\u0003\u0001\u0015!\u0003\u0002\f\"Q\u00111\u0013\u0001\t\u0006\u0004%I!!&\t\u0015\u0005\r\u0006\u0001#b\u0001\n\u0013\t)\u000bC\u0005\u0002.\u0002\u0011\r\u0011\"\u0003\u00020\"A\u0011q\u0017\u0001!\u0002\u0013\t\t\fC\u0004\u0002:\u0002!\t\"a/\t\u0013\u0005-\u0007A1A\u0005\n\u00055\u0007\u0002CAk\u0001\u0001\u0006I!a4\t\u0013\u0005]\u0007A1A\u0005\n\u0005e\u0007\u0002CA}\u0001\u0001\u0006I!a7\t\u000f\u0005m\b\u0001\"\u0003\u0002~\"9!q\u0003\u0001\u0005\n\te\u0001\"\u0003B\u0016\u0001\t\u0007I\u0011\u0001B\u0017\u0011!\u0011\t\u0005\u0001Q\u0001\n\t=\u0002b\u0002B\"\u0001\u0011%!QI\u0004\b\u0005\u0017J\u0003\u0012\u0001B'\r\u0019A\u0013\u0006#\u0001\u0003P!1Q.\nC\u0001\u0005#BqAa\u0015&\t\u0003\u0011)FA\u0006Fq\u000e,G\u000eU1sg\u0016\u0014(B\u0001\u0016,\u0003\t1(G\u0003\u0002-[\u0005)Q\r_2fY*\u0011afL\u0001\u0006gB\f'o\u001b\u0006\u0003aE\n!b\u0019:fC2LH/[2t\u0015\u0005\u0011\u0014aA2p[\u000e\u00011\u0003\u0002\u00016w\u0019\u0003\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012a!\u00118z%\u00164\u0007C\u0001\u001fE\u001b\u0005i$B\u0001 @\u0003!Ig\u000e^3s]\u0006d'B\u0001\u0018A\u0015\t\t%)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0007\u0006\u0019qN]4\n\u0005\u0015k$a\u0002'pO\u001eLgn\u001a\t\u0003\u000f\"k\u0011!K\u0005\u0003\u0013&\u0012q\"\u0012=dK2\u0004\u0016M]:fe\n\u000b7/Z\u0001\u000bI\u0006$\u0018mU2iK6\f\u0007C\u0001'R\u001b\u0005i%B\u0001(P\u0003\u0015!\u0018\u0010]3t\u0015\t\u0001v(A\u0002tc2L!AU'\u0003\u0015M#(/^2u)f\u0004X-\u0001\bsKF,\u0018N]3e'\u000eDW-\\1\u0002\u000f=\u0004H/[8ogV\ta\u000b\u0005\u0002H/&\u0011\u0001,\u000b\u0002\r\u000bb\u001cW\r\\(qi&|gn]\u0001\t_B$\u0018n\u001c8tA\u00059a-\u001b7uKJ\u001c\bc\u0001/eO:\u0011QL\u0019\b\u0003=\u0006l\u0011a\u0018\u0006\u0003AN\na\u0001\u0010:p_Rt\u0014\"\u0001\u001d\n\u0005\r<\u0014a\u00029bG.\fw-Z\u0005\u0003K\u001a\u00141aU3r\u0015\t\u0019w\u0007\u0005\u0002iW6\t\u0011N\u0003\u0002k\u001f\u000691o\\;sG\u0016\u001c\u0018B\u00017j\u0005\u00191\u0015\u000e\u001c;fe\u00061A(\u001b8jiz\"Ra\u001c9reN\u0004\"a\u0012\u0001\t\u000b)3\u0001\u0019A&\t\u000bM3\u0001\u0019A&\t\u000bQ3\u0001\u0019\u0001,\t\u000bi3\u0001\u0019A.\u0015\t=,ho\u001e\u0005\u0006\u0015\u001e\u0001\ra\u0013\u0005\u0006'\u001e\u0001\ra\u0013\u0005\u0006)\u001e\u0001\rA\u0016\u000b\u0004_f\\\b\"\u0002>\t\u0001\u0004Y\u0015AB:dQ\u0016l\u0017\rC\u0003U\u0011\u0001\u0007a+A\u0006fq\u000e,G\u000eS3ma\u0016\u0014X#\u0001@\u0011\u0005\u001d{\u0018bAA\u0001S\tYQ\t_2fY\"+G\u000e]3s\u00031)\u0007pY3m\u0011\u0016d\u0007/\u001a:!\u000591\u0016\r\\;f\u0007>tg/\u001a:uKJ\u0004rANA\u0005\u0003\u001b\t\t#C\u0002\u0002\f]\u0012\u0011BR;oGRLwN\\\u0019\u0011\t\u0005=\u0011QD\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005IQo]3s[>$W\r\u001c\u0006\u0005\u0003/\tI\"\u0001\u0002tg*\u0019\u00111\u0004!\u0002\u0007A|\u0017.\u0003\u0003\u0002 \u0005E!\u0001B\"fY2\u00042ANA\u0012\u0013\r\t)c\u000e\u0002\u0004\u0003:L\u0018\u0001\u00049beN,GmU2iK6\fWCAA\u0016!\u0019\ti#a\r\u000265\u0011\u0011q\u0006\u0006\u0004\u0003c9\u0014AC2pY2,7\r^5p]&\u0019Q-a\f\u0011\u00071\u000b9$C\u0002\u0002:5\u00131b\u0015;sk\u000e$h)[3mI\u0006i\u0001/\u0019:tK\u0012\u001c6\r[3nC\u0002\nQ\u0002^8lK:Le\u000eZ3y\u0003J\u0014XCAA!!\u00151\u00141IA$\u0013\r\t)e\u000e\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003\u0013\n\u0019&\u0004\u0002\u0002L)!\u0011QJA(\u0003\u0011a\u0017M\\4\u000b\u0005\u0005E\u0013\u0001\u00026bm\u0006LA!!\u0016\u0002L\t9\u0011J\u001c;fO\u0016\u0014\u0018A\u0004;pW\u0016t\u0017J\u001c3fq\u0006\u0013(\u000fI\u0001\u0012e><h*^7cKJ\u0004vn]5uS>tWCAA/!\u00151\u0014qLA2\u0013\r\t\tg\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007Y\n)'C\u0002\u0002h]\u00121!\u00138u\u0003I\u0011xn\u001e(v[\n,'\u000fU8tSRLwN\u001c\u0011\u0002\u0017I,\u0017/^5sK\u0012\u0014vn^\u000b\u0003\u0003_\u0002RANA9\u0003kJ1!a\u001d8\u0005\u0011\u0019v.\\3\u0011\t\u0005]\u0014\u0011Q\u0007\u0003\u0003sRA!a\u001f\u0002~\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\r\tyhT\u0001\tG\u0006$\u0018\r\\=ti&!\u00111QA=\u0005I9UM\\3sS\u000eLe\u000e^3s]\u0006d'k\\<\u0002\u0019I,\u0017/^5sK\u0012\u0014vn\u001e\u0011\u0002\r9|'k\\<t+\t\tYID\u00027\u0003\u001bK1!a$8\u0003\u0011quN\\3\u0002\u000f9|'k\\<tA\u0005\u0011B/[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s+\t\t9\n\u0005\u0003\u0002\u001a\u0006}UBAAN\u0015\u0011\ti*! \u0002\tU$\u0018\u000e\\\u0005\u0005\u0003C\u000bYJ\u0001\nUS6,7\u000f^1na\u001a{'/\\1ui\u0016\u0014\u0018!\u00043bi\u00164uN]7biR,'/\u0006\u0002\u0002(B!\u0011\u0011TAU\u0013\u0011\tY+a'\u0003\u001b\u0011\u000bG/\u001a$pe6\fG\u000f^3s\u00035\u0001Xo\u001d5fI\u001aKG\u000e^3sgV\u0011\u0011\u0011\u0017\t\u0004\u000f\u0006M\u0016bAA[S\taQ\t_2fY\u001aKG\u000e^3sg\u0006q\u0001/^:iK\u00124\u0015\u000e\u001c;feN\u0004\u0013aD4fi\u000e+(O]3oi&s\u0007/\u001e;\u0016\u0005\u0005u\u0006\u0003BA`\u0003\u000fl!!!1\u000b\u00079\u000b\u0019MC\u0002\u0002F~\na!\u001e8tC\u001a,\u0017\u0002BAe\u0003\u0003\u0014!\"\u0016+GqM#(/\u001b8h\u0003=1\u0018\r\\;f\u0007>tg/\u001a:uKJ\u001cXCAAh!\u00151\u00141IAi!\r\t\u0019nC\u0007\u0002\u0001\u0005\u0001b/\u00197vK\u000e{gN^3si\u0016\u00148\u000fI\u0001\u000eI\u0016\u001c\u0017.\\1m!\u0006\u00148/\u001a:\u0016\u0005\u0005m\u0007c\u0002\u001c\u0002\n\u0005u\u0017Q\u001e\t\u0005\u0003?\f9O\u0004\u0003\u0002b\u0006\r\bC\u000108\u0013\r\t)oN\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00181\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015x\u0007\u0005\u0003\u0002p\u0006UXBAAy\u0015\u0011\t\u00190a\u0014\u0002\t5\fG\u000f[\u0005\u0005\u0003o\f\tP\u0001\u0006CS\u001e$UmY5nC2\fa\u0002Z3dS6\fG\u000eU1sg\u0016\u0014\b%A\u0007nC.,7i\u001c8wKJ$XM\u001d\u000b\t\u0003#\fyPa\u0001\u0003\u000e!9!\u0011A\u0010A\u0002\u0005u\u0017\u0001\u00028b[\u0016DqA!\u0002 \u0001\u0004\u00119!\u0001\u0005eCR\fG+\u001f9f!\ra%\u0011B\u0005\u0004\u0005\u0017i%\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000f\t=q\u00041\u0001\u0003\u0012\u0005Aa.\u001e7mC\ndW\rE\u00027\u0005'I1A!\u00068\u0005\u001d\u0011un\u001c7fC:\fQB\\;mYN\u000bg-\u001a#biVlGC\u0003B\u000e\u0005C\u0011)Ca\n\u0003*Q!\u0011\u0011\u0005B\u000f\u0011\u001d\u0011y\u0002\ta\u0001\u0003#\f\u0011bY8om\u0016\u0014H/\u001a:\t\u000f\t\r\u0002\u00051\u0001\u0002\u000e\u0005)A-\u0019;v[\"9!\u0011\u0001\u0011A\u0002\u0005u\u0007b\u0002B\bA\u0001\u0007!\u0011\u0003\u0005\u0006)\u0002\u0002\rAV\u0001\u0006a\u0006\u00148/Z\u000b\u0003\u0005_\u0001rANA\u0005\u0005c\u00119\u0004E\u0003]\u0005g\ti!C\u0002\u00036\u0019\u0014aAV3di>\u0014\b#\u0002\u001c\u0002`\te\u0002\u0003\u0002B\u001e\u0005{i!!! \n\t\t}\u0012Q\u0010\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\u0004qCJ\u001cX\rI\u0001\bG>tg/\u001a:u)\u0011\u00119Da\u0012\t\u000f\t%3\u00051\u0001\u00032\u00051Ao\\6f]N\f1\"\u0012=dK2\u0004\u0016M]:feB\u0011q)J\n\u0003KU\"\"A!\u0014\u0002\u001bA\f'o]3Ji\u0016\u0014\u0018\r^8s))\u00119F!\u0018\u0003d\t\u001d$\u0011\u000f\t\u00069\ne#\u0011H\u0005\u0004\u000572'\u0001C%uKJ\fGo\u001c:\t\u000f\t}s\u00051\u0001\u0003b\u0005!!o\\<t!\u0015a&\u0011\fB\u0019\u0011\u0019\u0011)g\na\u0001_\u00061\u0001/\u0019:tKJDqA!\u001b(\u0001\u0004\u0011Y'A\u0007iK\u0006$WM]\"iK\u000e\\WM\u001d\t\u0004\u000f\n5\u0014b\u0001B8S\t\u0011R\t_2fY\"+\u0017\rZ3s\u0007\",7m[3s\u0011\u0015Qx\u00051\u0001L\u0001")
public class ExcelParser
implements Logging,
ExcelParserBase {
    private TimestampFormatter timestampFormatter;
    private DateFormatter dateFormatter;
    private final StructType dataSchema;
    private final StructType requiredSchema;
    private final ExcelOptions options;
    private final ExcelHelper excelHelper;
    private final Seq<StructField> parsedSchema;
    private final Integer[] tokenIndexArr;
    private final Option<Object> rowNumberPosition;
    private final Some<GenericInternalRow> requiredRow;
    private final None$ noRows;
    private final ExcelFilters pushedFilters;
    private final Function1<Cell, Object>[] valueConverters;
    private final Function1<String, BigDecimal> decimalParser;
    private final Function1<Vector<Cell>, Option<InternalRow>> parse;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Iterator<InternalRow> parseIterator(Iterator<Vector<Cell>> iterator, ExcelParser excelParser, ExcelHeaderChecker excelHeaderChecker, StructType structType) {
        return ExcelParser$.MODULE$.parseIterator(iterator, excelParser, excelHeaderChecker, structType);
    }

    @Override
    public BadRecordException badRecord(InternalRow[] partialResults, Throwable baseException) {
        return ExcelParserBase.badRecord$(this, partialResults, baseException);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ExcelOptions options() {
        return this.options;
    }

    private ExcelHelper excelHelper() {
        return this.excelHelper;
    }

    private Seq<StructField> parsedSchema() {
        return this.parsedSchema;
    }

    private Integer[] tokenIndexArr() {
        return this.tokenIndexArr;
    }

    private Option<Object> rowNumberPosition() {
        return this.rowNumberPosition;
    }

    private Some<GenericInternalRow> requiredRow() {
        return this.requiredRow;
    }

    private None$ noRows() {
        return this.noRows;
    }

    private TimestampFormatter timestampFormatter$lzycompute() {
        ExcelParser excelParser = this;
        synchronized (excelParser) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.timestampFormatter = ExcelDateTimeStringUtils$.MODULE$.getTimestampFormatter(this.options());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampFormatter() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.timestampFormatter$lzycompute();
        }
        return this.timestampFormatter;
    }

    private DateFormatter dateFormatter$lzycompute() {
        ExcelParser excelParser = this;
        synchronized (excelParser) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dateFormatter = ExcelDateTimeStringUtils$.MODULE$.getDateFormatter(this.options());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dateFormatter;
    }

    private DateFormatter dateFormatter() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.dateFormatter$lzycompute();
        }
        return this.dateFormatter;
    }

    private ExcelFilters pushedFilters() {
        return this.pushedFilters;
    }

    @Override
    public UTF8String getCurrentInput() {
        return UTF8String.fromString((String)"TODO: how to show the corrupted record?");
    }

    private Function1<Cell, Object>[] valueConverters() {
        return this.valueConverters;
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    private Function1<Cell, Object> makeConverter(String name, DataType dataType, boolean nullable) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof ByteType) {
            return (Function1<Cell, Object> & Serializable & scala.Serializable)d -> {
                CellType cellType;
                return this.nullSafeDatum((Cell)d, name, nullable, this.options(), ((Object)((Object)CellType.NUMERIC)).equals((Object)(cellType = d.getCellType())) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToByte(ExcelParser.$anonfun$makeConverter$2(x$2)) : (((Object)((Object)CellType.FORMULA)).equals((Object)cellType) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$3 -> {
                    CellType cellType = x$3.getCachedFormulaResultType();
                    if (((Object)((Object)CellType.BLANK)).equals((Object)cellType) ? true : (((Object)((Object)CellType._NONE)).equals((Object)cellType) ? true : ((Object)((Object)CellType.ERROR)).equals((Object)cellType))) {
                        return null;
                    }
                    if (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType)) {
                        return BoxesRunTime.boxToByte((byte)d.getNumericCellValue());
                    }
                    return BoxesRunTime.boxToByte(new StringOps(Predef$.MODULE$.augmentString(d.getStringCellValue())).toByte());
                } : (Function1<Cell, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToByte(ExcelParser.$anonfun$makeConverter$4(x$4))));
            };
        }
        if (dataType2 instanceof ShortType) {
            return (Function1<Cell, Object> & Serializable & scala.Serializable)d -> {
                CellType cellType;
                return this.nullSafeDatum((Cell)d, name, nullable, this.options(), ((Object)((Object)CellType.NUMERIC)).equals((Object)(cellType = d.getCellType())) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToShort(ExcelParser.$anonfun$makeConverter$6(x$5)) : (((Object)((Object)CellType.FORMULA)).equals((Object)cellType) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$6 -> {
                    CellType cellType = x$6.getCachedFormulaResultType();
                    if (((Object)((Object)CellType.BLANK)).equals((Object)cellType) ? true : (((Object)((Object)CellType._NONE)).equals((Object)cellType) ? true : ((Object)((Object)CellType.ERROR)).equals((Object)cellType))) {
                        return null;
                    }
                    if (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType)) {
                        return BoxesRunTime.boxToShort((short)d.getNumericCellValue());
                    }
                    return BoxesRunTime.boxToShort(new StringOps(Predef$.MODULE$.augmentString(d.getStringCellValue())).toShort());
                } : (Function1<Cell, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToShort(ExcelParser.$anonfun$makeConverter$8(x$7))));
            };
        }
        if (dataType2 instanceof IntegerType) {
            return (Function1<Cell, Object> & Serializable & scala.Serializable)d -> {
                CellType cellType;
                return this.nullSafeDatum((Cell)d, name, nullable, this.options(), ((Object)((Object)CellType.NUMERIC)).equals((Object)(cellType = d.getCellType())) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger(ExcelParser.$anonfun$makeConverter$10(x$8)) : (((Object)((Object)CellType.FORMULA)).equals((Object)cellType) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$9 -> {
                    CellType cellType = x$9.getCachedFormulaResultType();
                    if (((Object)((Object)CellType.BLANK)).equals((Object)cellType) ? true : (((Object)((Object)CellType._NONE)).equals((Object)cellType) ? true : ((Object)((Object)CellType.ERROR)).equals((Object)cellType))) {
                        return null;
                    }
                    if (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType)) {
                        return BoxesRunTime.boxToInteger((int)d.getNumericCellValue());
                    }
                    return BoxesRunTime.boxToInteger(new StringOps(Predef$.MODULE$.augmentString(d.getStringCellValue())).toInt());
                } : (Function1<Cell, Object> & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger(ExcelParser.$anonfun$makeConverter$12(x$10))));
            };
        }
        if (dataType2 instanceof LongType) {
            return (Function1<Cell, Object> & Serializable & scala.Serializable)d -> {
                CellType cellType;
                return this.nullSafeDatum((Cell)d, name, nullable, this.options(), ((Object)((Object)CellType.NUMERIC)).equals((Object)(cellType = d.getCellType())) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong(ExcelParser.$anonfun$makeConverter$14(x$11)) : (((Object)((Object)CellType.FORMULA)).equals((Object)cellType) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$12 -> {
                    CellType cellType = x$12.getCachedFormulaResultType();
                    if (((Object)((Object)CellType.BLANK)).equals((Object)cellType) ? true : (((Object)((Object)CellType._NONE)).equals((Object)cellType) ? true : ((Object)((Object)CellType.ERROR)).equals((Object)cellType))) {
                        return null;
                    }
                    if (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType)) {
                        return BoxesRunTime.boxToLong((long)d.getNumericCellValue());
                    }
                    return BoxesRunTime.boxToLong(new StringOps(Predef$.MODULE$.augmentString(d.getStringCellValue())).toLong());
                } : (Function1<Cell, Object> & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong(ExcelParser.$anonfun$makeConverter$16(x$13))));
            };
        }
        if (dataType2 instanceof FloatType) {
            return (Function1<Cell, Object> & Serializable & scala.Serializable)d -> {
                CellType cellType;
                return this.nullSafeDatum((Cell)d, name, nullable, this.options(), ((Object)((Object)CellType.NUMERIC)).equals((Object)(cellType = d.getCellType())) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToFloat(ExcelParser.$anonfun$makeConverter$18(x$14)) : (((Object)((Object)CellType.FORMULA)).equals((Object)cellType) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$15 -> {
                    CellType cellType = x$15.getCachedFormulaResultType();
                    if (((Object)((Object)CellType.BLANK)).equals((Object)cellType) ? true : (((Object)((Object)CellType._NONE)).equals((Object)cellType) ? true : ((Object)((Object)CellType.ERROR)).equals((Object)cellType))) {
                        return null;
                    }
                    if (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType)) {
                        return BoxesRunTime.boxToFloat((float)d.getNumericCellValue());
                    }
                    return BoxesRunTime.boxToFloat(new StringOps(Predef$.MODULE$.augmentString(d.getStringCellValue())).toFloat());
                } : (Function1<Cell, Object> & Serializable & scala.Serializable)x$16 -> {
                    String string = x$16.getStringCellValue();
                    String string2 = this.options().nanValue();
                    String string3 = string;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        return BoxesRunTime.boxToFloat(Float.NaN);
                    }
                    String string4 = this.options().negativeInf();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        return BoxesRunTime.boxToFloat(Float.NEGATIVE_INFINITY);
                    }
                    String string6 = this.options().positiveInf();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        return BoxesRunTime.boxToFloat(Float.POSITIVE_INFINITY);
                    }
                    return BoxesRunTime.boxToFloat(new StringOps(Predef$.MODULE$.augmentString(string)).toFloat());
                }));
            };
        }
        if (dataType2 instanceof DoubleType) {
            return (Function1<Cell, Object> & Serializable & scala.Serializable)d -> {
                CellType cellType;
                return this.nullSafeDatum((Cell)d, name, nullable, this.options(), ((Object)((Object)CellType.NUMERIC)).equals((Object)(cellType = d.getCellType())) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToDouble(x$17.getNumericCellValue()) : (((Object)((Object)CellType.FORMULA)).equals((Object)cellType) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$18 -> {
                    CellType cellType = x$18.getCachedFormulaResultType();
                    if (((Object)((Object)CellType.BLANK)).equals((Object)cellType) ? true : ((Object)((Object)CellType._NONE)).equals((Object)cellType)) {
                        return null;
                    }
                    if (((Object)((Object)CellType.ERROR)).equals((Object)cellType)) {
                        return BoxesRunTime.boxToDouble(Double.NaN);
                    }
                    if (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType)) {
                        return BoxesRunTime.boxToDouble(d.getNumericCellValue());
                    }
                    String string = this.excelHelper().safeCellStringValue((Cell)d);
                    String string2 = this.options().nanValue();
                    String string3 = string;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        return BoxesRunTime.boxToDouble(Double.NaN);
                    }
                    String string4 = this.options().negativeInf();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        return BoxesRunTime.boxToDouble(Double.NEGATIVE_INFINITY);
                    }
                    String string6 = this.options().positiveInf();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        return BoxesRunTime.boxToDouble(Double.POSITIVE_INFINITY);
                    }
                    return BoxesRunTime.boxToDouble(new StringOps(Predef$.MODULE$.augmentString(string)).toDouble());
                } : (Function1<Cell, Object> & Serializable & scala.Serializable)x$19 -> {
                    String string = this.excelHelper().safeCellStringValue((Cell)x$19);
                    String string2 = this.options().nanValue();
                    String string3 = string;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        return BoxesRunTime.boxToDouble(Double.NaN);
                    }
                    String string4 = this.options().negativeInf();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        return BoxesRunTime.boxToDouble(Double.NEGATIVE_INFINITY);
                    }
                    String string6 = this.options().positiveInf();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        return BoxesRunTime.boxToDouble(Double.POSITIVE_INFINITY);
                    }
                    return BoxesRunTime.boxToDouble(new StringOps(Predef$.MODULE$.augmentString(string)).toDouble());
                }));
            };
        }
        if (dataType2 instanceof BooleanType) {
            return (Function1<Cell, Object> & Serializable & scala.Serializable)d -> {
                CellType cellType;
                return this.nullSafeDatum((Cell)d, name, nullable, this.options(), ((Object)((Object)CellType.BOOLEAN)).equals((Object)(cellType = d.getCellType())) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean(x$20.getBooleanCellValue()) : (((Object)((Object)CellType.FORMULA)).equals((Object)cellType) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$21 -> {
                    CellType cellType = x$21.getCachedFormulaResultType();
                    if (((Object)((Object)CellType.BLANK)).equals((Object)cellType) ? true : (((Object)((Object)CellType._NONE)).equals((Object)cellType) ? true : ((Object)((Object)CellType.ERROR)).equals((Object)cellType))) {
                        return null;
                    }
                    if (((Object)((Object)CellType.BOOLEAN)).equals((Object)cellType)) {
                        return BoxesRunTime.boxToBoolean(d.getBooleanCellValue());
                    }
                    return BoxesRunTime.boxToBoolean(new StringOps(Predef$.MODULE$.augmentString(d.getStringCellValue())).toBoolean());
                } : (Function1<Cell, Object> & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean(ExcelParser.$anonfun$makeConverter$28(x$22))));
            };
        }
        if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            return (Function1<Cell, Object> & Serializable & scala.Serializable)d -> this.nullSafeDatum((Cell)d, name, nullable, this.options(), (Function1<Cell, Object> & Serializable & scala.Serializable)datum -> {
                CellType cellType = datum.getCellType();
                if (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType) ? true : ((Object)((Object)CellType.FORMULA)).equals((Object)cellType)) {
                    return Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(datum.getNumericCellValue()), decimalType.precision(), decimalType.scale());
                }
                return Decimal$.MODULE$.apply(this.decimalParser().apply(datum.getStringCellValue()), decimalType.precision(), decimalType.scale());
            });
        }
        if (dataType2 instanceof TimestampType) {
            return (Function1<Cell, Object> & Serializable & scala.Serializable)d -> this.nullSafeDatum((Cell)d, name, nullable, this.options(), (Function1<Cell, Object> & Serializable & scala.Serializable)datum -> {
                Long l;
                if (DateUtil.isCellDateFormatted(datum)) {
                    return BoxesRunTime.boxToLong(datum.getDateCellValue().getTime() * 1000L);
                }
                CellType cellType = datum.getCellType();
                if (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType) ? true : ((Object)((Object)CellType.FORMULA)).equals((Object)cellType)) {
                    return BoxesRunTime.boxToLong((long)datum.getNumericCellValue());
                }
                String v = this.excelHelper().safeCellStringValue((Cell)datum);
                try {
                    l = BoxesRunTime.boxToLong(this.timestampFormatter().parse(v));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = option.get();
                        l = ExcelDateTimeStringUtils$.MODULE$.stringToTimestamp(v, this.options().zoneId()).getOrElse((Function0<Nothing$> & Serializable & scala.Serializable)() -> {
                            throw e;
                        });
                    }
                    throw throwable;
                }
                return l;
            });
        }
        if (dataType2 instanceof DateType) {
            return (Function1<Cell, Object> & Serializable & scala.Serializable)d -> this.nullSafeDatum((Cell)d, name, nullable, this.options(), (Function1<Cell, Object> & Serializable & scala.Serializable)datum -> {
                Integer n;
                if (DateUtil.isCellDateFormatted(datum)) {
                    return BoxesRunTime.boxToInteger(DateTimeUtils$.MODULE$.fromJavaDate(new Date(datum.getDateCellValue().getTime())));
                }
                CellType cellType = datum.getCellType();
                if (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType) ? true : ((Object)((Object)CellType.FORMULA)).equals((Object)cellType)) {
                    return BoxesRunTime.boxToInteger((int)datum.getNumericCellValue());
                }
                String v = this.excelHelper().safeCellStringValue((Cell)datum);
                try {
                    n = BoxesRunTime.boxToInteger(this.dateFormatter().parse(v));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = option.get();
                        n = ExcelDateTimeStringUtils$.MODULE$.stringToDate(v, this.options().zoneId()).getOrElse((Function0<Nothing$> & Serializable & scala.Serializable)() -> {
                            throw e;
                        });
                    }
                    throw throwable;
                }
                return n;
            });
        }
        if (dataType2 instanceof StringType) {
            return (Function1<Cell, Object> & Serializable & scala.Serializable)d -> this.nullSafeDatum((Cell)d, name, nullable, this.options(), (Function1<Cell, Object>)(Function1<Cell, UTF8String> & Serializable & scala.Serializable)datum -> UTF8String.fromString((String)this.excelHelper().safeCellStringValue((Cell)datum)));
        }
        throw new RuntimeException(new StringBuilder(18).append("Unsupported type: ").append(dataType.typeName()).toString());
    }

    private Object nullSafeDatum(Cell datum, String name, boolean nullable, ExcelOptions options, Function1<Cell, Object> converter) {
        Object ret;
        Object object;
        CellType cellType = datum.getCellType();
        CellType cellType2 = CellType.FORMULA;
        CellType cellType3 = !(cellType != null ? !((Object)((Object)cellType)).equals((Object)cellType2) : cellType2 != null) ? datum.getCachedFormulaResultType() : datum.getCellType();
        CellType cellType4 = cellType3;
        if (((Object)((Object)CellType.BLANK)).equals((Object)cellType4) ? true : ((Object)((Object)CellType._NONE)).equals((Object)cellType4)) {
            object = null;
        } else if (((Object)((Object)CellType.ERROR)).equals((Object)cellType4)) {
            object = options.useNullForErrorCells() ? null : converter.apply(datum);
        } else if (((Object)((Object)CellType.STRING)).equals((Object)cellType4)) {
            String string = datum.getStringCellValue();
            String string2 = options.nullValue();
            object = !(string != null ? !string.equals(string2) : string2 != null) ? null : converter.apply(datum);
        } else {
            object = ret = converter.apply(datum);
        }
        if (ret == null && !nullable) {
            throw new RuntimeException(new StringBuilder(44).append("null value found but field ").append(name).append(" is not nullable.").toString());
        }
        return ret;
    }

    public Function1<Vector<Cell>, Option<InternalRow>> parse() {
        return this.parse;
    }

    private Option<InternalRow> convert(Vector<Cell> tokens) {
        if (tokens == null) {
            throw this.badRecord((InternalRow[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InternalRow.class)), new RuntimeException("Malformed Excel record"));
        }
        Option badRecordException = tokens.length() != this.parsedSchema().length() ? new Some<RuntimeException>(new RuntimeException("Malformed Excel record")) : None$.MODULE$;
        GenericInternalRow row = this.requiredRow().get();
        boolean skipRow = false;
        for (int i = 0; i < this.requiredSchema.length(); ++i) {
            try {
                if (skipRow) {
                    row.setNullAt(i);
                    continue;
                }
                if (this.rowNumberPosition().isDefined() && i == BoxesRunTime.unboxToInt(this.rowNumberPosition().get())) {
                    if (tokens.isEmpty()) {
                        row.setNullAt(i);
                    } else {
                        row.update(i, (Object)BoxesRunTime.boxToInteger(tokens.head().getRowIndex()));
                    }
                } else {
                    row.update(i, this.valueConverters()[i].apply(tokens.apply(Predef$.MODULE$.Integer2int(this.tokenIndexArr()[i]))));
                }
                if (!this.pushedFilters().skipRow((InternalRow)row, i)) continue;
                skipRow = true;
                continue;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = option.get();
                    badRecordException = badRecordException.orElse((Function0<Some> & Serializable & scala.Serializable)() -> new Some<Throwable>(e));
                    row.setNullAt(i);
                    continue;
                }
                throw throwable;
            }
        }
        if (skipRow) {
            return this.noRows();
        }
        if (badRecordException.isDefined()) {
            throw this.badRecord((InternalRow[])Option$.MODULE$.option2Iterable(this.requiredRow()).toArray(ClassTag$.MODULE$.apply(InternalRow.class)), (Throwable)badRecordException.get());
        }
        return this.requiredRow();
    }

    public static final /* synthetic */ boolean $anonfun$parsedSchema$1(ExcelParser $this, StructField x$1) {
        String string = x$1.name();
        String string2 = $this.options().columnNameOfRowNumber().get();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ byte $anonfun$makeConverter$2(Cell x$2) {
        return (byte)x$2.getNumericCellValue();
    }

    public static final /* synthetic */ byte $anonfun$makeConverter$4(Cell x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4.getStringCellValue())).toByte();
    }

    public static final /* synthetic */ short $anonfun$makeConverter$6(Cell x$5) {
        return (short)x$5.getNumericCellValue();
    }

    public static final /* synthetic */ short $anonfun$makeConverter$8(Cell x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7.getStringCellValue())).toShort();
    }

    public static final /* synthetic */ int $anonfun$makeConverter$10(Cell x$8) {
        return (int)x$8.getNumericCellValue();
    }

    public static final /* synthetic */ int $anonfun$makeConverter$12(Cell x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10.getStringCellValue())).toInt();
    }

    public static final /* synthetic */ long $anonfun$makeConverter$14(Cell x$11) {
        return (long)x$11.getNumericCellValue();
    }

    public static final /* synthetic */ long $anonfun$makeConverter$16(Cell x$13) {
        return new StringOps(Predef$.MODULE$.augmentString(x$13.getStringCellValue())).toLong();
    }

    public static final /* synthetic */ float $anonfun$makeConverter$18(Cell x$14) {
        return (float)x$14.getNumericCellValue();
    }

    public static final /* synthetic */ boolean $anonfun$makeConverter$28(Cell x$22) {
        return new StringOps(Predef$.MODULE$.augmentString(x$22.getStringCellValue())).toBoolean();
    }

    public ExcelParser(StructType dataSchema, StructType requiredSchema, ExcelOptions options, Seq<Filter> filters) {
        this.dataSchema = dataSchema;
        this.requiredSchema = requiredSchema;
        this.options = options;
        Logging.$init$((Logging)this);
        ExcelParserBase.$init$(this);
        Predef$.MODULE$.require(requiredSchema.toSet().subsetOf(dataSchema.toSet()), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(56).append("requiredSchema (").append($this.requiredSchema.catalogString()).append(") should be the subset of ").append("dataSchema (").append($this.dataSchema.catalogString()).append(").").toString());
        this.excelHelper = ExcelHelper$.MODULE$.apply(options);
        this.parsedSchema = options.columnNameOfRowNumber().isDefined() ? (Seq)dataSchema.filter((Function1<StructField, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(ExcelParser.$anonfun$parsedSchema$1(this, x$1))) : dataSchema;
        this.tokenIndexArr = (Integer[])((TraversableOnce)requiredSchema.map((Function1<StructField, Integer> & Serializable & scala.Serializable)f -> this.parsedSchema().indexOf(f), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Integer.class));
        this.rowNumberPosition = options.columnNameOfRowNumber().isDefined() ? new Some<Integer>(BoxesRunTime.boxToInteger(requiredSchema.fieldIndex(options.columnNameOfRowNumber().get()))) : None$.MODULE$;
        this.requiredRow = new Some<GenericInternalRow>(new GenericInternalRow(requiredSchema.length()));
        this.noRows = None$.MODULE$;
        this.pushedFilters = new ExcelFilters(filters, requiredSchema);
        this.valueConverters = (Function1[])((TraversableOnce)requiredSchema.map((Function1<StructField, Function1> & Serializable & scala.Serializable)f -> this.makeConverter(f.name(), f.dataType(), f.nullable()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function1.class));
        this.decimalParser = (Function1<String, BigDecimal> & Serializable & scala.Serializable)s -> new BigDecimal((String)s);
        this.parse = requiredSchema.isEmpty() ? (Function1<Vector, Option> & Serializable & scala.Serializable)x$23 -> new Some<InternalRow>(InternalRow$.MODULE$.empty()) : (Function1<Vector, Option> & Serializable & scala.Serializable)input -> this.convert((Vector<Cell>)input);
    }

    public ExcelParser(StructType dataSchema, StructType requiredSchema, ExcelOptions options) {
        this(dataSchema, requiredSchema, options, Nil$.MODULE$);
    }

    public ExcelParser(StructType schema, ExcelOptions options) {
        this(schema, schema, options);
    }
}

