/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.xlsx.impl;

import com.github.pjfanning.xlsx.impl.BaseEvaluationWorkbook;
import com.github.pjfanning.xlsx.impl.CurrentRowEvaluationSheet;
import com.github.pjfanning.xlsx.impl.OoxmlEvaluationCell;
import org.apache.poi.ss.formula.EvaluationCell;
import org.apache.poi.ss.formula.EvaluationSheet;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaType;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.Internal;

@Internal
public final class CurrentRowEvaluationWorkbook
extends BaseEvaluationWorkbook {
    private final Row _row;

    CurrentRowEvaluationWorkbook(Workbook wb, Row row) {
        super(wb);
        this._row = row;
    }

    @Override
    public int getSheetIndex(EvaluationSheet evalSheet) {
        Sheet sheet = ((CurrentRowEvaluationSheet)evalSheet).getSheet();
        return this._uBook.getSheetIndex(sheet);
    }

    @Override
    public EvaluationSheet getSheet(int sheetIndex) {
        return new CurrentRowEvaluationSheet(this._uBook.getSheetAt(sheetIndex), this._row);
    }

    @Override
    public Ptg[] getFormulaTokens(EvaluationCell evalCell) {
        Cell cell = ((OoxmlEvaluationCell)evalCell).getCell();
        return FormulaParser.parse(cell.getCellFormula(), this, FormulaType.CELL, this._uBook.getSheetIndex(cell.getSheet()));
    }
}

