/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import org.apache.poi.xslf.usermodel.XSLFAutoShape;
import org.apache.poi.xslf.usermodel.XSLFChart;
import org.apache.poi.xslf.usermodel.XSLFConnectorShape;
import org.apache.poi.xslf.usermodel.XSLFFreeformShape;
import org.apache.poi.xslf.usermodel.XSLFGroupShape;
import org.apache.poi.xslf.usermodel.XSLFObjectShape;
import org.apache.poi.xslf.usermodel.XSLFPictureShape;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFTable;
import org.apache.poi.xslf.usermodel.XSLFTextBox;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.presentationml.x2006.main.CTConnector;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGraphicalObjectFrame;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPicture;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;

public class XSLFDrawing {
    private XSLFSheet _sheet;
    private CTGroupShape _spTree;

    XSLFDrawing(XSLFSheet sheet, CTGroupShape spTree) {
        XmlObject[] cNvPr;
        this._sheet = sheet;
        this._spTree = spTree;
        for (XmlObject o : cNvPr = sheet.getSpTree().selectPath("declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' .//*/p:cNvPr")) {
            if (!(o instanceof CTNonVisualDrawingProps)) continue;
            CTNonVisualDrawingProps p = (CTNonVisualDrawingProps)o;
            sheet.registerShapeId((int)p.getId());
        }
    }

    public XSLFAutoShape createAutoShape() {
        CTShape sp2 = this._spTree.addNewSp();
        sp2.set(XSLFAutoShape.prototype(this._sheet.allocateShapeId()));
        XSLFAutoShape shape = new XSLFAutoShape(sp2, this._sheet);
        shape.setAnchor(new Rectangle2D.Double());
        return shape;
    }

    public XSLFFreeformShape createFreeform() {
        CTShape sp2 = this._spTree.addNewSp();
        sp2.set(XSLFFreeformShape.prototype(this._sheet.allocateShapeId()));
        XSLFFreeformShape shape = new XSLFFreeformShape(sp2, this._sheet);
        shape.setAnchor(new Rectangle2D.Double());
        return shape;
    }

    public XSLFTextBox createTextBox() {
        CTShape sp2 = this._spTree.addNewSp();
        sp2.set(XSLFTextBox.prototype(this._sheet.allocateShapeId()));
        XSLFTextBox shape = new XSLFTextBox(sp2, this._sheet);
        shape.setAnchor(new Rectangle2D.Double());
        return shape;
    }

    public XSLFConnectorShape createConnector() {
        CTConnector sp2 = this._spTree.addNewCxnSp();
        sp2.set(XSLFConnectorShape.prototype(this._sheet.allocateShapeId()));
        XSLFConnectorShape shape = new XSLFConnectorShape(sp2, this._sheet);
        shape.setAnchor(new Rectangle2D.Double());
        shape.setLineColor(Color.black);
        shape.setLineWidth(0.75);
        return shape;
    }

    public XSLFGroupShape createGroup() {
        CTGroupShape sp2 = this._spTree.addNewGrpSp();
        sp2.set(XSLFGroupShape.prototype(this._sheet.allocateShapeId()));
        XSLFGroupShape shape = new XSLFGroupShape(sp2, this._sheet);
        shape.setAnchor(new Rectangle2D.Double());
        return shape;
    }

    public XSLFPictureShape createPicture(String rel) {
        CTPicture sp2 = this._spTree.addNewPic();
        sp2.set(XSLFPictureShape.prototype(this._sheet.allocateShapeId(), rel));
        XSLFPictureShape shape = new XSLFPictureShape(sp2, this._sheet);
        shape.setAnchor(new Rectangle2D.Double());
        return shape;
    }

    public XSLFTable createTable() {
        CTGraphicalObjectFrame sp2 = this._spTree.addNewGraphicFrame();
        sp2.set(XSLFTable.prototype(this._sheet.allocateShapeId()));
        XSLFTable shape = new XSLFTable(sp2, this._sheet);
        shape.setAnchor(new Rectangle2D.Double());
        return shape;
    }

    public void addChart(String rID, Rectangle2D rect2D) {
        CTGraphicalObjectFrame sp2 = this._spTree.addNewGraphicFrame();
        sp2.set(XSLFChart.prototype(this._sheet.allocateShapeId(), rID, rect2D));
    }

    public XSLFObjectShape createOleShape(String pictureRel) {
        CTGraphicalObjectFrame sp2 = this._spTree.addNewGraphicFrame();
        sp2.set(XSLFObjectShape.prototype(this._sheet.allocateShapeId(), pictureRel));
        XSLFObjectShape shape = new XSLFObjectShape(sp2, this._sheet);
        shape.setAnchor(new Rectangle2D.Double());
        return shape;
    }
}

