/*
 * Decompiled with CFR 0.152.
 */
package com.daioware.dependencyManager;

import com.daioware.dependencyManager.Instance;
import com.daioware.dependencyManager.PackageManager;
import com.daioware.dependencyManager.SetterMethodNotFoundException;
import com.daioware.dependencyManager.annotations.AfterConstructor;
import com.daioware.dependencyManager.annotations.AfterSetters;
import com.daioware.dependencyManager.annotations.Bean;
import com.daioware.dependencyManager.annotations.Inject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class DependencyManager {
    protected static final Object[] EMPTY_ARGS = new Object[0];
    private List<String> packages;
    private List<Class<Object>> classes;
    private List<Instance> instances;

    public DependencyManager(List<String> packages) {
        this.packages = packages;
        this.classes = new ArrayList<Class<Object>>();
        this.instances = new ArrayList<Instance>();
    }

    public DependencyManager() {
        this(new ArrayList<String>());
    }

    public DependencyManager(String packageName) {
        this();
        this.packages.add(packageName);
    }

    public List<Class<Object>> getClasses() {
        return this.classes;
    }

    public List<String> getPackages() {
        return this.packages;
    }

    public void setPackages(List<String> packages) {
        this.packages = packages;
    }

    public boolean addPackage(String packageName) {
        return this.packages.contains(packageName) ? false : this.packages.add(packageName);
    }

    public void clearPackages() {
        this.packages.clear();
    }

    public void clearClasses() {
        this.classes.clear();
    }

    public void clearInstances() {
        this.classes.clear();
    }

    public void browse() throws ClassNotFoundException {
        for (String packageName : this.packages) {
            for (Class clazz : PackageManager.getClasses(packageName)) {
                if (this.classes.contains(clazz)) continue;
                this.classes.add(clazz);
            }
        }
    }

    protected boolean implementInterface(Class clazz, Class interfaceItem) {
        for (Class<?> interfaceAux : clazz.getInterfaces()) {
            if (!interfaceAux.equals(interfaceItem)) continue;
            return true;
        }
        return false;
    }

    protected boolean implementInterface(Class clazz, Class interfaceItem, String beanName) {
        boolean implement = this.implementInterface(clazz, interfaceItem);
        return implement && this.equalsBeansName(clazz, beanName);
    }

    protected boolean equalsBeansName(String bean1, String bean2) {
        return bean1.equals("") || bean2.equals("") ? true : bean1.equals(bean2);
    }

    protected boolean equalsBeansName(Class bean1Class, String bean2) {
        return this.equalsBeansName(this.getBeanName(bean1Class), bean2);
    }

    protected Instance newInstance(Class clazz, String beanName) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SetterMethodNotFoundException {
        Instance obj;
        if (clazz.isInterface()) {
            Instance obj2 = null;
            for (Class<Object> auxClazz : this.classes) {
                if (!this.implementInterface(auxClazz, clazz, beanName) || (obj2 = this.findByClassAndName(auxClazz, beanName)) != null) continue;
                obj2 = new Instance(auxClazz, beanName, this.newInstance(auxClazz, "").getElement());
                this.executeAfterConstructor(obj2.getElement());
            }
            if (obj2 == null) {
                throw new InstantiationException("Could not find an implementation of " + clazz.getName() + " with the bean name " + beanName);
            }
            return obj2;
        }
        Constructor injectedConstructor = this.getInjectedConstructor(clazz);
        if (injectedConstructor != null) {
            obj = this.createInjectedConstructorInstance(clazz, injectedConstructor);
        } else if (this.getBeanName(clazz).equals(beanName) || "".equals(beanName)) {
            this.validateClassBeforeInstantation(clazz);
            obj = new Instance(clazz, this.getBeanName(clazz), clazz.newInstance());
        } else {
            throw new InstantiationException("Couldn't find a bean of type " + clazz.getName() + " and bean name " + beanName);
        }
        this.executeAfterConstructor(obj.getElement());
        return obj;
    }

    protected void validateClassBeforeInstantation(Class clazz) throws InstantiationException {
        if (this.isAbstractClass(clazz)) {
            throw new InstantiationException("Trying to instanciate an abstract class: " + clazz.getName());
        }
    }

    private boolean isAbstractClass(Class clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    protected void executeAfterConstructor(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.executeMethodsWithAnno(object, AfterConstructor.class);
    }

    protected void executeAfterSetters(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.executeMethodsWithAnno(object, AfterSetters.class);
    }

    protected void executeMethodsWithAnno(Object object, Class annotationClass) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (Method method : object.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(annotationClass)) continue;
            method.setAccessible(true);
            method.invoke(object, EMPTY_ARGS);
            method.setAccessible(false);
        }
    }

    protected Instance createInjectedConstructorInstance(Class clazz, Constructor injectedConstructor) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SetterMethodNotFoundException {
        Parameter[] parameters = injectedConstructor.getParameters();
        Object[] parametersFound = new Object[parameters.length];
        int i = 0;
        for (Parameter parameter : injectedConstructor.getParameters()) {
            Instance instance = this.getInstance(parameter);
            parametersFound[i++] = instance.getElement();
        }
        this.validateClassBeforeInstantation(clazz);
        return new Instance(clazz, this.getBeanName(clazz), injectedConstructor.newInstance(parametersFound), true);
    }

    protected Instance getInstance(Parameter parameter) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SetterMethodNotFoundException {
        Inject inject = parameter.getAnnotation(Inject.class);
        return inject != null ? this.getInstance(parameter.getType(), inject) : this.getInstance(parameter.getType(), "");
    }

    protected Constructor getInjectedConstructor(Class obj) {
        for (Constructor<?> c : obj.getDeclaredConstructors()) {
            if (!c.isAnnotationPresent(Inject.class)) continue;
            return c;
        }
        return null;
    }

    protected void setFieldValue(Class clazz, Field field, Object object) throws InstantiationException, IllegalAccessException, SetterMethodNotFoundException, IllegalArgumentException, InvocationTargetException {
        Inject injectAnno = field.getAnnotation(Inject.class);
        if (injectAnno == null) {
            Method getterMethod = this.findGetter(clazz, field);
            if (getterMethod != null) {
                injectAnno = getterMethod.getAnnotation(Inject.class);
                Method setterMethod = this.findSetter(clazz, field);
                if (setterMethod == null) {
                    throw new SetterMethodNotFoundException("Could not find the setter method of " + clazz.getName() + "." + field.getName());
                }
                setterMethod.setAccessible(true);
                setterMethod.invoke(object, this.getInstance(field, injectAnno).getElement());
                setterMethod.setAccessible(false);
            }
        } else {
            Instance instance = this.getInstance(field, injectAnno);
            field.setAccessible(true);
            field.set(object, instance.getElement());
            field.setAccessible(false);
        }
    }

    public void connectDependencies() throws IllegalArgumentException, IllegalAccessException, InstantiationException, SetterMethodNotFoundException, InvocationTargetException {
        for (Class<Object> clazz : this.classes) {
            if (!clazz.isAnnotationPresent(Bean.class)) continue;
            Instance instance = this.newInstance(clazz, this.getBeanName(clazz));
            this.instances.add(instance);
            Object object = instance.getElement();
            for (Field field : this.getDeclaredFields(clazz)) {
                this.setFieldValue(clazz, field, object);
            }
            this.executeAfterSetters(object);
        }
    }

    private Instance getInstance(Class clazz, Inject injectAnno) throws InstantiationException, IllegalAccessException, SetterMethodNotFoundException, IllegalArgumentException, InvocationTargetException {
        return this.getInstance(clazz, injectAnno.name());
    }

    private Instance getInstance(Class clazz, String name) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SetterMethodNotFoundException {
        Instance element = "".equals(name) ? this.findByClass(clazz) : this.findByClassAndName(clazz, name);
        if (element == null) {
            element = this.createInstance(clazz, name);
            this.instances.add(element);
        }
        return element;
    }

    private Instance getInstance(Field field, Inject injectAnno) throws InstantiationException, IllegalAccessException, SetterMethodNotFoundException, IllegalArgumentException, InvocationTargetException {
        return this.getInstance(field.getType(), injectAnno);
    }

    protected String getInjectName(Field clazz) {
        Inject injectAnno = clazz.getAnnotation(Inject.class);
        return injectAnno != null ? injectAnno.name() : "";
    }

    protected String getBeanName(Class clazz) {
        Bean bean = clazz.getAnnotation(Bean.class);
        return bean != null ? bean.name() : "";
    }

    protected List<Method> findAccessor(Class<? extends Field> clazz, Field field, String which) {
        String fieldName = field.getName();
        LinkedList<Method> methods = new LinkedList<Method>();
        String methodName = which + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        LinkedList<Class<? extends Field>> classes = new LinkedList<Class<? extends Field>>();
        classes.add(clazz);
        for (Class<? extends Field> superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            classes.add(superClass);
        }
        for (Class clazz2 : classes) {
            for (Method method : clazz2.getDeclaredMethods()) {
                if (!methodName.equals(method.getName())) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    protected Method findGetter(Class clazz, Field field) {
        List<Method> methods = this.findAccessor(clazz, field, "get");
        for (Method method : methods) {
            if (method.getParameterCount() != 0 || !method.getReturnType().equals(field.getType())) continue;
            return method;
        }
        return null;
    }

    protected Method findSetter(Class clazz, Field field) {
        List<Method> methods = this.findAccessor(clazz, field, "set");
        for (Method method : methods) {
            Parameter[] parameters = method.getParameters();
            if (method.getParameterCount() != 1 || !field.getType().equals(parameters.length >= 1 ? parameters[0].getType() : null)) continue;
            return method;
        }
        return null;
    }

    private Instance createInstance(Class<? extends Field> clazz, String beanName) throws InstantiationException, IllegalAccessException, SetterMethodNotFoundException, IllegalArgumentException, InvocationTargetException {
        Instance instance = this.newInstance(clazz, beanName);
        Object object = instance.getElement();
        for (Field field : this.getDeclaredFields(clazz)) {
            this.setFieldValue(clazz, field, object);
        }
        this.executeAfterSetters(object);
        return instance;
    }

    private Instance findByClassAndName(Class clazz, String name) {
        if (clazz.isInterface()) {
            for (Instance instance : this.instances) {
                if (!this.implementInterface(instance.getClazz(), clazz, name)) continue;
                return instance;
            }
        } else {
            for (Instance instance : this.instances) {
                if (!this.getAllClasses(instance.getClazz()).contains(clazz) || !this.equalsBeansName(instance.getName(), name)) continue;
                return instance;
            }
        }
        return null;
    }

    public List<Class> getAllClasses(Class clazz) {
        LinkedList<Class> classes = new LinkedList<Class>();
        classes.add(clazz);
        for (Class superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            classes.add(superClass);
        }
        return classes;
    }

    private Instance findByClass(Class clazz) {
        return this.findByClassAndName(clazz, "");
    }

    public <T> T getBean(Class<T> clazz) {
        Instance instance = this.findByClass(clazz);
        return (T)(instance != null ? instance.getElement() : null);
    }

    public <T> T getBean(Class<T> clazz, String name) {
        Instance instance = this.findByClassAndName(clazz, name);
        return (T)(instance != null ? instance.getElement() : null);
    }

    public List<Instance> getInstances() {
        return this.instances;
    }

    public List<Field> getDeclaredFields(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>(clazz.getDeclaredFields().length);
        Stack classes = new Stack();
        classes.push(clazz);
        for (Class superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            classes.push(superClass);
        }
        while (!classes.isEmpty()) {
            for (Field field : ((Class)classes.pop()).getDeclaredFields()) {
                fields.add(field);
            }
        }
        return fields;
    }
}

