/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.accessor;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.accessor.BaseAccessor;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.util.UtilBinaryToUnicodeInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryAccessor
extends BaseAccessor {
    int maxFieldSize;

    protected BinaryAccessor(int maxFieldSize) {
        this.maxFieldSize = maxFieldSize;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        byte[] ret = super.getBytes();
        if (ret != null) {
            int len = ret.length;
            if (this.maxFieldSize > 0 && len > this.maxFieldSize) {
                len = this.maxFieldSize;
                byte[] val = new byte[len];
                System.arraycopy(ret, 0, val, 0, len);
                return val;
            }
        }
        return ret;
    }

    @Override
    public boolean getBoolean() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? false : this.dataBuffer[0] != 0;
    }

    @Override
    public byte getByte() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? (byte)0 : this.dataBuffer[0];
    }

    @Override
    public short getShort() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? (short)0 : Convertion.bytesToShort(this.dataBuffer);
    }

    @Override
    public int getInt() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? 0 : Convertion.bytesToInt(this.dataBuffer);
    }

    @Override
    public long getLong() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? 0L : Convertion.bytesToLong(this.dataBuffer);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? null : new DmdbInputStream(this.dataBuffer, this.serverEncoding);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? null : new DmdbInputStream(this.dataBuffer, this.serverEncoding);
    }

    @Override
    public InputStream getUnicodeStream() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? null : new UtilBinaryToUnicodeInputStream(new ByteArrayInputStream(this.dataBuffer));
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? null : new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.dataBuffer)));
    }

    @Override
    public String getString() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? null : Convertion.bytesToHexString(this.dataBuffer);
    }

    @Override
    public Object getObjectInner(Map<String, Class<?>> typeMap) throws SQLException {
        return this.getBytes();
    }
}

