/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.binder;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.binder.DmBinder;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbType;
import dm.sql.DmdbTimestamp;
import java.sql.SQLException;
import java.util.Calendar;

public class DmLongBinder
extends DmBinder {
    public DmLongBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
    }

    void init() {
        this.recDType = 8;
        this.recPrec = 8;
        this.recScale = 0;
    }

    void checkType(int irow, int icol, boolean forBatch) throws SQLException {
        if (this.m_checkType) {
            return;
        }
        this.m_checkType = true;
        if (this.paramsDesc == null) {
            this.paramsDesc = this.pstmt.getParamsDesc();
        }
        byte typeFlag = this.paramsDesc[icol].getTypeFlag();
        int dType = this.paramsDesc[icol].getDType();
        int prec = this.paramsDesc[icol].getPrec();
        int scale = this.paramsDesc[icol].getScale();
        byte ioType = this.paramsDesc[icol].getIOType();
        if (ioType != 1 && typeFlag != 1) {
            if (!forBatch && this.canUseRecommendType(irow, icol, dType)) {
                this.destDType = dType;
                this.destPrec = prec;
                this.destScale = scale;
            } else {
                this.destDType = this.recDType;
                this.destPrec = this.recPrec;
                this.destScale = this.recScale;
            }
        } else {
            this.destDType = dType;
            this.destPrec = prec;
            this.destScale = scale;
        }
        this.destIoType = ioType;
        this.srcScale = scale;
    }

    boolean canUseRecommendType(int irow, int icol, int recommendType) {
        long value = (Long)this.pstmt.getParamObject(irow, icol);
        switch (recommendType) {
            case 7: {
                if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) break;
                return true;
            }
        }
        return false;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        Object obj = this.pstmt.getParamObject(irow, icol);
        byte[] ret = null;
        ret = this.isDiffParamObjectType() && !(obj instanceof Long) ? this.castToDestType(obj, this.destDType, this.destPrec, this.destScale, this.serverEncoding, this.ltz, this.dbTz, this.paramsDesc[icol].getTypeDescriptor()) : DmLongBinder.toDbBytes((Long)obj, this.destDType, this.destPrec, this.destScale, this.serverEncoding, this.ltz, this.dbTz, this.defaultCalendar);
        return msg.appendBytesWithLen2(ret, 0, ret.length);
    }

    public static byte[] toDbBytes(long x, int destDType, int destPrec, int destScale, String serverEncoding, short ltz, short dbTz, Calendar defaultCalendar) throws SQLException {
        byte[] ret = null;
        if (DmdbType.isBFileType(destDType, destPrec, destScale)) {
            DBError.throwSQLException(6007);
        } else {
            switch (destDType) {
                case 8: {
                    ret = Convertion.longToByteArray(x);
                    break;
                }
                case 3: 
                case 13: {
                    ret = Convertion.booleanToByteArray(x != 0L);
                    break;
                }
                case 5: {
                    if (x > 127L || x < -128L) {
                        DBError.throwSQLException(6004);
                    }
                    ret = Convertion.byteToByteArray((byte)x);
                    break;
                }
                case 6: {
                    if (x > 32767L || x < -32768L) {
                        DBError.throwSQLException(6004);
                    }
                    ret = Convertion.shortToByteArray((int)x);
                    break;
                }
                case 7: {
                    if (x > Integer.MAX_VALUE || x < Integer.MIN_VALUE) {
                        DBError.throwSQLException(6004);
                    }
                    ret = Convertion.intToByteArray((int)x);
                    break;
                }
                case 10: {
                    ret = Convertion.floatToByteArray(x);
                    break;
                }
                case 11: {
                    ret = Convertion.doubleToByteArray(x);
                    break;
                }
                case 9: {
                    ret = Convertion.BigDecimalToByteArray(String.valueOf(x), destPrec, destScale);
                    break;
                }
                case 0: 
                case 1: {
                    ret = Convertion.String_char_2CType(String.valueOf(x), destPrec, destDType, serverEncoding);
                    break;
                }
                case 2: 
                case 19: {
                    ret = Convertion.String_varchar_2CType(String.valueOf(x), destPrec, destDType, serverEncoding);
                    break;
                }
                case 17: {
                    ret = Convertion.longToBinary(x, destPrec);
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    ret = DmdbTimestamp.encodeByDateNumber(x, destDType, destScale, defaultCalendar, ltz, dbTz);
                    break;
                }
                default: {
                    DBError.throwSQLException(6007);
                }
            }
        }
        return ret;
    }
}

