/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.log;

import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.log.LogBuffer;
import dm.jdbc.log.LogWriter;
import dm.jdbc.processor.BaseFlusher;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

class LogFlusher
extends BaseFlusher {
    private final int QUEUE_SIZE = DmSvcConf.logFlusherQueueSize;
    private final LinkedBlockingQueue<LogBuffer> QUEUE = new LinkedBlockingQueue(this.QUEUE_SIZE);

    private LogFlusher() {
        super("LogFlusher");
    }

    public static LogFlusher getInstance() {
        return LogFlusherHolder.instance;
    }

    protected String getFileName() {
        return "dm_jdbc." + super.getFileName();
    }

    protected String getFilePath() {
        return DmSvcConf.logDir;
    }

    protected int getFlushFreq() {
        return 1;
    }

    protected void doFlush() throws Exception {
        LogBuffer buffer = null;
        if (this.QUEUE.size() == 0) {
            LogWriter.submitBuffer();
        }
        while ((buffer = this.QUEUE.poll(DmSvcConf.logFlushFreq, TimeUnit.SECONDS)) != null) {
            this.writeAndFlush(buffer.getLogs(), 0, buffer.getOffset());
            buffer.reset();
            LogBuffer.returnBuffer(buffer);
        }
    }

    protected void beforeExit() throws Exception {
        LogBuffer buffer = null;
        LogWriter.submitBuffer();
        while ((buffer = this.QUEUE.poll()) != null) {
            this.writeAndFlush(buffer.getLogs(), 0, buffer.getOffset());
            buffer.reset();
            LogBuffer.returnBuffer(buffer);
        }
    }

    public void submit(LogBuffer buffer) {
        try {
            this.QUEUE.put(buffer);
        }
        catch (InterruptedException interruptedException) {}
    }

    /* synthetic */ LogFlusher(LogFlusher logFlusher) {
        this();
    }

    private static class LogFlusherHolder {
        private static final LogFlusher instance = new LogFlusher(null);

        private LogFlusherHolder() {
        }
    }
}

