/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.pool;

import dm.jdbc.pool.DmdbConnectionCache;
import dm.jdbc.pool.DmdbConnectionCache_bs;
import dm.jdbc.pool.DmdbConnectionEventListener_bs;
import dm.jdbc.pool.DmdbConnectionPoolDataSource;
import dm.jdbc.pool.DmdbDataSource;
import dm.jdbc.pool.DmdbPooledConnection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public class DmdbConnectionEventListener
implements ConnectionEventListener {
    private DmdbConnectionEventListener_bs rCEvnt = null;

    DmdbConnectionEventListener(DmdbConnectionEventListener_bs cevent) {
        this.rCEvnt = cevent;
    }

    public DmdbConnectionEventListener() {
        this.rCEvnt = new DmdbConnectionEventListener_bs();
    }

    DmdbConnectionEventListener_bs getRealCEvnt() {
        return this.rCEvnt;
    }

    @Override
    public synchronized void connectionClosed(ConnectionEvent event) {
        try {
            if (this.rCEvnt.checkDataSource()) {
                Object src = event.getSource();
                PooledConnection pc = null;
                pc = src instanceof DmdbPooledConnection ? ((DmdbPooledConnection)src).getRealPConn() : (PooledConnection)src;
                ((DmdbConnectionCache_bs)this.rCEvnt.getDataSource()).reusePooledConnection(pc);
            }
        }
        catch (SQLException _ex) {
            _ex.printStackTrace();
        }
    }

    @Override
    public synchronized void connectionErrorOccurred(ConnectionEvent event) {
        try {
            if (this.rCEvnt.checkDataSource()) {
                Object src = event.getSource();
                PooledConnection pc = null;
                pc = src instanceof DmdbPooledConnection ? ((DmdbPooledConnection)src).getRealPConn() : (PooledConnection)src;
                ((DmdbConnectionCache_bs)this.rCEvnt.getDataSource()).closePooledConnection(pc);
            }
        }
        catch (SQLException _ex) {
            _ex.printStackTrace();
        }
    }

    public void setDataSource(DataSource datasource) {
        if (datasource instanceof DmdbConnectionCache) {
            this.rCEvnt.setDataSource(((DmdbConnectionCache)datasource).getRealConnCache());
        }
        if (datasource instanceof DmdbConnectionPoolDataSource) {
            this.rCEvnt.setDataSource(((DmdbConnectionPoolDataSource)datasource).getRealPds());
        }
        if (datasource instanceof DmdbDataSource) {
            this.rCEvnt.setDataSource(((DmdbDataSource)datasource).getRealDbSrc());
        }
    }
}

